/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.translator.logic;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import net.sf.sqs_xml.httpd.SQSHttpdFactory;
import net.sf.sqs_xml.translator.logic.Translator;
import net.sf.sqs_xml.translator.logic.TranslatorException;
import net.sf.sqs_xml.translator.logic.TranslatorResource;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class AbstractTranslator
implements Translator {
    static final String SQS_PROPERTY_NAME = "sqs";
    static final ResourceBundle prop = ResourceBundle.getBundle("sqs");
    TransformerFactory tFactory = null;

    public static void main(String[] args, String message, String[] xsltFilenames, AbstractTranslator self, String baseuri) throws TranslatorException {
        if (args.length < 2) {
            System.err.println(message);
            return;
        }
        String inFile = args[0];
        String outFile = args[1];
        self.translate(inFile, new TranslatorResource((Logger)new ConsoleLogger(), xsltFilenames), outFile, baseuri);
    }

    public AbstractTranslator() throws TranslatorException {
        System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
        System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
        System.setProperty("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
        this.tFactory = TransformerFactory.newInstance();
        this.init();
    }

    public void init() throws TranslatorException {
        SQSHttpdFactory.getInitialHttpd();
    }

    public StreamSource createStreamSource(String href, String base) {
        try {
            URL baseURL = new URL(base);
            URL u = new URL(baseURL, href);
            return new StreamSource(u.openStream(), u.toString());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void translate(String sourceFile, TranslatorResource resource, String targetFile, String baseURI) throws TranslatorException {
        BufferedInputStream sourceInputStream = null;
        BufferedOutputStream targetOutputStream = null;
        try {
            try {
                targetOutputStream = new BufferedOutputStream(new FileOutputStream(targetFile));
                sourceInputStream = new BufferedInputStream(new FileInputStream(sourceFile));
                this.translate(sourceInputStream, resource, targetOutputStream, baseURI);
            }
            catch (IOException ex) {
                throw new TranslatorException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                sourceInputStream.close();
                targetOutputStream.flush();
                targetOutputStream.close();
                throw throwable;
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        try {}
        catch (Exception ignore) {
            return;
        }
        sourceInputStream.close();
        targetOutputStream.flush();
        targetOutputStream.close();
    }

    public void translate(InputStream inputStream, TranslatorResource resource, OutputStream outputStream, String baseURI) throws TranslatorException {
        if (!this.tFactory.getFeature("http://javax.xml.transform.sax.SAXSource/feature") || !this.tFactory.getFeature("http://javax.xml.transform.sax.SAXResult/feature")) {
            throw new TranslatorException("SAXSource.FEATURE and/or SAXResult.FEATURE are not supported.");
        }
        try {
            SAXTransformerFactory saxTFactory = (SAXTransformerFactory)this.tFactory;
            List list = resource.getXsltFilename();
            TransformerHandler[] tHandler = this.createTransformerHandlers(saxTFactory, list, baseURI);
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(tHandler[0]);
            this.execute(inputStream, resource, outputStream, tHandler[0], tHandler[list.size() - 1]);
            reader.parse(new InputSource(inputStream));
        }
        catch (SAXException ex) {
            throw new TranslatorException(ex);
        }
        catch (IOException ex) {
            throw new TranslatorException(ex);
        }
        catch (TransformerException ex) {
            throw new TranslatorException(ex);
        }
    }

    private TransformerHandler[] createTransformerHandlers(SAXTransformerFactory saxTFactory, List list, String baseURI) throws TransformerConfigurationException {
        TransformerHandler[] tHandler = new TransformerHandler[list.size()];
        int i = 0;
        while (i < list.size()) {
            String filename = (String)list.get(i);
            tHandler[i] = saxTFactory.newTransformerHandler(this.createStreamSource(filename, baseURI));
            tHandler[i].setSystemId(baseURI);
            this.initParameters(filename, tHandler[i]);
            if (i > 0) {
                tHandler[i - 1].setResult(new SAXResult(tHandler[i]));
            }
            ++i;
        }
        return tHandler;
    }

    public void execute(InputStream inputStream, TranslatorResource resource, OutputStream outputStream, TransformerHandler starterHandler, TransformerHandler terminatorHandler) throws TranslatorException {
        try {
            Serializer serializer = SerializerFactory.getSerializer((Properties)OutputPropertiesFactory.getDefaultMethodProperties((String)"xml"));
            serializer.setOutputStream(outputStream);
            terminatorHandler.setResult(new SAXResult(serializer.asContentHandler()));
        }
        catch (IOException ex) {
            throw new TranslatorException(ex);
        }
    }

    public void initParameters(String filename, TransformerHandler tHandler) {
        String[] params = this.getParameters(filename);
        Transformer transformer = tHandler.getTransformer();
        if (params != null) {
            int i = 0;
            while (i < params.length) {
                transformer.setParameter(params[i], params[i + 1]);
                i += 2;
            }
        }
    }

    public String[] getParameters(String filename) {
        return new String[0];
    }
}

