/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.File;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.InputHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public class TraxInputHandler
extends InputHandler {
    private Transformer transformer;
    private StreamSource xmlSource;
    private Source xsltSource;

    public TraxInputHandler(File xmlfile, File xsltfile) throws FOPException {
        this.xmlSource = new StreamSource(xmlfile);
        this.xsltSource = new StreamSource(xsltfile);
        this.initTransformer();
    }

    public TraxInputHandler(String xmlURL, String xsltURL) throws FOPException {
        this.xmlSource = new StreamSource(xmlURL);
        this.xsltSource = new StreamSource(xsltURL);
        this.initTransformer();
    }

    public TraxInputHandler(InputSource xmlSource, InputSource xsltSource) throws FOPException {
        this.xmlSource = new StreamSource(xmlSource.getByteStream(), xmlSource.getSystemId());
        this.xsltSource = new StreamSource(xsltSource.getByteStream(), xsltSource.getSystemId());
        this.initTransformer();
    }

    private void initTransformer() throws FOPException {
        try {
            this.transformer = TransformerFactory.newInstance().newTransformer(this.xsltSource);
        }
        catch (Exception ex) {
            throw new FOPException(ex);
        }
    }

    public InputSource getInputSource() {
        InputSource is = new InputSource();
        is.setByteStream(this.xmlSource.getInputStream());
        is.setSystemId(this.xmlSource.getSystemId());
        return is;
    }

    public XMLReader getParser() throws FOPException {
        return TraxInputHandler.getXMLFilter(this.xsltSource);
    }

    private static XMLFilter getXMLFilter(Source xsltSource) throws FOPException {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            if (tFactory.getFeature("http://javax.xml.transform.sax.SAXSource/feature") && tFactory.getFeature("http://javax.xml.transform.sax.SAXResult/feature")) {
                SAXTransformerFactory saxTFactory = (SAXTransformerFactory)tFactory;
                XMLFilter xmlfilter = saxTFactory.newXMLFilter(xsltSource);
                XMLReader parser = InputHandler.createParser();
                if (parser == null) {
                    throw new FOPException("Unable to create SAX parser");
                }
                xmlfilter.setParent(parser);
                return xmlfilter;
            }
            throw new FOPException("Your parser doesn't support the features SAXSource and SAXResult.\nMake sure you are using a xsl parser which supports TrAX");
        }
        catch (FOPException fex) {
            throw fex;
        }
        catch (Exception ex) {
            throw new FOPException(ex);
        }
    }

    public static XMLFilter getXMLFilter(File xmlfile, File xsltfile) throws FOPException {
        return TraxInputHandler.getXMLFilter(new StreamSource(xsltfile));
    }

    public void run(Driver driver) throws FOPException {
        try {
            this.transformer.transform(this.xmlSource, new SAXResult(driver.getContentHandler()));
        }
        catch (Exception ex) {
            throw new FOPException(ex);
        }
    }

    public void setParameter(String name, Object value) {
        this.transformer.setParameter(name, value);
    }
}

