/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import java.util.HashMap;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.FixedLength;
import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.datatypes.PercentLength;
import org.apache.fop.fo.ColorTypeProperty;
import org.apache.fop.fo.LengthProperty;
import org.apache.fop.fo.ListProperty;
import org.apache.fop.fo.NumberProperty;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.StringProperty;
import org.apache.fop.fo.expr.AbsFunction;
import org.apache.fop.fo.expr.BodyStartFunction;
import org.apache.fop.fo.expr.CeilingFunction;
import org.apache.fop.fo.expr.FloorFunction;
import org.apache.fop.fo.expr.FopPropValFunction;
import org.apache.fop.fo.expr.FromParentFunction;
import org.apache.fop.fo.expr.FromTableColumnFunction;
import org.apache.fop.fo.expr.Function;
import org.apache.fop.fo.expr.InheritedPropFunction;
import org.apache.fop.fo.expr.LabelEndFunction;
import org.apache.fop.fo.expr.MaxFunction;
import org.apache.fop.fo.expr.MinFunction;
import org.apache.fop.fo.expr.NCnameProperty;
import org.apache.fop.fo.expr.NearestSpecPropFunction;
import org.apache.fop.fo.expr.Numeric;
import org.apache.fop.fo.expr.NumericProperty;
import org.apache.fop.fo.expr.PPColWidthFunction;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.expr.PropertyInfo;
import org.apache.fop.fo.expr.PropertyTokenizer;
import org.apache.fop.fo.expr.RGBColorFunction;
import org.apache.fop.fo.expr.RoundFunction;

public class PropertyParser
extends PropertyTokenizer {
    private PropertyInfo propInfo;
    private static final String RELUNIT = "em";
    private static final Numeric negOne = new Numeric(new Double(-1.0));
    private static final HashMap functionTable = new HashMap();

    static {
        functionTable.put("ceiling", new CeilingFunction());
        functionTable.put("floor", new FloorFunction());
        functionTable.put("round", new RoundFunction());
        functionTable.put("min", new MinFunction());
        functionTable.put("max", new MaxFunction());
        functionTable.put("abs", new AbsFunction());
        functionTable.put("rgb", new RGBColorFunction());
        functionTable.put("from-table-column", new FromTableColumnFunction());
        functionTable.put("inherited-property-value", new InheritedPropFunction());
        functionTable.put("from-parent", new FromParentFunction());
        functionTable.put("from-nearest-specified-value", new NearestSpecPropFunction());
        functionTable.put("proportional-column-width", new PPColWidthFunction());
        functionTable.put("label-end", new LabelEndFunction());
        functionTable.put("body-start", new BodyStartFunction());
        functionTable.put("_fop-property-value", new FopPropValFunction());
    }

    public static Property parse(String expr, PropertyInfo propInfo) throws PropertyException {
        return new PropertyParser(expr, propInfo).parseProperty();
    }

    private PropertyParser(String propExpr, PropertyInfo pInfo) {
        super(propExpr);
        this.propInfo = pInfo;
    }

    private Property parseProperty() throws PropertyException {
        this.next();
        if (this.currentToken == 0) {
            return new StringProperty("");
        }
        ListProperty propList = null;
        while (true) {
            Property prop = this.parseAdditiveExpr();
            if (this.currentToken == 0) {
                if (propList != null) {
                    propList.addProperty(prop);
                    return propList;
                }
                return prop;
            }
            if (propList == null) {
                propList = new ListProperty(prop);
                continue;
            }
            propList.addProperty(prop);
        }
    }

    private Property parseAdditiveExpr() throws PropertyException {
        Property prop = this.parseMultiplicativeExpr();
        block4: while (true) {
            switch (this.currentToken) {
                case 8: {
                    this.next();
                    prop = this.evalAddition(prop.getNumeric(), this.parseMultiplicativeExpr().getNumeric());
                    continue block4;
                }
                case 9: {
                    this.next();
                    prop = this.evalSubtraction(prop.getNumeric(), this.parseMultiplicativeExpr().getNumeric());
                    continue block4;
                }
            }
            break;
        }
        return prop;
    }

    private Property parseMultiplicativeExpr() throws PropertyException {
        Property prop = this.parseUnaryExpr();
        block5: while (true) {
            switch (this.currentToken) {
                case 11: {
                    this.next();
                    prop = this.evalDivide(prop.getNumeric(), this.parseUnaryExpr().getNumeric());
                    continue block5;
                }
                case 10: {
                    this.next();
                    prop = this.evalModulo(prop.getNumber(), this.parseUnaryExpr().getNumber());
                    continue block5;
                }
                case 2: {
                    this.next();
                    prop = this.evalMultiply(prop.getNumeric(), this.parseUnaryExpr().getNumeric());
                    continue block5;
                }
            }
            break;
        }
        return prop;
    }

    private Property parseUnaryExpr() throws PropertyException {
        if (this.currentToken == 9) {
            this.next();
            return this.evalNegate(this.parseUnaryExpr().getNumeric());
        }
        return this.parsePrimaryExpr();
    }

    private final void expectRpar() throws PropertyException {
        if (this.currentToken != 4) {
            throw new PropertyException("expected )");
        }
        this.next();
    }

    private Property parsePrimaryExpr() throws PropertyException {
        Property prop;
        switch (this.currentToken) {
            case 3: {
                this.next();
                Property prop2 = this.parseAdditiveExpr();
                this.expectRpar();
                return prop2;
            }
            case 5: {
                prop = new StringProperty(this.currentTokenValue);
                break;
            }
            case 1: {
                prop = new NCnameProperty(this.currentTokenValue);
                break;
            }
            case 16: {
                prop = new NumberProperty(new Double(this.currentTokenValue));
                break;
            }
            case 17: {
                prop = new NumberProperty(new Integer(this.currentTokenValue));
                break;
            }
            case 14: {
                double pcval = new Double(this.currentTokenValue.substring(0, this.currentTokenValue.length() - 1)) / 100.0;
                PercentBase pcBase = this.propInfo.getPercentBase();
                if (pcBase != null) {
                    if (pcBase.getDimension() == 0) {
                        prop = new NumberProperty(pcval * pcBase.getBaseValue());
                        break;
                    }
                    if (pcBase.getDimension() == 1) {
                        prop = new LengthProperty(new PercentLength(pcval, pcBase));
                        break;
                    }
                    throw new PropertyException("Illegal percent dimension value");
                }
                prop = new NumberProperty(pcval);
                break;
            }
            case 12: {
                int numLen = this.currentTokenValue.length() - this.currentUnitLength;
                String unitPart = this.currentTokenValue.substring(numLen);
                Double numPart = new Double(this.currentTokenValue.substring(0, numLen));
                FixedLength length = null;
                length = unitPart.equals(RELUNIT) ? new FixedLength((double)numPart, this.propInfo.currentFontSize()) : new FixedLength((double)numPart, unitPart);
                if (length == null) {
                    throw new PropertyException("unrecognized unit name: " + this.currentTokenValue);
                }
                prop = new LengthProperty(length);
                break;
            }
            case 15: {
                prop = new ColorTypeProperty(new ColorType(this.currentTokenValue));
                break;
            }
            case 7: {
                Function function = (Function)functionTable.get(this.currentTokenValue);
                if (function == null) {
                    throw new PropertyException("no such function: " + this.currentTokenValue);
                }
                this.next();
                this.propInfo.pushFunction(function);
                Property prop3 = function.eval(this.parseArgs(function.nbArgs()), this.propInfo);
                this.propInfo.popFunction();
                return prop3;
            }
            default: {
                throw new PropertyException("syntax error");
            }
        }
        this.next();
        return prop;
    }

    Property[] parseArgs(int nbArgs) throws PropertyException {
        Property[] args = new Property[nbArgs];
        int i = 0;
        if (this.currentToken == 4) {
            this.next();
        } else {
            while (true) {
                Property prop = this.parseAdditiveExpr();
                if (i < nbArgs) {
                    args[i++] = prop;
                }
                if (this.currentToken != 13) break;
                this.next();
            }
            this.expectRpar();
        }
        if (nbArgs != i) {
            throw new PropertyException("Wrong number of args for function");
        }
        return args;
    }

    private Property evalAddition(Numeric op1, Numeric op2) throws PropertyException {
        if (op1 == null || op2 == null) {
            throw new PropertyException("Non numeric operand in addition");
        }
        return new NumericProperty(op1.add(op2));
    }

    private Property evalSubtraction(Numeric op1, Numeric op2) throws PropertyException {
        if (op1 == null || op2 == null) {
            throw new PropertyException("Non numeric operand in subtraction");
        }
        return new NumericProperty(op1.subtract(op2));
    }

    private Property evalNegate(Numeric op) throws PropertyException {
        if (op == null) {
            throw new PropertyException("Non numeric operand to unary minus");
        }
        return new NumericProperty(op.multiply(negOne));
    }

    private Property evalMultiply(Numeric op1, Numeric op2) throws PropertyException {
        if (op1 == null || op2 == null) {
            throw new PropertyException("Non numeric operand in multiplication");
        }
        return new NumericProperty(op1.multiply(op2));
    }

    private Property evalDivide(Numeric op1, Numeric op2) throws PropertyException {
        if (op1 == null || op2 == null) {
            throw new PropertyException("Non numeric operand in division");
        }
        return new NumericProperty(op1.divide(op2));
    }

    private Property evalModulo(Number op1, Number op2) throws PropertyException {
        if (op1 == null || op2 == null) {
            throw new PropertyException("Non number operand to modulo");
        }
        return new NumberProperty(op1.doubleValue() % op2.doubleValue());
    }
}

