/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import org.apache.fop.layout.Area;
import org.apache.fop.layout.FontState;
import org.apache.fop.render.Renderer;

public class AreaContainer
extends Area {
    private int xPosition;
    private int yPosition;
    private int position;
    private boolean isRegionArea = false;
    private String areaName;

    public AreaContainer(FontState fontState, int xPosition, int yPosition, int allocationWidth, int maxHeight, int position) {
        super(fontState, allocationWidth, maxHeight);
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.position = position;
    }

    public AreaContainer(FontState fontState, int xPosition, int yPosition, int allocationWidth, int maxHeight, int position, boolean isRegionArea) {
        this(fontState, xPosition, yPosition, allocationWidth, maxHeight, position);
        this.isRegionArea = isRegionArea;
    }

    public void render(Renderer renderer) {
        if (this.isRegionArea) {
            renderer.renderRegionAreaContainer(this);
        } else {
            renderer.renderAreaContainer(this);
        }
    }

    public int getPosition() {
        return this.position;
    }

    public int getXPosition() {
        return this.xPosition;
    }

    public void setXPosition(int value) {
        this.xPosition = value;
    }

    public int getYPosition() {
        return this.yPosition;
    }

    public int getCurrentYPosition() {
        return this.yPosition;
    }

    public void setYPosition(int value) {
        this.yPosition = value;
    }

    public void shiftYPosition(int value) {
        this.yPosition += value;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }
}

