/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.IDReferences;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageArea;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BodyAreaContainer;
import org.apache.fop.layout.Box;
import org.apache.fop.layout.DisplaySpace;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.SpanArea;
import org.apache.fop.layout.inline.ForeignObjectArea;
import org.apache.fop.layout.inline.InlineArea;
import org.apache.fop.layout.inline.InlineSpace;
import org.apache.fop.layout.inline.LeaderArea;
import org.apache.fop.layout.inline.WordArea;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.pdf.FontSetup;
import org.apache.fop.svg.SVGArea;

public class XMLRenderer
implements Renderer {
    protected Logger log;
    protected int indent = 0;
    protected String producer;
    protected PrintWriter writer;
    protected Map options;
    private boolean consistentOutput = false;
    protected IDReferences idReferences;

    public void setLogger(Logger logger) {
        this.log = logger;
    }

    public void setOptions(Map options) {
        this.options = options;
        Boolean con = (Boolean)options.get("consistentOutput");
        if (con != null) {
            this.consistentOutput = con;
        }
    }

    public void setProducer(String producer) {
        this.producer = producer;
    }

    public void render(Page page, OutputStream outputStream) throws IOException {
        this.idReferences = page.getIDReferences();
        this.renderPage(page);
    }

    protected void writeIndent() {
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < this.indent) {
            s = s.append("  ");
            ++i;
        }
        this.writer.write(s.toString());
    }

    protected void writeElement(String element) {
        this.writeIndent();
        this.writer.write(String.valueOf(element) + "\n");
    }

    protected void writeEmptyElementTag(String tag) {
        this.writeIndent();
        this.writer.write(String.valueOf(tag) + "\n");
    }

    protected void writeEndTag(String tag) {
        --this.indent;
        this.writeIndent();
        this.writer.write(String.valueOf(tag) + "\n");
    }

    protected void writeStartTag(String tag) {
        this.writeIndent();
        this.writer.write(String.valueOf(tag) + "\n");
        ++this.indent;
    }

    public void setupFontInfo(FontInfo fontInfo) throws FOPException {
        FontSetup.setup(fontInfo);
    }

    protected void drawImageScaled(int x, int y, int w, int h, FopImage image, FontState fs) {
    }

    protected void drawImageClipped(int x, int y, int clipX, int clipY, int clipW, int clipH, FopImage image, FontState fs) {
    }

    public void renderAreaContainer(AreaContainer area) {
        this.writeStartTag("<AreaContainer name=\"" + area.getAreaName() + "\">");
        ArrayList children = area.getChildren();
        int i = 0;
        while (i < children.size()) {
            Box b = (Box)children.get(i);
            b.render(this);
            ++i;
        }
        this.writeEndTag("</AreaContainer>");
    }

    public void renderBodyAreaContainer(BodyAreaContainer area) {
        this.writeStartTag("<BodyAreaContainer>");
        ArrayList children = area.getChildren();
        int i = 0;
        while (i < children.size()) {
            Box b = (Box)children.get(i);
            b.render(this);
            ++i;
        }
        this.writeEndTag("</BodyAreaContainer>");
    }

    public void renderRegionAreaContainer(AreaContainer area) {
        this.renderAreaContainer(area);
    }

    public void renderSpanArea(SpanArea area) {
        this.writeStartTag("<SpanArea>");
        ArrayList children = area.getChildren();
        int i = 0;
        while (i < children.size()) {
            Box b = (Box)children.get(i);
            b.render(this);
            ++i;
        }
        this.writeEndTag("</SpanArea>");
    }

    public void renderBlockArea(BlockArea area) {
        StringBuffer baText = new StringBuffer();
        baText.append("<BlockArea start-indent=\"" + area.getStartIndent() + "\"");
        baText.append(" end-indent=\"" + area.getEndIndent() + "\"");
        baText.append("\nis-first=\"" + area.isFirst() + "\"");
        baText.append(" is-last=\"" + area.isLast() + "\"");
        if (area.getGeneratedBy() != null) {
            baText.append(" generated-by=\"" + area.getGeneratedBy().getName() + "//");
        }
        if (this.consistentOutput) {
            baText.append(area.getGeneratedBy().getClass() + "\"");
        } else {
            baText.append(area.getGeneratedBy() + "\"");
        }
        baText.append(">");
        this.writeStartTag(baText.toString());
        ArrayList children = area.getChildren();
        int i = 0;
        while (i < children.size()) {
            Box b = (Box)children.get(i);
            b.render(this);
            ++i;
        }
        this.writeEndTag("</BlockArea>");
    }

    public void renderInlineArea(InlineArea area) {
        StringBuffer iaText = new StringBuffer();
        iaText.append("<InlineArea");
        iaText.append("\nis-first=\"" + area.isFirst() + "\"");
        iaText.append(" is-last=\"" + area.isLast() + "\"");
        if (area.getGeneratedBy() != null) {
            iaText.append(" generated-by=\"" + area.getGeneratedBy().getName() + "//" + area.getGeneratedBy() + "\"");
        }
        iaText.append(">");
        this.writeStartTag(iaText.toString());
        ArrayList children = area.getChildren();
        int i = 0;
        while (i < children.size()) {
            Box b = (Box)children.get(i);
            b.render(this);
            ++i;
        }
        this.writeEndTag("</InlineArea>");
    }

    public void renderDisplaySpace(DisplaySpace space) {
        if (!this.isCoarseXml()) {
            this.writeEmptyElementTag("<DisplaySpace size=\"" + space.getSize() + "\"/>");
        }
    }

    public void renderForeignObjectArea(ForeignObjectArea area) {
        area.getObject().render(this);
    }

    public void renderSVGArea(SVGArea area) {
        this.writeEmptyElementTag("<SVG/>");
    }

    public void renderImageArea(ImageArea area) {
        this.writeEmptyElementTag("<ImageArea/>");
    }

    public void renderWordArea(WordArea area) {
        String fontWeight = area.getFontState().getFontWeight();
        StringBuffer sb = new StringBuffer();
        String s = area.getText();
        int l = s.length();
        int i = 0;
        while (i < l) {
            char ch = s.charAt(i);
            sb = ch > '\u007f' ? sb.append("&#" + ch + ";") : sb.append(ch);
            ++i;
        }
        if (!this.isCoarseXml()) {
            this.writeElement("<WordArea font-weight=\"" + fontWeight + "\" red=\"" + area.getRed() + "\" green=\"" + area.getGreen() + "\" blue=\"" + area.getBlue() + "\" width=\"" + area.getContentWidth() + "\">" + sb.toString() + "</WordArea>");
        } else {
            this.writer.write(sb.toString());
        }
    }

    public void renderInlineSpace(InlineSpace space) {
        if (!this.isCoarseXml()) {
            this.writeEmptyElementTag("<InlineSpace size=\"" + space.getSize() + "\"/>");
        } else {
            this.writer.write(" ");
        }
    }

    public void renderLineArea(LineArea area) {
        if (!this.isCoarseXml()) {
            String fontWeight = area.getFontState().getFontWeight();
            this.writeStartTag("<LineArea font-weight=\"" + fontWeight + "\">");
        }
        ArrayList children = area.getChildren();
        int i = 0;
        while (i < children.size()) {
            Box b = (Box)children.get(i);
            b.render(this);
            ++i;
        }
        if (!this.isCoarseXml()) {
            this.writeEndTag("</LineArea>");
        } else {
            this.writer.write("\n");
        }
    }

    public void renderPage(Page page) {
        this.writeStartTag("<Page number=\"" + page.getFormattedNumber() + "\">");
        BodyAreaContainer body = page.getBody();
        AreaContainer before = page.getBefore();
        AreaContainer after = page.getAfter();
        AreaContainer start = page.getStart();
        AreaContainer end = page.getEnd();
        if (before != null) {
            before.render(this);
        }
        if (after != null) {
            after.render(this);
        }
        if (start != null) {
            start.render(this);
        }
        if (end != null) {
            end.render(this);
        }
        if (body != null) {
            body.render(this);
        }
        this.writeEndTag("</Page>");
    }

    public void renderLeaderArea(LeaderArea area) {
        if (this.isCoarseXml()) {
            return;
        }
        String leaderPattern = "";
        switch (area.getLeaderPattern()) {
            case 105: {
                leaderPattern = "space";
                break;
            }
            case 100: {
                leaderPattern = "rule";
                break;
            }
            case 26: {
                leaderPattern = "dots";
                break;
            }
            case 124: {
                leaderPattern = "use-content";
            }
        }
        this.writeEmptyElementTag("<Leader leader-pattern=\"" + leaderPattern + " leader-length=\"" + area.getLeaderLength() + "\" rule-thickness=\"" + area.getRuleThickness() + "\" rule-style=\"" + area.getRuleStyle() + "\" red=\"" + area.getRed() + "\" green=\"" + area.getGreen() + "\" blue=\"" + area.getBlue() + "\"/>");
    }

    private boolean isCoarseXml() {
        if (this.options == null) {
            return false;
        }
        Boolean b = (Boolean)this.options.get("fineDetail");
        if (b != null) {
            return b;
        }
        return false;
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        this.log.debug("rendering areas to XML");
        this.writer = new PrintWriter(outputStream);
        this.writer.write("<?xml version=\"1.0\"?>\n<!-- produced by " + this.producer + " -->\n");
        this.writeStartTag("<AreaTree>");
    }

    public void stopRenderer(OutputStream outputStream) throws IOException {
        this.writeEndTag("</AreaTree>");
        this.writer.flush();
        this.log.debug("written out XML");
    }

    public IDReferences getIDReferences() {
        return this.idReferences;
    }
}

