/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.base.swing;

import net.sf.sqs_xml.editor.base.source.DOMTreeSource;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class NodeFunctions {
    NodeFunctions() {
    }

    static Node createNode(DOMTreeSource source, Node node) {
        Document document = source.getDocument();
        if (node instanceof Element) {
            Element ret = document.createElementNS(node.getNamespaceURI(), node.getLocalName());
            NodeFunctions.setAttributeNode(source, node, ret);
            NodeFunctions.appendChild(source, node, ret);
            return ret;
        }
        if (node instanceof Attr) {
            Attr ret = document.createAttributeNS(node.getNamespaceURI(), node.getLocalName());
            ret.setNodeValue(node.getNodeValue());
            return ret;
        }
        if (node instanceof Text) {
            return document.createTextNode(node.getNodeValue());
        }
        return null;
    }

    static void appendChild(DOMTreeSource source, Node node, Element ret) {
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            ret.appendChild(NodeFunctions.createNode(source, list.item(i)));
            ++i;
        }
    }

    static void setAttributeNode(DOMTreeSource source, Node node, Element ret) {
        NamedNodeMap attList = node.getAttributes();
        int i = 0;
        while (i < attList.getLength()) {
            ret.setAttributeNodeNS((Attr)NodeFunctions.createNode(source, attList.item(i)));
            ++i;
        }
    }
}

