/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.image;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import net.sf.sqs_xml.image.RasterFactory;

public class PBMRasterFactory {
    InputStream in;

    public PBMRasterFactory(InputStream in) {
        this.in = in;
    }

    private int getHeight() throws IOException {
        int c = this.skipIfCommentLine();
        int height = this.parseIntValue(this.in, c);
        return height;
    }

    private int getWidth() throws IOException {
        this.in.read();
        int c = this.skipIfCommentLine();
        int width = this.parseIntValue(this.in, c);
        return width;
    }

    private int getType() throws IOException {
        int c = this.skipIfCommentLine();
        if (c != 80) {
            throw new IllegalArgumentException("data format may not be PNM");
        }
        int type = this.in.read() - 52;
        if (type < 0 || 2 < type) {
            throw new IllegalArgumentException("data type is invalid");
        }
        return type;
    }

    private int skipIfCommentLine() throws IOException {
        int c = this.in.read();
        if (c == 35) {
            while ((c = this.in.read()) != 10) {
            }
            c = this.in.read();
        }
        return c;
    }

    private int parseIntValue(InputStream in, int c) throws IOException {
        int value = 0;
        while (48 <= c && c <= 57) {
            value = value * 10 + c - 48;
            c = in.read();
        }
        return value;
    }

    public BufferedImage createByPBM() throws IOException, IllegalArgumentException {
        int type = this.getType();
        int width = this.getWidth();
        int height = this.getHeight();
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("width or height may be 0");
        }
        int nColors = this.getNumColors(type);
        BufferedImage image = new BufferedImage(width, height, 1);
        WritableRaster ret = image.getRaster();
        switch (type) {
            case 0: {
                this.createImageByPBM(ret, width, height);
                break;
            }
            default: {
                throw new IllegalArgumentException("not supported format type");
            }
        }
        return image;
    }

    private void createImageByPBM(WritableRaster ret, int width, int height) throws IOException {
        int length = width >> 3;
        byte[] line = new byte[(width + 7) / 8];
        int i = 0;
        while (i < height) {
            this.in.read(line);
            int j = 0;
            while (j < length) {
                int bits = ~line[j];
                int len = j * 8 <= width ? 8 : j * 8 - width;
                int k = 0;
                while (k < len) {
                    if ((bits >> 8 - k & 1) == 1) {
                        ret.setPixel(j * 8 + k, i, RasterFactory.WHITE);
                    } else {
                        ret.setPixel(j * 8 + k, i, RasterFactory.BLACK);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private int getNumColors(int type) throws IOException {
        int nColors = 0;
        if (type == 0) {
            nColors = 2;
        } else {
            int c = this.skipIfCommentLine();
            nColors = this.parseIntValue(this.in, c);
            if (nColors < 1 || 256 < nColors) {
                throw new IllegalArgumentException("color " + nColors + " is Exceeded");
            }
            ++nColors;
        }
        return nColors;
    }
}

