/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.reader.logic;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLEncoder;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.sqs_xml.httpd.MarkReaderHttpd;
import net.sf.sqs_xml.reader.logic.BaseTaskSource;
import net.sf.sqs_xml.reader.logic.BaseTaskTarget;
import net.sf.sqs_xml.reader.logic.FileFunctions;
import net.sf.sqs_xml.reader.logic.ReaderCoreTask;
import net.sf.sqs_xml.reader.logic.ReaderProcessView;
import net.sf.sqs_xml.reader.logic.ThreadSuspendingException;
import net.sf.sqs_xml.translator.logic.TranslatorException;
import net.sf.sqs_xml.util.AlbertBrowserLauncher;
import net.sf.sqs_xml.util.FileUtil;
import net.sf.sqs_xml.util.JNLPBrowserLauncher;

class ReaderResultTask
extends ReaderCoreTask {
    static final String MS932_FILE_ENCODING = "MS932";
    static final String UTF8_FILE_ENCODING = "UTF-8";

    public ReaderResultTask(BaseTaskSource source, BaseTaskTarget target, ReaderProcessView view) {
        super(source, target, view);
    }

    public void save() throws TranslatorException, TransformerException, IOException, ParserConfigurationException, ThreadSuspendingException {
        String name = this.getSource().srcdir.getParent() + File.separator + this.getSource().srcdir.getName();
        File tgtdir = this.getSource().tgtdir;
        File allIndexFile = new File(tgtdir.getAbsolutePath() + File.separator + "all.html");
        File textareaIndexFile = new File(tgtdir.getAbsolutePath() + File.separator + "textarea.html");
        File markIndexFile = new File(tgtdir.getAbsolutePath() + File.separator + "mark.html");
        File indexHtml = new File(tgtdir.getAbsolutePath() + File.separator + "index.html");
        File csvfile = new File(tgtdir.getAbsolutePath() + File.separator + this.getSource().srcdir.getName() + "-csv.txt");
        if (this.processScanFramesTaskTarget.mapper.getNumErrorPages() == 0) {
            this.saveCSV(csvfile);
        }
        this.saveTextareaIndexHtml(textareaIndexFile, tgtdir);
        this.saveMarkIndexHtml(markIndexFile, tgtdir);
        this.saveAllHtml(allIndexFile, tgtdir);
        this.saveIndexHtml(tgtdir, indexHtml, allIndexFile, textareaIndexFile, markIndexFile, csvfile);
        this.showDocument(indexHtml);
    }

    private void saveIndexHtml(File resultDir, File indexHtml, File allIndexFile, File textareaIndexFile, File markIndexFile, File csvfile) throws IOException {
        String encoding = UTF8_FILE_ENCODING;
        PrintWriter out = FileUtil.createPrintWriter(indexHtml, encoding);
        File pdffile = (File)this.getSource().pdffileList.get(0);
        String pdfPath = FileFunctions.getRelativePath(this.getSource().tgtdir, pdffile);
        String baseURI = MarkReaderHttpd.getSingleton().getBase();
        baseURI = baseURI.substring(0, baseURI.length() - 1);
        out.println("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
        out.println("<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"ja\" xml:lang=\"ja\">");
        out.println("<head>");
        out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + encoding + "\" />");
        out.println("<style type=\"text/css\">img{border-width:0} body{background-color: #fff} strong{color: #a30; background-color: #ffa; font-size: 90%;}h2{border-style: solid;border-width: 0em 0em 0em 1em;border-color: #183579;padding: 0.2em 0.7em 0.1em 0.3em;margin-bottom: 0.7em;margin-top: 0em;}");
        out.println("div.console{padding: 0.3em;}fieldset{background-color: #ddd;}legend{border-style: solid;border-color:#888;border-width: 0.05em 0.05em 0.00em 0.05em;padding: 0.2em 0.2em 0.2em 0.2em;color:#1835f9;background-color: #ddd;}");
        out.println("h3{border-style: solid;border-width: 0em 0em 0em 1em;border-color: #183579;padding: 0.2em 0.7em 0.1em 0.3em;margin: 1em 1em 1em 1em;margin-top: 1em;}");
        out.println("</style>");
        out.print("<title>");
        out.print(indexHtml.getAbsolutePath());
        out.println("</title>");
        out.println("</head>");
        out.println("<body>");
        out.println("<h1><img src=\"" + baseURI + "/sqs-logo.png\" alt=\"Shared Questionnaire System\"/></h1>");
        out.println("<p><strong>\u203b\u73fe\u5728\u8868\u793a\u3055\u308c\u3066\u3044\u308bWeb\u30da\u30fc\u30b8\u306f [\u51e6\u7406\u7d50\u679c\u30d5\u30a9\u30eb\u30c0]\u5185\u306eindex.html\u30d5\u30a1\u30a4\u30eb\u306e\u5185\u5bb9\u3067\u3059\uff0e</strong></p>");
        out.println("<h2>\u51e6\u7406\u5bfe\u8c61\u30d5\u30a9\u30eb\u30c0:<a href=\"" + this.getSource().srcdir.toURI().toURL() + "\">" + this.getSource().srcdir.getAbsolutePath() + "</a></h2>");
        out.println("<ul>");
        out.println("<li><a href=\"../" + pdfPath + "\">\u5370\u5237\u539f\u7a3fPDF\u30d5\u30a1\u30a4\u30eb: " + pdffile.getName() + "</a></li>");
        out.println("</ul>");
        out.println("<h2>\u51e6\u7406\u7d50\u679c\u30d5\u30a9\u30eb\u30c0:<a href=\"" + indexHtml.toURI().toURL() + "\">" + indexHtml.getAbsolutePath() + "</a></h2>");
        out.println("<h3>\u7d50\u679c\u4e00\u89a7:</h3>");
        out.println("<p><strong>\u203b\u6b21\u306e2x2\u306e\u4e00\u89a7\u30da\u30fc\u30b8\u2193\u306f\uff0cMarkReader\u3092\u8d77\u52d5\u3057\u3066\u3044\u306a\u3044\u6642\u306b\u306f\uff0c[\u51e6\u7406\u7d50\u679c\u30d5\u30a9\u30eb\u30c0]\u5185\u306e\u30d5\u30a1\u30a4\u30eb\u304b\u3089\u30a2\u30af\u30bb\u30b9\u3057\u3066\u304f\u3060\u3055\u3044\uff0e</strong></p>");
        out.println("<ul>");
        out.println("<li>\u5185\u5bb9\u4e00\u89a7:<ul>");
        out.println("<li><a href=\"" + csvfile.getName() + "\">CSV\u5f62\u5f0f: " + csvfile.getName() + "</a></li>");
        out.println("<li><a href=\"" + markIndexFile.getName() + "\">HTML\u5f62\u5f0f: " + markIndexFile.getName() + "</a></li>");
        out.println("</ul></li>");
        out.println("<li>\u753b\u50cf\u4e00\u89a7:<ul>");
        out.println("<li><a href=\"" + allIndexFile.getName() + "\">\u30de\u30fc\u30af\u6b04+\u81ea\u7531\u8a18\u8ff0\u6b04\u753b\u50cf\u306e\u4e00\u89a7: " + allIndexFile.getName() + "</a></li>");
        out.println("<li><a href=\"" + textareaIndexFile.getName() + "\">\u81ea\u7531\u8a18\u8ff0\u6b04\u753b\u50cf\u306e\u4e00\u89a7: " + textareaIndexFile.getName() + "</a></li>");
        out.println("</ul></li>");
        out.println("</ul>");
        out.println("<h3>\u81ea\u7531\u8a18\u8ff0\u6b04\u753b\u50cf\u306e\u30c6\u30ad\u30b9\u30c8\u8d77\u3053\u3057:</h3>");
        out.println("<p><strong>\u203b\u6b21\u306e2\u3064\u306e\u30da\u30fc\u30b8\u2193\u306f\uff0cMarkReader\u3092\u8d77\u52d5\u3057\u3066\u304b\u3089\u30a2\u30af\u30bb\u30b9\u3057\u3066\u304f\u3060\u3055\u3044\uff0e</strong></p>");
        out.println("<ul>");
        out.println("<li><a href=\"" + baseURI + "/servlet/ViewMatrix" + "?dir=" + URLEncoder.encode(this.getSource().tgtdir.getAbsolutePath(), UTF8_FILE_ENCODING) + "&amp;src=all.html\">\u30de\u30fc\u30af\u6b04+\u81ea\u7531\u8a18\u8ff0\u6b04\u753b\u50cf</a></li>");
        out.println("<li><a href=\"" + baseURI + "/servlet/ViewMatrix" + "?dir=" + URLEncoder.encode(this.getSource().tgtdir.getAbsolutePath(), UTF8_FILE_ENCODING) + "\">\u81ea\u7531\u8a18\u8ff0\u6b04\u753b\u50cf</a></li>");
        out.println("</ul>");
        out.println("<p>CSV\u5f62\u5f0f\u30d5\u30a1\u30a4\u30eb(-csv.txt)\u3068\uff0cHTML\u5f62\u5f0f(mark.html)\u306e\uff0c\u8a72\u5f53\u90e8\u5206\u306e\u30ab\u30e9\u30e0\u304c\u66f4\u65b0\u3055\u308c\u307e\u3059</p>");
        out.println("<hr/>");
        out.println("<div class=\"console\">");
        out.println("<form method=\"get\" action=\"http://sqs.cmr.sfc.keio.ac.jp/sqs-core/app/MarkReader.jnlp\">");
        out.println("<fieldset>");
        out.println("<legend>SQS MarkReader\u306e\u8d77\u52d5</legend>");
        out.println("<img src=\"" + baseURI + "/reader.gif\" alt=\"SQS MarkReader\"/>");
        out.println("<input value=\"SQS MarkReader\u306e\u8d77\u52d5\" type=\"submit\"/>");
        out.println("</fieldset>");
        out.println("</form>");
        out.println("</div>");
        out.println("<address>Generated by <a href=\"http://sqs.cmr.sfc.keio.ac.jp/\">");
        out.println("SQS MarkReader(2004/11/10)");
        out.println("</a></address>");
        out.println("</body>");
        out.println("</html>");
        out.close();
    }

    private void showDocument(File indexHtml) throws IOException {
        URL url = MarkReaderHttpd.getSingleton().getURL(indexHtml);
        try {
            BasicService basicService = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            if (basicService.isWebBrowserSupported()) {
                new JNLPBrowserLauncher(basicService).showDocument(url);
            } else {
                new AlbertBrowserLauncher().showDocument(url);
            }
        }
        catch (UnavailableServiceException ignore) {
            new AlbertBrowserLauncher().showDocument(url);
        }
    }

    private void saveAllHtml(File allIndexFile, File resultDir) throws TransformerException, ThreadSuspendingException {
        while (true) {
            try {
                this.initQuestionnaireStructureTaskTarget.resultBuilder.saveHTML(allIndexFile, UTF8_FILE_ENCODING, this.getSource().srcdir, resultDir, 0);
            }
            catch (IOException ex) {
                FileFunctions.confirmRetryPageSaving(this.view, ex, allIndexFile);
                continue;
            }
            break;
        }
    }

    private void saveTextareaIndexHtml(File textareaIndexFile, File resultDir) throws TransformerException, ThreadSuspendingException {
        while (true) {
            try {
                this.initQuestionnaireStructureTaskTarget.resultBuilder.saveHTML(textareaIndexFile, UTF8_FILE_ENCODING, this.getSource().srcdir, resultDir, 1);
            }
            catch (IOException ex) {
                FileFunctions.confirmRetryPageSaving(this.view, ex, textareaIndexFile);
                continue;
            }
            break;
        }
    }

    private void saveMarkIndexHtml(File markIndexFile, File resultDir) throws TransformerException, ThreadSuspendingException {
        while (true) {
            try {
                this.initQuestionnaireStructureTaskTarget.resultBuilder.saveHTML(markIndexFile, UTF8_FILE_ENCODING, this.getSource().srcdir, resultDir, 2);
            }
            catch (IOException ex) {
                FileFunctions.confirmRetryPageSaving(this.view, ex, markIndexFile);
                continue;
            }
            break;
        }
    }

    private void saveCSV(File tgtfile) throws TransformerException, ThreadSuspendingException {
        while (true) {
            try {
                while (tgtfile == null) {
                }
                this.initQuestionnaireStructureTaskTarget.resultBuilder.saveCSV(tgtfile, MS932_FILE_ENCODING);
            }
            catch (IOException ex) {
                FileFunctions.confirmRetryPageSaving(this.view, ex, tgtfile);
                continue;
            }
            break;
        }
    }
}

