/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.utils;

public final class HexBin {
    private static final int BASELENGTH = 255;
    private static final int LOOKUPLENGTH = 16;
    private static byte[] hexNumberTable = new byte[255];
    private static byte[] lookUpHexAlphabet = new byte[16];

    static final boolean isHex(byte by) {
        return hexNumberTable[by] != -1;
    }

    static final boolean isArrayByteHex(byte[] byArray) {
        if (byArray == null) {
            return false;
        }
        int n = byArray.length;
        if (n % 2 != 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (!HexBin.isHex(byArray[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static final boolean isHex(String string) {
        if (string == null) {
            return false;
        }
        return HexBin.isArrayByteHex(string.getBytes());
    }

    public static final byte[] encode(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        int n2 = n * 2;
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        while (n3 < n) {
            byArray2[n3 * 2] = lookUpHexAlphabet[byArray[n3] >> 4];
            byArray2[n3 * 2 + 1] = lookUpHexAlphabet[byArray[n3] & 0xF];
            ++n3;
        }
        return byArray2;
    }

    public static final byte[] decode(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        if (n % 2 != 0) {
            return null;
        }
        int n2 = n / 2;
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray2[n3] = (byte)(hexNumberTable[byArray[n3 * 2]] << 4 | hexNumberTable[byArray[n3 * 2 + 1]]);
            ++n3;
        }
        return byArray2;
    }

    public static final int getDecodedDataLength(byte[] byArray) {
        if (!HexBin.isArrayByteHex(byArray)) {
            return -1;
        }
        return byArray.length / 2;
    }

    static {
        int n = 0;
        while (n < 255) {
            HexBin.hexNumberTable[n] = -1;
            ++n;
        }
        n = 57;
        while (n >= 48) {
            HexBin.hexNumberTable[n] = (byte)(n - 48);
            --n;
        }
        n = 70;
        while (n >= 65) {
            HexBin.hexNumberTable[n] = (byte)(n - 65 + 10);
            --n;
        }
        n = 102;
        while (n >= 97) {
            HexBin.hexNumberTable[n] = (byte)(n - 97 + 10);
            --n;
        }
        n = 0;
        while (n < 10) {
            HexBin.lookUpHexAlphabet[n] = (byte)(48 + n);
            ++n;
        }
        n = 10;
        while (n <= 15) {
            HexBin.lookUpHexAlphabet[n] = (byte)(65 + n - 10);
            ++n;
        }
    }
}

