/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.dtd;

import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.framework.XMLContentSpec;
import org.apache.xerces.framework.XMLDTDScanner;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.common.Grammar;
import org.apache.xerces.validators.common.XMLAttributeDecl;
import org.apache.xerces.validators.common.XMLElementDecl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;

public class DTDGrammar
extends Grammar
implements XMLDTDScanner.EventHandler {
    private static final int CHUNK_SHIFT = 8;
    private static final int CHUNK_SIZE = 256;
    private static final int CHUNK_MASK = 255;
    private static final int INITIAL_CHUNK_COUNT = 4;
    private StringPool fStringPool;
    private XMLElementDecl fElementDecl = new XMLElementDecl();
    private XMLAttributeDecl fAttributeDecl = new XMLAttributeDecl();
    private XMLContentSpec fContentSpec = new XMLContentSpec();
    private Document fGrammarDocument;
    private Element fRootElement;
    private QName fRootElementQName = new QName();
    private Element fCurrentElement;
    private int[][] fElementDeclIsExternal = new int[4][];
    private int[][] fElementDeclMap = new int[4][];
    private int[][] fAttributeDeclIsExternal = new int[4][];
    private int[][] fAttributeDeclMap = new int[4][];
    private int[][] fContentSpecMap = new int[4][];
    private QName fQName = new QName();
    private XMLContentSpec fTempContentSpec = new XMLContentSpec();

    public void reset(StringPool stringPool) {
        this.fStringPool = stringPool;
    }

    public void callStartDTD() throws Exception {
        this.setGrammarDocument(null);
        this.fGrammarDocument = new DocumentImpl();
        this.fCurrentElement = this.fRootElement = this.fGrammarDocument.createElement("dtd");
    }

    public void callEndDTD() throws Exception {
        this.setGrammarDocument(this.fGrammarDocument);
    }

    public void callTextDecl(int n, int n2) throws Exception {
        Element element = this.fGrammarDocument.createElement("textDecl");
        element.setAttribute("version", this.fStringPool.toString(n));
        element.setAttribute("encoding", this.fStringPool.toString(n2));
        this.fCurrentElement.appendChild(element);
    }

    public void doctypeDecl(QName qName, int n, int n2) throws Exception {
        Element element = this.fGrammarDocument.createElement("doctypeDecl");
        element.setAttribute("name", this.fStringPool.toString(qName.rawname));
        if (qName.uri != 0) {
            element.setAttribute("xmlns:" + this.fStringPool.toString(qName.prefix), this.fStringPool.toString(qName.uri));
        }
        element.setAttribute("publicId", this.fStringPool.toString(n));
        element.setAttribute("systemId", this.fStringPool.toString(n2));
        this.fCurrentElement.appendChild(element);
        this.fRootElementQName.setValues(qName);
    }

    public void startReadingFromExternalSubset(int n, int n2) throws Exception {
        Element element = this.fGrammarDocument.createElement("external");
        element.setAttribute("publicId", this.fStringPool.toString(n));
        element.setAttribute("systemId", this.fStringPool.toString(n2));
        this.fCurrentElement.appendChild(element);
        this.fCurrentElement = element;
    }

    public void stopReadingFromExternalSubset() throws Exception {
        this.fCurrentElement = (Element)this.fCurrentElement.getParentNode();
    }

    public int addElementDecl(QName qName) throws Exception {
        Element element = this.fGrammarDocument.createElement("elementDecl");
        element.setAttribute("name", this.fStringPool.toString(qName.localpart));
        if (qName.uri != 0) {
            element.setAttribute("xmlns:" + this.fStringPool.toString(qName.prefix), this.fStringPool.toString(qName.uri));
        }
        this.fCurrentElement.appendChild(element);
        int n = this.createElementDecl();
        this.fElementDecl.clear();
        this.fElementDecl.name.setValues(qName);
        this.setElementDecl(n, this.fElementDecl);
        return n;
    }

    public int addElementDecl(QName qName, int n, int n2, boolean bl) throws Exception {
        Element element = this.fGrammarDocument.createElement("elementDecl");
        element.setAttribute("name", this.fStringPool.toString(qName.localpart));
        if (qName.uri != 0) {
            element.setAttribute("xmlns:" + this.fStringPool.toString(qName.prefix), this.fStringPool.toString(qName.uri));
        }
        element.setAttribute("type", this.fStringPool.toString(n));
        this.fCurrentElement.appendChild(element);
        int n3 = this.createElementDecl();
        this.fElementDecl.clear();
        this.fElementDecl.name.setValues(qName);
        this.fElementDecl.type = n;
        this.fElementDecl.contentSpecIndex = n2;
        this.setElementDecl(n3, this.fElementDecl);
        int n4 = n3 >> 8;
        int n5 = n3 & 0xFF;
        this.ensureElementDeclCapacity(n4);
        this.fElementDeclIsExternal[n4][n5] = bl ? 1 : 0;
        return n3;
    }

    protected void putElementNameMapping(QName qName, int n, int n2) {
        this.fQName.uri = 0;
        this.fQName.localpart = qName.rawname;
        super.putElementNameMapping(this.fQName, n, n2);
    }

    public int getElementDeclIndex(QName qName, int n) {
        return super.getElementDeclIndex(qName.rawname, -1);
    }

    public void setElementDeclDTD(int n, XMLElementDecl xMLElementDecl) {
        super.setElementDecl(n, xMLElementDecl);
    }

    public void setElementDeclIsExternal(int n, boolean bl) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        this.ensureElementDeclCapacity(n2);
        this.fElementDeclIsExternal[n2][n3] = bl ? 1 : 0;
    }

    public boolean getElementDeclIsExternal(int n) {
        if (n < 0) {
            return false;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fElementDeclIsExternal[n2][n3] != 0;
    }

    public boolean getAttributeDeclIsExternal(int n) {
        if (n < 0) {
            return false;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fAttributeDeclIsExternal[n2][n3] != 0;
    }

    public boolean getRootElementQName(QName qName) {
        if (this.fRootElementQName.rawname == -1) {
            return false;
        }
        qName.setValues(this.fRootElementQName);
        return true;
    }

    public int addAttDef(QName qName, QName qName2, int n, boolean bl, int n2, int n3, int n4, boolean bl2) throws Exception {
        Element element = this.fGrammarDocument.createElement("attributeDecl");
        element.setAttribute("element", this.fStringPool.toString(qName.localpart));
        element.setAttribute("name", this.fStringPool.toString(qName2.localpart));
        if (qName2.uri != 0) {
            element.setAttribute("xmlns:" + this.fStringPool.toString(qName2.prefix), this.fStringPool.toString(qName2.uri));
        }
        element.setAttribute("type", this.fStringPool.toString(n));
        element.setAttribute("defaultType", this.fStringPool.toString(n3));
        element.setAttribute("defaultValue", this.fStringPool.toString(n4));
        this.fCurrentElement.appendChild(element);
        int n5 = this.createAttributeDecl();
        String string = "";
        switch (n) {
            case 0: {
                string = "string";
            }
            case 1: {
                string = "ENTITY";
            }
            case 2: {
                string = "ENUMERATION";
            }
            case 3: {
                string = "ID";
            }
            case 4: {
                string = "IDREF";
            }
            case 5: {
                string = "NMTOKEN";
            }
            case 6: {
                string = "NOTATION";
            }
        }
        this.fAttributeDecl.clear();
        this.fAttributeDecl.name.setValues(qName2);
        this.fAttributeDecl.type = n;
        this.fAttributeDecl.list = bl;
        this.fAttributeDecl.enumeration = n2;
        this.fAttributeDecl.defaultType = n3;
        this.fAttributeDecl.defaultValue = this.fStringPool.toString(n4);
        int n6 = this.getElementDeclIndex(qName, -1);
        this.setAttributeDecl(n6, n5, this.fAttributeDecl);
        int n7 = n5 >> 8;
        int n8 = n5 & 0xFF;
        this.ensureAttributeDeclCapacity(n7);
        this.fAttributeDeclIsExternal[n7][n8] = bl2 ? 1 : 0;
        return n5;
    }

    public int addUniqueLeafNode(int n) throws Exception {
        int n2 = this.createContentSpec();
        this.fContentSpec.setValues(0, n, -1);
        this.setContentSpec(n2, this.fContentSpec);
        return n2;
    }

    public int addContentSpecNode(int n, int n2) throws Exception {
        int n3 = this.createContentSpec();
        this.fContentSpec.setValues(n, n2, -1);
        this.setContentSpec(n3, this.fContentSpec);
        return n3;
    }

    public int addContentSpecNode(int n, int n2, int n3) throws Exception {
        int n4 = this.createContentSpec();
        this.fContentSpec.setValues(n, n2, n3);
        this.setContentSpec(n4, this.fContentSpec);
        return n4;
    }

    public String getContentSpecNodeAsString(int n) throws Exception {
        return XMLContentSpec.toString(this, this.fStringPool, n);
    }

    public boolean startEntityDecl(boolean bl, int n) throws Exception {
        Element element = this.fGrammarDocument.createElement("entityDecl");
        element.setAttribute("name", this.fStringPool.toString(n));
        element.setAttribute("parameter", bl ? "true" : "false");
        this.fCurrentElement.appendChild(element);
        this.fCurrentElement = element;
        return true;
    }

    public void endEntityDecl() throws Exception {
        this.fCurrentElement = (Element)this.fCurrentElement.getParentNode();
    }

    public int addInternalPEDecl(int n, int n2) throws Exception {
        Element element = this.fGrammarDocument.createElement("internalPEDecl");
        element.setAttribute("name", this.fStringPool.toString(n));
        element.setAttribute("value", this.fStringPool.toString(n2));
        this.fCurrentElement.appendChild(element);
        int n3 = -1;
        return n3;
    }

    public int addExternalPEDecl(int n, int n2, int n3) throws Exception {
        Element element = this.fGrammarDocument.createElement("externalPEDecl");
        element.setAttribute("name", this.fStringPool.toString(n));
        element.setAttribute("publicId", this.fStringPool.toString(n2));
        element.setAttribute("systemId", this.fStringPool.toString(n3));
        this.fCurrentElement.appendChild(element);
        int n4 = -1;
        return n4;
    }

    public int addInternalEntityDecl(int n, int n2) throws Exception {
        Element element = this.fGrammarDocument.createElement("internalEntityDecl");
        element.setAttribute("name", this.fStringPool.toString(n));
        element.setAttribute("value", this.fStringPool.toString(n2));
        this.fCurrentElement.appendChild(element);
        int n3 = -1;
        return n3;
    }

    public int addExternalEntityDecl(int n, int n2, int n3) throws Exception {
        Element element = this.fGrammarDocument.createElement("externalEntityDecl");
        element.setAttribute("name", this.fStringPool.toString(n));
        element.setAttribute("publicId", this.fStringPool.toString(n2));
        element.setAttribute("systemId", this.fStringPool.toString(n3));
        this.fCurrentElement.appendChild(element);
        int n4 = -1;
        return n4;
    }

    public int addUnparsedEntityDecl(int n, int n2, int n3, int n4) throws Exception {
        Element element = this.fGrammarDocument.createElement("unparsedEntityDecl");
        element.setAttribute("name", this.fStringPool.toString(n));
        element.setAttribute("publicId", this.fStringPool.toString(n2));
        element.setAttribute("systemId", this.fStringPool.toString(n3));
        element.setAttribute("notation", this.fStringPool.toString(n4));
        this.fCurrentElement.appendChild(element);
        int n5 = -1;
        return n5;
    }

    public int startEnumeration() throws Exception {
        Element element = this.fGrammarDocument.createElement("enumeration");
        this.fCurrentElement.appendChild(element);
        this.fCurrentElement = element;
        int n = this.fStringPool.startStringList();
        return n;
    }

    public void addNameToEnumeration(int n, int n2, int n3, int n4, boolean bl) throws Exception {
        Element element = this.fGrammarDocument.createElement("literal");
        element.setAttribute("element", this.fStringPool.toString(n2));
        element.setAttribute("attribute", this.fStringPool.toString(n3));
        element.setAttribute("name", this.fStringPool.toString(n4));
        element.setAttribute("notation", bl ? "true" : "false");
        this.fCurrentElement.appendChild(element);
        this.fStringPool.addStringToList(n, n4);
    }

    public void endEnumeration(int n) throws Exception {
        this.fCurrentElement = (Element)this.fCurrentElement.getParentNode();
        this.fStringPool.finishStringList(n);
    }

    public int addNotationDecl(int n, int n2, int n3) throws Exception {
        Element element = this.fGrammarDocument.createElement("notationDecl");
        element.setAttribute("name", this.fStringPool.toString(n));
        element.setAttribute("publicId", this.fStringPool.toString(n2));
        element.setAttribute("systemId", this.fStringPool.toString(n3));
        this.fCurrentElement.appendChild(element);
        int n4 = -1;
        return n4;
    }

    public void callComment(int n) throws Exception {
    }

    public void callProcessingInstruction(int n, int n2) throws Exception {
        ProcessingInstruction processingInstruction = this.fGrammarDocument.createProcessingInstruction(this.fStringPool.toString(n), this.fStringPool.toString(n2));
        this.fCurrentElement.appendChild(processingInstruction);
    }

    public void internalSubset(int n) throws Exception {
    }

    protected boolean isDTD() {
        return true;
    }

    private final void ensureElementDeclCapacity(int n) {
        if (n >= this.fElementDeclMap.length) {
            this.fElementDeclMap = this.resize(this.fElementDeclMap, this.fElementDeclMap.length * 2);
            this.fElementDeclIsExternal = this.resize(this.fElementDeclIsExternal, this.fElementDeclIsExternal.length * 2);
        } else if (this.fElementDeclMap[n] != null) {
            return;
        }
        this.fElementDeclMap[n] = new int[256];
        this.fElementDeclIsExternal[n] = new int[256];
    }

    private final void ensureAttributeDeclCapacity(int n) {
        if (n >= this.fAttributeDeclMap.length) {
            this.fAttributeDeclMap = this.resize(this.fAttributeDeclMap, this.fAttributeDeclMap.length * 2);
            this.fAttributeDeclIsExternal = this.resize(this.fAttributeDeclIsExternal, this.fAttributeDeclIsExternal.length * 2);
        } else if (this.fAttributeDeclMap[n] != null) {
            return;
        }
        this.fAttributeDeclMap[n] = new int[256];
        this.fAttributeDeclIsExternal[n] = new int[256];
    }

    private final void ensureContentSpecCapacity(int n) {
        if (n >= this.fContentSpecMap.length) {
            this.fContentSpecMap = this.resize(this.fContentSpecMap, this.fContentSpecMap.length * 2);
        } else if (this.fContentSpecMap[n] != null) {
            return;
        }
        this.fContentSpecMap[n] = new int[256];
    }

    private final int[][] resize(int[][] nArray, int n) {
        int[][] nArray2 = new int[n][];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    public DTDGrammar(StringPool stringPool) {
        this.reset(stringPool);
    }
}

