/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.image;

import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class RasterSource {
    final RasterSource source;
    final Raster raster;
    int width = 0;
    int height = 0;
    int threshold = 200;
    public static final int BLACK = 0;
    public static final int[] BLACK_COLOR = new int[3];
    public static final int WHITE = 0xFFFFFF;
    public static final int[] WHITE_COLOR = new int[]{255, 255, 255};

    public RasterSource() {
        this.source = null;
        this.raster = null;
    }

    public RasterSource(BufferedImage image) {
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.source = null;
        this.raster = image.getData();
    }

    public RasterSource(Raster raster) {
        this.width = raster.getWidth();
        this.height = raster.getHeight();
        this.source = null;
        this.raster = raster;
    }

    public RasterSource(RasterSource source) {
        this.width = source.getWidth();
        this.height = source.getHeight();
        this.source = source;
        this.raster = null;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final boolean isBlack(int src) {
        if (this.raster != null) {
            if (this.getNumBands() == 1) {
                return src != 0;
            }
            int grayscale = (src & 0xFFFF) >> 8;
            return grayscale < this.threshold;
        }
        return this.source.isBlack(src);
    }

    public boolean isBlack(int x, int y) {
        return this.isBlack(this.getRGBColor(x, y));
    }

    public int getRGBColor(Point2D p) {
        return this.getRGBColor((int)p.getX(), (int)p.getY());
    }

    public int getRGBColor(int x, int y) {
        if (this.raster != null) {
            if (x < 0 || this.width <= x) {
                return 0;
            }
            try {
                int[] argb = new int[4];
                this.raster.getPixel(x, y, argb);
                return argb[0] << 24 | argb[1] << 16 | argb[2] << 8 | argb[3];
            }
            catch (IndexOutOfBoundsException ex) {
                return 0;
            }
        }
        return this.source.getRGBColor(x, y);
    }

    public Raster getRaster() {
        if (this.raster != null) {
            return this.raster;
        }
        return this.source.getRaster();
    }

    public WritableRaster createCompatibleWritableRaster(int w, int h) {
        if (this.raster != null) {
            if (this.getNumBands() == 1) {
                return this.raster.createCompatibleWritableRaster(w, h);
            }
            return WritableRaster.createPackedRaster(3, w, h, new int[]{0xFF0000, 65280, 255}, null);
        }
        return this.source.createCompatibleWritableRaster(w, h);
    }

    public int getNumBands() {
        if (this.source == null) {
            return this.raster.getNumBands();
        }
        return this.source.getNumBands();
    }

    public RasterSource getSource() {
        if (this.source == null) {
            return this;
        }
        return this.source;
    }

    public static BufferedImage createImage(Raster src) {
        return RasterSource.createImage(src, true);
    }

    public static BufferedImage createImage(Raster src, boolean isRGBMode) {
        BufferedImage image = null;
        if (src.getNumBands() == 1) {
            if (isRGBMode) {
                int[] _argb = new int[4];
                int[] argb = new int[4];
                image = new BufferedImage(src.getWidth(), src.getHeight(), 1);
                WritableRaster tgt = WritableRaster.createPackedRaster(3, src.getWidth(), src.getHeight(), new int[]{0xFF0000, 65280, 255}, null);
                Graphics g = image.getGraphics();
                int j = 0;
                while (j < src.getHeight()) {
                    int i = 0;
                    while (i < src.getWidth()) {
                        src.getPixel(i, j, argb);
                        _argb[0] = 255 - argb[0] * 255;
                        _argb[1] = 255 - argb[0] * 255;
                        _argb[2] = 255 - argb[0] * 255;
                        _argb[3] = 255 - argb[0] * 255;
                        tgt.setPixel(i, j, _argb);
                        ++i;
                    }
                    ++j;
                }
                image.setData(tgt);
                return image;
            }
            byte[] indexColorMap = null;
            byte[] byArray = new byte[2];
            byArray[1] = -1;
            indexColorMap = byArray;
            boolean bitParPixel = true;
            image = new BufferedImage(src.getWidth(), src.getHeight(), 13, new IndexColorModel(1, indexColorMap.length, indexColorMap, indexColorMap, indexColorMap));
        } else {
            image = new BufferedImage(src.getWidth(), src.getHeight(), 1);
        }
        image.setData(src);
        return image;
    }
}

