/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.reader.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.sqs_xml.reader.model.FormElementsMarkarea;
import net.sf.sqs_xml.reader.model.FormElementsTextarea;
import net.sf.sqs_xml.reader.model.IFormElementsChoice;
import net.sf.sqs_xml.reader.model.IRNSContainer;
import net.sf.sqs_xml.reader.model.IRNode;
import net.sf.sqs_xml.reader.model.RNSContext;
import net.sf.sqs_xml.reader.model.RStack;
import net.sf.sqs_xml.reader.model.UJAXP;
import net.sf.sqs_xml.reader.model.URelaxer;
import net.sf.sqs_xml.reader.model.URelaxer2;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Page
implements Serializable,
Cloneable,
IRNSContainer,
IRNode {
    private RNSContext rNSContext_ = new RNSContext(this, "http://sqs.cmr.sfc.keio.ac.jp/2004/reader");
    private int sampleID_;
    private int number_;
    private List formElements_ = new ArrayList();
    private Element xmlElement;
    private IRNode parentRNode_;

    public Page() {
    }

    public Page(Page source) {
        this.setup(source);
    }

    public Page(RStack stack) {
        this.setup(stack);
    }

    public Page(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Page(Element element) {
        this.setup(element);
    }

    public Page(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Page(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Page(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Page(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Page(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Page(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Page source) {
        this.sampleID_ = source.sampleID_;
        this.number_ = source.number_;
        this.formElements_.clear();
        int size = source.formElements_.size();
        int i = 0;
        while (i < size) {
            this.addFormElements((IFormElementsChoice)source.getFormElements(i).clone());
            ++i;
        }
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        this.xmlElement = element;
        RStack stack = new RStack(element);
        this.rNSContext_.declareNamespace(element);
        this.sampleID_ = URelaxer.getAttributePropertyAsInt(element, "sampleID");
        this.number_ = URelaxer.getAttributePropertyAsInt(element, "number");
        this.formElements_.clear();
        while (true) {
            if (FormElementsMarkarea.isMatch(stack)) {
                this.addFormElements(new FormElementsMarkarea(stack));
                continue;
            }
            if (!FormElementsTextarea.isMatch(stack)) break;
            this.addFormElements(new FormElementsTextarea(stack));
        }
    }

    public Object clone() {
        return new Page(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElementNS("http://sqs.cmr.sfc.keio.ac.jp/2004/reader", "page");
        this.rNSContext_.setupNamespace(element);
        URelaxer.setAttributePropertyByInt(element, "sampleID", this.sampleID_);
        URelaxer.setAttributePropertyByInt(element, "number", this.number_);
        int size = this.formElements_.size();
        int i = 0;
        while (i < size) {
            IFormElementsChoice value = (IFormElementsChoice)this.formElements_.get(i);
            value.makeElement(element);
            ++i;
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 2));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 2));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 2));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 2));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 2));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public RNSContext rGetRNSContext() {
        return this.rNSContext_;
    }

    public void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    public int getSampleID() {
        return this.sampleID_;
    }

    public void setSampleID(int sampleID) {
        this.sampleID_ = sampleID;
    }

    public int getNumber() {
        return this.number_;
    }

    public void setNumber(int number) {
        this.number_ = number;
    }

    public IFormElementsChoice[] getFormElements() {
        IFormElementsChoice[] array = new IFormElementsChoice[this.formElements_.size()];
        return this.formElements_.toArray(array);
    }

    public void setFormElements(IFormElementsChoice[] formElements) {
        this.formElements_.clear();
        int i = 0;
        while (i < formElements.length) {
            this.addFormElements(formElements[i]);
            ++i;
        }
        i = 0;
        while (i < formElements.length) {
            formElements[i].rSetParentRNode(this);
            ++i;
        }
    }

    public void setFormElements(IFormElementsChoice formElements) {
        this.formElements_.clear();
        this.addFormElements(formElements);
        if (formElements != null) {
            formElements.rSetParentRNode(this);
        }
    }

    public void addFormElements(IFormElementsChoice formElements) {
        this.formElements_.add(formElements);
        if (formElements != null) {
            formElements.rSetParentRNode(this);
        }
    }

    public void addFormElements(IFormElementsChoice[] formElements) {
        int i = 0;
        while (i < formElements.length) {
            this.addFormElements(formElements[i]);
            ++i;
        }
        i = 0;
        while (i < formElements.length) {
            formElements[i].rSetParentRNode(this);
            ++i;
        }
    }

    public int sizeFormElements() {
        return this.formElements_.size();
    }

    public IFormElementsChoice getFormElements(int index) {
        return (IFormElementsChoice)this.formElements_.get(index);
    }

    public void setFormElements(int index, IFormElementsChoice formElements) {
        this.formElements_.set(index, formElements);
        if (formElements != null) {
            formElements.rSetParentRNode(this);
        }
    }

    public void addFormElements(int index, IFormElementsChoice formElements) {
        this.formElements_.add(index, formElements);
        if (formElements != null) {
            formElements.rSetParentRNode(this);
        }
    }

    public void removeFormElements(int index) {
        this.formElements_.remove(index);
    }

    public void removeFormElements(IFormElementsChoice formElements) {
        this.formElements_.remove(formElements);
    }

    public void clearFormElements() {
        this.formElements_.clear();
    }

    public Element rGetElement() {
        return this.xmlElement;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        IFormElementsChoice value;
        String prefix = this.rNSContext_.getPrefixByUri("http://sqs.cmr.sfc.keio.ac.jp/2004/reader");
        buffer.append("<");
        URelaxer.makeQName(prefix, "page", buffer);
        this.rNSContext_.makeNSMappings(buffer);
        buffer.append(" ");
        buffer.append("sampleID");
        buffer.append("=\"");
        buffer.append(URelaxer.getString(this.getSampleID()));
        buffer.append("\"");
        buffer.append(" ");
        buffer.append("number");
        buffer.append("=\"");
        buffer.append(URelaxer.getString(this.getNumber()));
        buffer.append("\"");
        int size = this.formElements_.size();
        int i = 0;
        while (i < size) {
            value = (IFormElementsChoice)this.formElements_.get(i);
            value.makeTextAttribute(buffer);
            ++i;
        }
        buffer.append(">");
        size = this.formElements_.size();
        i = 0;
        while (i < size) {
            value = (IFormElementsChoice)this.formElements_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "page", buffer);
        buffer.append(">");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        IFormElementsChoice value;
        String prefix = this.rNSContext_.getPrefixByUri("http://sqs.cmr.sfc.keio.ac.jp/2004/reader");
        buffer.write("<");
        URelaxer.makeQName(prefix, "page", buffer);
        this.rNSContext_.makeNSMappings(buffer);
        buffer.write(" ");
        buffer.write("sampleID");
        buffer.write("=\"");
        buffer.write(URelaxer.getString(this.getSampleID()));
        buffer.write("\"");
        buffer.write(" ");
        buffer.write("number");
        buffer.write("=\"");
        buffer.write(URelaxer.getString(this.getNumber()));
        buffer.write("\"");
        int size = this.formElements_.size();
        int i = 0;
        while (i < size) {
            value = (IFormElementsChoice)this.formElements_.get(i);
            value.makeTextAttribute(buffer);
            ++i;
        }
        buffer.write(">");
        size = this.formElements_.size();
        i = 0;
        while (i < size) {
            value = (IFormElementsChoice)this.formElements_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.write("</");
        URelaxer.makeQName(prefix, "page", buffer);
        buffer.write(">");
    }

    public void makeTextElement(PrintWriter buffer) {
        IFormElementsChoice value;
        String prefix = this.rNSContext_.getPrefixByUri("http://sqs.cmr.sfc.keio.ac.jp/2004/reader");
        buffer.print("<");
        URelaxer.makeQName(prefix, "page", buffer);
        this.rNSContext_.makeNSMappings(buffer);
        buffer.print(" ");
        buffer.print("sampleID");
        buffer.print("=\"");
        buffer.print(URelaxer.getString(this.getSampleID()));
        buffer.print("\"");
        buffer.print(" ");
        buffer.print("number");
        buffer.print("=\"");
        buffer.print(URelaxer.getString(this.getNumber()));
        buffer.print("\"");
        int size = this.formElements_.size();
        int i = 0;
        while (i < size) {
            value = (IFormElementsChoice)this.formElements_.get(i);
            value.makeTextAttribute(buffer);
            ++i;
        }
        buffer.print(">");
        size = this.formElements_.size();
        i = 0;
        while (i < size) {
            value = (IFormElementsChoice)this.formElements_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "page", buffer);
        buffer.print(">");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getSampleIDAsString() {
        return URelaxer.getString(this.getSampleID());
    }

    public String getNumberAsString() {
        return URelaxer.getString(this.getNumber());
    }

    public void setSampleIDByString(String string) {
        this.setSampleID(Integer.parseInt(string));
    }

    public void setNumberByString(String string) {
        this.setNumber(Integer.parseInt(string));
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        classNodes.addAll(this.formElements_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://sqs.cmr.sfc.keio.ac.jp/2004/reader", "page")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        if (!URelaxer.hasAttributeHungry(target, "sampleID")) {
            return false;
        }
        $match$ = true;
        if (!URelaxer.hasAttributeHungry(target, "number")) {
            return false;
        }
        $match$ = true;
        while (true) {
            if (FormElementsMarkarea.isMatchHungry(target)) {
                $match$ = true;
                continue;
            }
            if (!FormElementsTextarea.isMatchHungry(target)) break;
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Page.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Page.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

