/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.swing;

import java.awt.Font;
import java.awt.Point;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.text.PlainDocument;
import org.apache.avalon.framework.logger.Logger;

class LoggerTextArea
extends JTextArea
implements Logger {
    boolean isError = false;
    JViewport viewPort;
    boolean autoScrollToTail = true;

    public LoggerTextArea(String title, int rows, int cols) {
        super(new PlainDocument(), title, rows, cols);
        this.setFont(new Font("Courier", 0, 10));
    }

    public void setAutoScrollToTail(boolean autoScrollToTail) {
        this.autoScrollToTail = autoScrollToTail;
    }

    public void clear() {
        this.setText("");
    }

    public void append(String message) {
        this.append(message, null);
    }

    public void append(String message, Throwable throwable) {
        if (throwable != null) {
            super.append(message);
            super.append("\n");
            while (throwable != null) {
                super.append(throwable.getLocalizedMessage());
                throwable = throwable.getCause();
                super.append("\n");
            }
        } else {
            super.append(message);
            super.append("\n");
        }
        if (this.viewPort == null) {
            this.viewPort = (JViewport)this.getParent();
            this.viewPort.setAutoscrolls(true);
        }
        if (this.autoScrollToTail) {
            this.viewPort.setViewPosition(new Point(0, (int)(this.viewPort.getViewSize().getHeight() - this.viewPort.getExtentSize().getHeight())));
        }
    }

    public void debug(String message, Throwable throwable) {
        this.append("[debug]" + message, throwable);
    }

    public void debug(String message) {
        this.append("[debug]" + message, null);
    }

    public void error(String message, Throwable throwable) {
        this.append("[error]" + message, throwable);
        this.isError = true;
    }

    public void error(String message) {
        this.append("[error]" + message);
        this.isError = true;
    }

    public void fatalError(String message, Throwable throwable) {
        this.append("[fatal]" + message, throwable);
    }

    public void fatalError(String message) {
        this.append("[fatal]" + message);
    }

    public Logger getChildLogger(String message) {
        return this;
    }

    public void info(String message, Throwable throwable) {
        this.append("[info]" + message, throwable);
    }

    public void info(String message) {
        this.append("[info]" + message);
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isFatalErrorEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(String message, Throwable throwable) {
        this.append("[warn]" + message, throwable);
    }

    public void warn(String message) {
        this.append("[warn]" + message);
    }
}

