/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.text;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.batik.gvt.font.AWTGVTFont;
import org.apache.batik.gvt.font.AltGlyphHandler;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.font.GVTLineMetrics;
import org.apache.batik.gvt.font.MultiGlyphVector;
import org.apache.batik.gvt.text.ArabicTextHandler;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.GlyphIterator;
import org.apache.batik.gvt.text.LineInfo;
import org.apache.batik.gvt.text.MarginInfo;
import org.apache.batik.gvt.text.TextHit;
import org.apache.batik.gvt.text.TextPath;
import org.apache.batik.gvt.text.TextSpanLayout;

public class GlyphLayout
implements TextSpanLayout {
    private GVTGlyphVector gv;
    private GVTFont font;
    private GVTLineMetrics metrics;
    private AttributedCharacterIterator aci;
    private FontRenderContext frc;
    private Point2D advance;
    private Point2D offset;
    private float xScale = 1.0f;
    private float yScale = 1.0f;
    private Point2D prevCharPosition;
    private TextPath textPath;
    private Point2D textPathAdvance;
    private int[] charMap;
    private boolean vertical;
    private boolean adjSpacing = true;
    private boolean layoutApplied = false;
    private boolean spacingApplied = false;
    private boolean pathApplied = false;
    public static final AttributedCharacterIterator.Attribute FLOW_LINE_BREAK = GVTAttributedCharacterIterator.TextAttribute.FLOW_LINE_BREAK;
    public static final AttributedCharacterIterator.Attribute FLOW_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute FLOW_EMPTY_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_EMPTY_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute TEXT_COMPOUND_DELIMITER = GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER;
    private static final AttributedCharacterIterator.Attribute X = GVTAttributedCharacterIterator.TextAttribute.X;
    private static final AttributedCharacterIterator.Attribute Y = GVTAttributedCharacterIterator.TextAttribute.Y;
    private static final AttributedCharacterIterator.Attribute DX = GVTAttributedCharacterIterator.TextAttribute.DX;
    private static final AttributedCharacterIterator.Attribute DY = GVTAttributedCharacterIterator.TextAttribute.DY;
    private static final AttributedCharacterIterator.Attribute ROTATION = GVTAttributedCharacterIterator.TextAttribute.ROTATION;
    private static final AttributedCharacterIterator.Attribute BASELINE_SHIFT = GVTAttributedCharacterIterator.TextAttribute.BASELINE_SHIFT;
    private static final AttributedCharacterIterator.Attribute WRITING_MODE = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE;
    private static final Integer WRITING_MODE_TTB = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_TTB;
    static Set runAtts = new HashSet();
    static Set szAtts;
    public static final float eps = 1.0E-5f;

    public GlyphLayout(AttributedCharacterIterator aci, int[] charMap, Point2D offset, FontRenderContext frc) {
        this.aci = aci;
        this.frc = frc;
        this.offset = offset;
        this.font = this.getFont();
        this.charMap = charMap;
        this.metrics = this.font.getLineMetrics(aci, aci.getBeginIndex(), aci.getEndIndex(), frc);
        this.gv = null;
        this.aci.first();
        this.vertical = aci.getAttribute(WRITING_MODE) == WRITING_MODE_TTB;
        this.textPath = (TextPath)aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXTPATH);
        AltGlyphHandler altGlyphHandler = (AltGlyphHandler)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.ALT_GLYPH_HANDLER);
        if (altGlyphHandler != null) {
            this.gv = altGlyphHandler.createGlyphVector(frc, this.font.getSize(), this.aci);
        }
        if (this.gv == null) {
            this.gv = this.font.createGlyphVector(frc, this.aci);
        }
    }

    GVTGlyphVector getGlyphVector() {
        return this.gv;
    }

    public Point2D getOffset() {
        return this.offset;
    }

    public void setScale(float xScale, float yScale, boolean adjSpacing) {
        if (this.vertical) {
            xScale = 1.0f;
        } else {
            yScale = 1.0f;
        }
        if (xScale != this.xScale || yScale != this.yScale || adjSpacing != this.adjSpacing) {
            this.xScale = xScale;
            this.yScale = yScale;
            this.adjSpacing = adjSpacing;
            this.spacingApplied = false;
            this.pathApplied = false;
        }
    }

    public void setOffset(Point2D offset) {
        if (offset.getX() != this.offset.getX() || offset.getY() != this.offset.getY()) {
            if (this.layoutApplied || this.spacingApplied) {
                float dx = (float)(offset.getX() - this.offset.getX());
                float dy = (float)(offset.getY() - this.offset.getY());
                int numGlyphs = this.gv.getNumGlyphs();
                float[] gp = this.gv.getGlyphPositions(0, numGlyphs + 1, null);
                int i = 0;
                while (i <= numGlyphs) {
                    this.gv.setGlyphPosition(i, new Point2D.Float(gp[2 * i] + dx, gp[2 * i + 1] + dy));
                    ++i;
                }
            }
            this.offset = offset;
            this.pathApplied = false;
        }
    }

    public GVTGlyphMetrics getGlyphMetrics(int glyphIndex) {
        return this.gv.getGlyphMetrics(glyphIndex);
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public boolean isOnATextPath() {
        return this.textPath != null;
    }

    public int getGlyphCount() {
        return this.gv.getNumGlyphs();
    }

    public int getCharacterCount(int startGlyphIndex, int endGlyphIndex) {
        return this.gv.getCharacterCount(startGlyphIndex, endGlyphIndex);
    }

    public boolean isLeftToRight() {
        this.aci.first();
        int bidiLevel = (Integer)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.BIDI_LEVEL);
        return (bidiLevel & 1) == 0;
    }

    private final void syncLayout() {
        if (!this.pathApplied) {
            this.doPathLayout();
        }
    }

    public void draw(Graphics2D g2d) {
        this.syncLayout();
        this.gv.draw(g2d, this.aci);
    }

    public Point2D getAdvance2D() {
        this.adjustTextSpacing();
        return this.advance;
    }

    public Shape getOutline() {
        this.syncLayout();
        return this.gv.getOutline();
    }

    public Shape getDecorationOutline(int decorationType) {
        this.syncLayout();
        GeneralPath g = new GeneralPath();
        if ((decorationType & 1) != 0) {
            g.append(this.getUnderlineShape(), false);
        }
        if ((decorationType & 2) != 0) {
            g.append(this.getStrikethroughShape(), false);
        }
        if ((decorationType & 4) != 0) {
            g.append(this.getOverlineShape(), false);
        }
        return g;
    }

    public Rectangle2D getBounds2D() {
        this.syncLayout();
        return this.gv.getBounds2D(this.aci);
    }

    public Rectangle2D getGeometricBounds() {
        this.syncLayout();
        Rectangle2D gvB = this.gv.getGeometricBounds();
        Rectangle2D decB = this.getDecorationOutline(7).getBounds2D();
        return gvB.createUnion(decB);
    }

    public Point2D getTextPathAdvance() {
        this.syncLayout();
        if (this.textPath != null) {
            return this.textPathAdvance;
        }
        return this.getAdvance2D();
    }

    public int getGlyphIndex(int charIndex) {
        int numGlyphs = this.getGlyphCount();
        int j = 0;
        int i = 0;
        while (i < numGlyphs) {
            int count = this.getCharacterCount(i, i);
            int n = 0;
            while (n < count) {
                int glyphCharIndex;
                if (charIndex == (glyphCharIndex = this.charMap[j++])) {
                    return i;
                }
                if (j >= this.charMap.length) {
                    return -1;
                }
                ++n;
            }
            ++i;
        }
        return -1;
    }

    public Shape getHighlightShape(int beginCharIndex, int endCharIndex) {
        this.syncLayout();
        if (beginCharIndex > endCharIndex) {
            int temp = beginCharIndex;
            beginCharIndex = endCharIndex;
            endCharIndex = temp;
        }
        GeneralPath shape = null;
        int start = this.aci.getBeginIndex();
        int numGlyphs = this.getGlyphCount();
        boolean glyphOrientationAuto = this.isGlyphOrientationAuto();
        int glyphOrientationAngle = 90;
        if (!glyphOrientationAuto) {
            glyphOrientationAngle = this.getGlyphOrientationAngle();
        }
        Point2D.Float[] topPts = new Point2D.Float[2 * numGlyphs];
        Point2D.Float[] botPts = new Point2D.Float[2 * numGlyphs];
        int ptIdx = 0;
        int currentChar = start;
        int i = 0;
        while (i < numGlyphs) {
            Shape gbounds;
            char ch = this.aci.setIndex(currentChar);
            int glyphCharIndex = this.charMap[currentChar - start];
            if (glyphCharIndex >= beginCharIndex && glyphCharIndex <= endCharIndex && this.gv.isGlyphVisible(i) && (gbounds = this.gv.getGlyphLogicalBounds(i)) != null) {
                if (shape == null) {
                    shape = new GeneralPath();
                }
                float[] pts = new float[6];
                int count = 0;
                int type = -1;
                PathIterator pi = gbounds.getPathIterator(null);
                Point2D.Float firstPt = null;
                if (this.isVertical() && glyphOrientationAuto) {
                    glyphOrientationAngle = this.isLatinChar(ch) ? 90 : 0;
                }
                while (!pi.isDone()) {
                    type = pi.currentSegment(pts);
                    if (type == 0 || type == 1) {
                        if (count > 4) break;
                        if (count == 4) {
                            if (firstPt == null || firstPt.x != pts[0] || firstPt.y != pts[1]) {
                                break;
                            }
                        } else {
                            Point2D.Float pt = new Point2D.Float(pts[0], pts[1]);
                            if (count == 0) {
                                firstPt = pt;
                            }
                            switch (count) {
                                case 0: {
                                    botPts[ptIdx] = pt;
                                    break;
                                }
                                case 1: {
                                    topPts[ptIdx] = pt;
                                    break;
                                }
                                case 2: {
                                    topPts[ptIdx + 1] = pt;
                                    break;
                                }
                                case 3: {
                                    botPts[ptIdx + 1] = pt;
                                }
                            }
                        }
                    } else if (type != 4 || count < 4 || count > 5) break;
                    ++count;
                    pi.next();
                }
                if (pi.isDone()) {
                    if (botPts[ptIdx] != null && (topPts[ptIdx].x != topPts[ptIdx + 1].x || topPts[ptIdx].y != topPts[ptIdx + 1].y)) {
                        ptIdx += 2;
                    }
                } else {
                    GlyphLayout.addPtsToPath(shape, topPts, botPts, ptIdx);
                    ptIdx = 0;
                    shape.append(gbounds, false);
                }
            }
            currentChar += this.getCharacterCount(i, i);
            ++i;
        }
        GlyphLayout.addPtsToPath(shape, topPts, botPts, ptIdx);
        return shape;
    }

    /*
     * Unable to fully structure code
     */
    public static int makeConvexHull(Point2D.Float[] pts, int numPts) {
        i = 1;
        while (i < numPts) {
            if (pts[i].x < pts[i - 1].x || pts[i].x == pts[i - 1].x && pts[i].y < pts[i - 1].y) {
                tmp = pts[i];
                pts[i] = pts[i - 1];
                pts[i - 1] = tmp;
                i = 0;
            }
            ++i;
        }
        pt0 = pts[0];
        pt1 = pts[numPts - 1];
        dxdy = new Point2D.Float(pt1.x - pt0.x, pt1.y - pt0.y);
        c = dxdy.y * pt0.x - dxdy.x * pt0.y;
        topList = new Point2D.Float[numPts];
        botList = new Point2D.Float[numPts];
        botList[0] = topList[0] = pts[0];
        nTopPts = 1;
        nBotPts = 1;
        i = 1;
        while (i < numPts - 1) {
            block13: {
                pt = pts[i];
                soln = dxdy.x * pt.y - dxdy.y * pt.x + c;
                if (!(soln < 0.0f)) ** GOTO lbl54
                while (nBotPts >= 2) {
                    pt0 = botList[nBotPts - 2];
                    pt1 = botList[nBotPts - 1];
                    dx = pt1.x - pt0.x;
                    dy = pt1.y - pt0.y;
                    c0 = dy * pt0.x - dx * pt0.y;
                    soln = dx * pt.y - dy * pt.x + c0;
                    if (soln > 1.0E-5f) break;
                    if (soln > -1.0E-5f) {
                        if (!(pt1.y < pt.y)) break;
                        pt = pt1;
                        break;
                    }
                    --nBotPts;
                }
                v0 = --nBotPts;
                ++nBotPts;
                botList[v0] = pt;
                break block13;
lbl-1000:
                // 1 sources

                {
                    pt0 = topList[nTopPts - 2];
                    pt1 = topList[nTopPts - 1];
                    dx = pt1.x - pt0.x;
                    dy = pt1.y - pt0.y;
                    c0 = dy * pt0.x - dx * pt0.y;
                    soln = dx * pt.y - dy * pt.x + c0;
                    if (soln < -1.0E-5f) break;
                    if (soln < 1.0E-5f) {
                        if (!(pt1.y > pt.y)) break;
                        pt = pt1;
                        break;
                    }
                    --nTopPts;
lbl54:
                    // 2 sources

                    ** while (nTopPts >= 2)
                }
lbl55:
                // 4 sources

                v1 = --nTopPts;
                ++nTopPts;
                topList[v1] = pt;
            }
            ++i;
        }
        pt = pts[numPts - 1];
        while (nBotPts >= 2) {
            pt0 = botList[nBotPts - 2];
            pt1 = botList[nBotPts - 1];
            dx = pt1.x - pt0.x;
            dy = pt1.y - pt0.y;
            c0 = dy * pt0.x - dx * pt0.y;
            soln = dx * pt.y - dy * pt.x + c0;
            if (soln > 1.0E-5f) break;
            if (soln > -1.0E-5f) {
                if (!(pt1.y >= pt.y)) break;
                --nBotPts;
                break;
            }
            --nBotPts;
        }
        while (nTopPts >= 2) {
            pt0 = topList[nTopPts - 2];
            pt1 = topList[nTopPts - 1];
            dx = pt1.x - pt0.x;
            dy = pt1.y - pt0.y;
            c0 = dy * pt0.x - dx * pt0.y;
            soln = dx * pt.y - dy * pt.x + c0;
            if (soln < -1.0E-5f) break;
            if (soln < 1.0E-5f) {
                if (!(pt1.y <= pt.y)) break;
                --nTopPts;
                break;
            }
            --nTopPts;
        }
        i = 0;
        while (i < nTopPts) {
            pts[i] = topList[i];
            ++i;
        }
        pts[i++] = pts[numPts - 1];
        n = nBotPts - 1;
        while (n > 0) {
            pts[i] = botList[n];
            --n;
            ++i;
        }
        return i;
    }

    public static void addPtsToPath(GeneralPath shape, Point2D.Float[] topPts, Point2D.Float[] botPts, int numPts) {
        if (numPts < 2) {
            return;
        }
        if (numPts == 2) {
            shape.moveTo(topPts[0].x, topPts[0].y);
            shape.lineTo(topPts[1].x, topPts[1].y);
            shape.lineTo(botPts[1].x, botPts[1].y);
            shape.lineTo(botPts[0].x, botPts[0].y);
            shape.lineTo(topPts[0].x, topPts[0].y);
            return;
        }
        Point2D.Float[] boxes = new Point2D.Float[8];
        Point2D.Float[] chull = new Point2D.Float[8];
        boxes[4] = topPts[0];
        boxes[5] = topPts[1];
        boxes[6] = botPts[1];
        boxes[7] = botPts[0];
        Area[] areas = new Area[numPts / 2];
        int nAreas = 0;
        int i = 2;
        while (i < numPts) {
            boxes[0] = boxes[4];
            boxes[1] = boxes[5];
            boxes[2] = boxes[6];
            boxes[3] = boxes[7];
            boxes[4] = topPts[i];
            boxes[5] = topPts[i + 1];
            boxes[6] = botPts[i + 1];
            boxes[7] = botPts[i];
            float delta = boxes[2].x - boxes[0].x;
            float dist = delta * delta;
            delta = boxes[2].y - boxes[0].y;
            float sz = (float)Math.sqrt(dist += delta * delta);
            delta = boxes[6].x - boxes[4].x;
            dist = delta * delta;
            delta = boxes[6].y - boxes[4].y;
            sz += (float)Math.sqrt(dist += delta * delta);
            delta = (boxes[0].x + boxes[1].x + boxes[2].x + boxes[3].x - (boxes[4].x + boxes[5].x + boxes[6].x + boxes[7].x)) / 4.0f;
            dist = delta * delta;
            delta = (boxes[0].y + boxes[1].y + boxes[2].y + boxes[3].y - (boxes[4].y + boxes[5].y + boxes[6].y + boxes[7].y)) / 4.0f;
            dist += delta * delta;
            dist = (float)Math.sqrt(dist);
            GeneralPath gp = new GeneralPath();
            if (dist < sz) {
                System.arraycopy(boxes, 0, chull, 0, 8);
                int npts = GlyphLayout.makeConvexHull(chull, 8);
                gp.moveTo(chull[0].x, chull[0].y);
                int n = 1;
                while (n < npts) {
                    gp.lineTo(chull[n].x, chull[n].y);
                    ++n;
                }
                gp.closePath();
            } else {
                GlyphLayout.mergeAreas(shape, areas, nAreas);
                nAreas = 0;
                if (i == 2) {
                    gp.moveTo(boxes[0].x, boxes[0].y);
                    gp.lineTo(boxes[1].x, boxes[1].y);
                    gp.lineTo(boxes[2].x, boxes[2].y);
                    gp.lineTo(boxes[3].x, boxes[3].y);
                    gp.closePath();
                    shape.append(gp, false);
                    gp.reset();
                }
                gp.moveTo(boxes[4].x, boxes[4].y);
                gp.lineTo(boxes[5].x, boxes[5].y);
                gp.lineTo(boxes[6].x, boxes[6].y);
                gp.lineTo(boxes[7].x, boxes[7].y);
                gp.closePath();
            }
            areas[nAreas++] = new Area(gp);
            i += 2;
        }
        GlyphLayout.mergeAreas(shape, areas, nAreas);
    }

    public static void mergeAreas(GeneralPath shape, Area[] shapes, int nShapes) {
        while (nShapes > 1) {
            int n = 0;
            int i = 1;
            while (i < nShapes) {
                shapes[i - 1].add(shapes[i]);
                shapes[n++] = shapes[i - 1];
                shapes[i] = null;
                i += 2;
            }
            if ((nShapes & 1) == 1) {
                shapes[n - 1].add(shapes[nShapes - 1]);
            }
            nShapes /= 2;
        }
        if (nShapes == 1) {
            shape.append(shapes[0], false);
        }
    }

    public TextHit hitTestChar(float x, float y) {
        this.syncLayout();
        TextHit textHit = null;
        int currentChar = 0;
        int i = 0;
        while (i < this.gv.getNumGlyphs()) {
            Shape gbounds = this.gv.getGlyphLogicalBounds(i);
            if (gbounds != null) {
                Rectangle2D gbounds2d = gbounds.getBounds2D();
                if (gbounds.contains(x, y)) {
                    boolean isRightHalf = (double)x > gbounds2d.getX() + gbounds2d.getWidth() / 2.0;
                    boolean isLeadingEdge = !isRightHalf;
                    int charIndex = this.charMap[currentChar];
                    textHit = new TextHit(charIndex, isLeadingEdge);
                    return textHit;
                }
            }
            currentChar += this.getCharacterCount(i, i);
            ++i;
        }
        return textHit;
    }

    protected GVTFont getFont() {
        this.aci.first();
        GVTFont gvtFont = (GVTFont)this.aci.getAttributes().get(GVTAttributedCharacterIterator.TextAttribute.GVT_FONT);
        if (gvtFont != null) {
            return gvtFont;
        }
        return new AWTGVTFont(this.aci.getAttributes());
    }

    protected Shape getOverlineShape() {
        double y = this.metrics.getOverlineOffset();
        float overlineThickness = this.metrics.getOverlineThickness();
        BasicStroke overlineStroke = new BasicStroke(overlineThickness);
        Rectangle2D logicalBounds = this.gv.getLogicalBounds();
        return overlineStroke.createStrokedShape(new Line2D.Double(logicalBounds.getMinX() + (double)overlineThickness / 2.0, this.offset.getY() + (y += (double)overlineThickness), logicalBounds.getMaxX() - (double)overlineThickness / 2.0, this.offset.getY() + y));
    }

    protected Shape getUnderlineShape() {
        double y = this.metrics.getUnderlineOffset();
        float underlineThickness = this.metrics.getUnderlineThickness();
        BasicStroke underlineStroke = new BasicStroke(underlineThickness);
        Rectangle2D logicalBounds = this.gv.getLogicalBounds();
        return underlineStroke.createStrokedShape(new Line2D.Double(logicalBounds.getMinX() + (double)underlineThickness / 2.0, this.offset.getY() + (y += (double)underlineThickness * 1.5), logicalBounds.getMaxX() - (double)underlineThickness / 2.0, this.offset.getY() + y));
    }

    protected Shape getStrikethroughShape() {
        double y = this.metrics.getStrikethroughOffset();
        float strikethroughThickness = this.metrics.getStrikethroughThickness();
        BasicStroke strikethroughStroke = new BasicStroke(strikethroughThickness);
        Rectangle2D logicalBounds = this.gv.getLogicalBounds();
        return strikethroughStroke.createStrokedShape(new Line2D.Double(logicalBounds.getMinX() + (double)strikethroughThickness / 2.0, this.offset.getY() + y, logicalBounds.getMaxX() - (double)strikethroughThickness / 2.0, this.offset.getY() + y));
    }

    protected void doExplicitGlyphLayout() {
        this.gv.performDefaultLayout();
        float baselineAscent = this.vertical ? (float)this.gv.getLogicalBounds().getWidth() : this.metrics.getAscent() + Math.abs(this.metrics.getDescent());
        int numGlyphs = this.gv.getNumGlyphs();
        float[] gp = this.gv.getGlyphPositions(0, numGlyphs + 1, null);
        float verticalFirstOffset = 0.0f;
        boolean glyphOrientationAuto = this.isGlyphOrientationAuto();
        int glyphOrientationAngle = 0;
        if (!glyphOrientationAuto) {
            glyphOrientationAngle = this.getGlyphOrientationAngle();
        }
        int i = 0;
        int aciIndex = this.aci.getBeginIndex();
        char ch = this.aci.first();
        int runLimit = aciIndex;
        Float x = null;
        Float y = null;
        Float dx = null;
        Float dy = null;
        Float rotation = null;
        Object baseline = null;
        float shift_x_pos = 0.0f;
        float shift_y_pos = 0.0f;
        float curr_x_pos = (float)this.offset.getX();
        float curr_y_pos = (float)this.offset.getY();
        while (i < numGlyphs) {
            if (aciIndex >= runLimit) {
                runLimit = this.aci.getRunLimit(runAtts);
                x = (Float)this.aci.getAttribute(X);
                y = (Float)this.aci.getAttribute(Y);
                dx = (Float)this.aci.getAttribute(DX);
                dy = (Float)this.aci.getAttribute(DY);
                rotation = (Float)this.aci.getAttribute(ROTATION);
                baseline = this.aci.getAttribute(BASELINE_SHIFT);
            }
            GVTGlyphMetrics gm = this.gv.getGlyphMetrics(i);
            if (i == 0) {
                verticalFirstOffset = glyphOrientationAuto ? (this.isLatinChar(ch) ? 0.0f : (float)gm.getBounds2D().getHeight()) : (glyphOrientationAngle == 0 ? (float)gm.getBounds2D().getHeight() : 0.0f);
            } else if (glyphOrientationAuto && verticalFirstOffset == 0.0f && !this.isLatinChar(ch)) {
                verticalFirstOffset = (float)gm.getBounds2D().getHeight();
            }
            float ox = 0.0f;
            float oy = 0.0f;
            float verticalGlyphRotation = 0.0f;
            float glyphRotation = 0.0f;
            if (ch != '\uffff') {
                if (this.vertical) {
                    verticalGlyphRotation = glyphOrientationAuto ? (this.isLatinChar(ch) ? 1.5707964f : 0.0f) : (float)Math.toRadians(glyphOrientationAngle);
                    if (this.textPath != null) {
                        x = null;
                    }
                } else if (this.textPath != null) {
                    y = null;
                }
                glyphRotation = rotation == null || rotation.isNaN() ? verticalGlyphRotation : rotation.floatValue() + verticalGlyphRotation;
                if (x != null && !x.isNaN()) {
                    if (i == 0) {
                        shift_x_pos = (float)((double)x.floatValue() - this.offset.getX());
                    }
                    curr_x_pos = x.floatValue() - shift_x_pos;
                }
                if (dx != null && !dx.isNaN()) {
                    curr_x_pos += dx.floatValue();
                }
                if (y != null && !y.isNaN()) {
                    if (i == 0) {
                        shift_y_pos = (float)((double)y.floatValue() - this.offset.getY());
                    }
                    curr_y_pos = y.floatValue() - shift_y_pos;
                }
                if (dy != null && !dy.isNaN()) {
                    curr_y_pos += dy.floatValue();
                } else if (i > 0) {
                    curr_y_pos += gp[i * 2 + 1] - gp[i * 2 - 1];
                }
                float baselineAdjust = 0.0f;
                if (baseline != null) {
                    if (baseline instanceof Integer) {
                        if (baseline == TextAttribute.SUPERSCRIPT_SUPER) {
                            baselineAdjust = baselineAscent * 0.5f;
                        } else if (baseline == TextAttribute.SUPERSCRIPT_SUB) {
                            baselineAdjust = -baselineAscent * 0.5f;
                        }
                    } else if (baseline instanceof Float) {
                        baselineAdjust = ((Float)baseline).floatValue();
                    }
                    if (this.vertical) {
                        ox = baselineAdjust;
                    } else {
                        oy = -baselineAdjust;
                    }
                }
                if (this.vertical) {
                    Rectangle2D glyphBounds;
                    oy += verticalFirstOffset;
                    if (glyphOrientationAuto) {
                        if (this.isLatinChar(ch)) {
                            ox += this.metrics.getStrikethroughOffset();
                        } else {
                            glyphBounds = this.gv.getGlyphVisualBounds(i).getBounds2D();
                            ox -= (float)(glyphBounds.getMaxX() - (double)gp[2 * i] - glyphBounds.getWidth() / 2.0);
                        }
                    } else {
                        glyphBounds = this.gv.getGlyphVisualBounds(i).getBounds2D();
                        ox = glyphOrientationAngle == 0 ? (ox -= (float)(glyphBounds.getMaxX() - (double)gp[2 * i] - glyphBounds.getWidth() / 2.0)) : (glyphOrientationAngle == 180 ? (ox += (float)(glyphBounds.getMaxX() - (double)gp[2 * i] - glyphBounds.getWidth() / 2.0)) : (glyphOrientationAngle == 90 ? (ox += this.metrics.getStrikethroughOffset()) : (ox -= this.metrics.getStrikethroughOffset())));
                    }
                }
            }
            this.gv.setGlyphPosition(i, new Point2D.Float(curr_x_pos + ox, curr_y_pos + oy));
            if (!ArabicTextHandler.arabicCharTransparent(ch)) {
                if (this.vertical) {
                    float advanceY = 0.0f;
                    if (glyphOrientationAuto) {
                        advanceY = this.isLatinChar(ch) ? gm.getHorizontalAdvance() : gm.getVerticalAdvance();
                    } else if (glyphOrientationAngle == 0 || glyphOrientationAngle == 180) {
                        advanceY = gm.getVerticalAdvance();
                    } else if (glyphOrientationAngle == 90) {
                        advanceY = gm.getHorizontalAdvance();
                    } else {
                        advanceY = gm.getHorizontalAdvance();
                        this.gv.setGlyphTransform(i, AffineTransform.getTranslateInstance(0.0, advanceY));
                    }
                    curr_y_pos += advanceY;
                } else {
                    curr_x_pos += gm.getHorizontalAdvance();
                }
            }
            if (glyphRotation != 0.0f) {
                AffineTransform glyphTransform = this.gv.getGlyphTransform(i);
                if (glyphTransform == null) {
                    glyphTransform = new AffineTransform();
                }
                glyphTransform.rotate(glyphRotation);
                this.gv.setGlyphTransform(i, glyphTransform);
            }
            ch = this.aci.setIndex(aciIndex += this.gv.getCharacterCount(i, i));
            ++i;
        }
        this.gv.setGlyphPosition(i, new Point2D.Float(curr_x_pos, curr_y_pos));
        this.advance = new Point2D.Float((float)((double)curr_x_pos - this.offset.getX()), (float)((double)curr_y_pos - this.offset.getY()));
        this.layoutApplied = true;
        this.spacingApplied = false;
        this.pathApplied = false;
    }

    protected void adjustTextSpacing() {
        if (this.spacingApplied) {
            return;
        }
        if (!this.layoutApplied) {
            this.doExplicitGlyphLayout();
        }
        this.aci.first();
        Boolean customSpacing = (Boolean)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING);
        if (customSpacing != null && customSpacing.booleanValue()) {
            this.advance = this.doSpacing((Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.KERNING), (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.LETTER_SPACING), (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.WORD_SPACING));
            this.layoutApplied = false;
        }
        this.applyStretchTransform(!this.adjSpacing);
        this.spacingApplied = true;
        this.pathApplied = false;
    }

    protected Point2D doSpacing(Float kern, Float letterSpacing, Float wordSpacing) {
        boolean autoKern = true;
        boolean doWordSpacing = false;
        boolean doLetterSpacing = false;
        float kernVal = 0.0f;
        float letterSpacingVal = 0.0f;
        float wordSpacingVal = 0.0f;
        if (kern instanceof Float && !kern.isNaN()) {
            kernVal = kern.floatValue();
            autoKern = false;
        }
        if (letterSpacing instanceof Float && !letterSpacing.isNaN()) {
            letterSpacingVal = letterSpacing.floatValue();
            doLetterSpacing = true;
        }
        if (wordSpacing instanceof Float && !wordSpacing.isNaN()) {
            wordSpacingVal = wordSpacing.floatValue();
            doWordSpacing = true;
        }
        int numGlyphs = this.gv.getNumGlyphs();
        float dx = 0.0f;
        float dy = 0.0f;
        Point2D[] newPositions = new Point2D[numGlyphs + 1];
        Point2D prevPos = this.gv.getGlyphPosition(0);
        float x = (float)prevPos.getX();
        float y = (float)prevPos.getY();
        Point2D.Double lastCharAdvance = new Point2D.Double(this.advance.getX() - (this.gv.getGlyphPosition(numGlyphs - 1).getX() - (double)x), this.advance.getY() - (this.gv.getGlyphPosition(numGlyphs - 1).getY() - (double)y));
        try {
            int i;
            if (numGlyphs > 1 && (doLetterSpacing || !autoKern)) {
                i = 1;
                while (i <= numGlyphs) {
                    Point2D gpos = this.gv.getGlyphPosition(i);
                    dx = (float)gpos.getX() - (float)prevPos.getX();
                    dy = (float)gpos.getY() - (float)prevPos.getY();
                    if (autoKern) {
                        if (this.vertical) {
                            dy += letterSpacingVal;
                        } else {
                            dx += letterSpacingVal;
                        }
                    } else if (this.vertical) {
                        dy = (float)this.gv.getGlyphMetrics(i - 1).getBounds2D().getHeight() + kernVal + letterSpacingVal;
                    } else {
                        dx = (float)this.gv.getGlyphMetrics(i - 1).getBounds2D().getWidth() + kernVal + letterSpacingVal;
                    }
                    newPositions[i] = new Point2D.Float(x += dx, y += dy);
                    prevPos = gpos;
                    ++i;
                }
                int i2 = 1;
                while (i2 <= numGlyphs) {
                    if (newPositions[i2] != null) {
                        this.gv.setGlyphPosition(i2, newPositions[i2]);
                    }
                    ++i2;
                }
            }
            if (autoKern) {
                if (this.vertical) {
                    ((Point2D)lastCharAdvance).setLocation(((Point2D)lastCharAdvance).getX(), ((Point2D)lastCharAdvance).getY() + (double)letterSpacingVal);
                } else {
                    ((Point2D)lastCharAdvance).setLocation(((Point2D)lastCharAdvance).getX() + (double)letterSpacingVal, ((Point2D)lastCharAdvance).getY());
                }
            } else if (this.vertical) {
                ((Point2D)lastCharAdvance).setLocation(((Point2D)lastCharAdvance).getX(), this.gv.getGlyphMetrics(numGlyphs - 2).getBounds2D().getHeight() + (double)kernVal + (double)letterSpacingVal);
            } else {
                ((Point2D)lastCharAdvance).setLocation(this.gv.getGlyphMetrics(numGlyphs - 2).getBounds2D().getWidth() + (double)kernVal + (double)letterSpacingVal, ((Point2D)lastCharAdvance).getY());
            }
            dx = 0.0f;
            dy = 0.0f;
            prevPos = this.gv.getGlyphPosition(0);
            x = (float)prevPos.getX();
            y = (float)prevPos.getY();
            if (numGlyphs > 1 && doWordSpacing) {
                i = 1;
                while (i < numGlyphs) {
                    Point2D gpos = this.gv.getGlyphPosition(i);
                    dx = (float)gpos.getX() - (float)prevPos.getX();
                    dy = (float)gpos.getY() - (float)prevPos.getY();
                    boolean inWS = false;
                    int beginWS = i;
                    int endWS = i;
                    GVTGlyphMetrics gm = this.gv.getGlyphMetrics(i);
                    while (gm.getBounds2D().getWidth() < 0.01 || gm.isWhitespace()) {
                        if (!inWS) {
                            inWS = true;
                        }
                        if (i == numGlyphs - 1) break;
                        ++endWS;
                        gpos = this.gv.getGlyphPosition(++i);
                        gm = this.gv.getGlyphMetrics(i);
                    }
                    if (inWS) {
                        int nWS = endWS - beginWS;
                        float px = (float)prevPos.getX();
                        float py = (float)prevPos.getY();
                        dx = (float)(gpos.getX() - (double)px) / (float)(nWS + 1);
                        dy = (float)(gpos.getY() - (double)py) / (float)(nWS + 1);
                        if (this.vertical) {
                            dy += wordSpacing.floatValue() / (float)(nWS + 1);
                        } else {
                            dx += wordSpacing.floatValue() / (float)(nWS + 1);
                        }
                        int j = beginWS;
                        while (j <= endWS) {
                            newPositions[j] = new Point2D.Float(x += dx, y += dy);
                            ++j;
                        }
                    } else {
                        dx = (float)(gpos.getX() - prevPos.getX());
                        dy = (float)(gpos.getY() - prevPos.getY());
                        newPositions[i] = new Point2D.Float(x += dx, y += dy);
                    }
                    prevPos = gpos;
                    ++i;
                }
                Point2D gPos = this.gv.getGlyphPosition(numGlyphs);
                newPositions[numGlyphs] = new Point2D.Float(x += (float)(gPos.getX() - prevPos.getX()), y += (float)(gPos.getY() - prevPos.getY()));
                int i3 = 1;
                while (i3 <= numGlyphs) {
                    if (newPositions[i3] != null) {
                        this.gv.setGlyphPosition(i3, newPositions[i3]);
                    }
                    ++i3;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        double advX = this.gv.getGlyphPosition(numGlyphs - 1).getX() - this.gv.getGlyphPosition(0).getX();
        double advY = this.gv.getGlyphPosition(numGlyphs - 1).getY() - this.gv.getGlyphPosition(0).getY();
        Point2D.Double newAdvance = new Point2D.Double(advX + ((Point2D)lastCharAdvance).getX(), advY + ((Point2D)lastCharAdvance).getY());
        return newAdvance;
    }

    protected void applyStretchTransform(boolean stretchGlyphs) {
        if (this.xScale == 1.0f && this.yScale == 1.0f) {
            return;
        }
        AffineTransform scaleAT = AffineTransform.getScaleInstance(this.xScale, this.yScale);
        int numGlyphs = this.gv.getNumGlyphs();
        float[] gp = this.gv.getGlyphPositions(0, numGlyphs + 1, null);
        float initX = gp[0];
        float initY = gp[1];
        float dx = 0.0f;
        float dy = 0.0f;
        int i = 0;
        while (i <= numGlyphs) {
            dx = gp[2 * i] - initX;
            dy = gp[2 * i + 1] - initY;
            this.gv.setGlyphPosition(i, new Point2D.Float(initX + dx * this.xScale, initY + dy * this.yScale));
            if (stretchGlyphs && i != numGlyphs) {
                AffineTransform glyphTransform = this.gv.getGlyphTransform(i);
                if (glyphTransform != null) {
                    glyphTransform.preConcatenate(scaleAT);
                    this.gv.setGlyphTransform(i, glyphTransform);
                } else {
                    this.gv.setGlyphTransform(i, scaleAT);
                }
            }
            ++i;
        }
        this.advance = new Point2D.Float((float)(this.advance.getX() * (double)this.xScale), (float)(this.advance.getY() * (double)this.yScale));
        this.layoutApplied = false;
    }

    protected void doPathLayout() {
        if (this.pathApplied) {
            return;
        }
        if (!this.spacingApplied) {
            this.adjustTextSpacing();
        }
        if (this.textPath == null) {
            this.pathApplied = true;
            return;
        }
        boolean horizontal = !this.isVertical();
        boolean glyphOrientationAuto = this.isGlyphOrientationAuto();
        int glyphOrientationAngle = 0;
        if (!glyphOrientationAuto) {
            glyphOrientationAngle = this.getGlyphOrientationAngle();
        }
        float pathLength = this.textPath.lengthOfPath();
        float startOffset = this.textPath.getStartOffset();
        int numGlyphs = this.gv.getNumGlyphs();
        int i = 0;
        while (i < numGlyphs) {
            this.gv.setGlyphVisible(i, true);
            ++i;
        }
        float glyphsLength = horizontal ? (float)this.gv.getLogicalBounds().getWidth() : (float)this.gv.getLogicalBounds().getHeight();
        if (pathLength == 0.0f || glyphsLength == 0.0f) {
            this.pathApplied = true;
            this.textPathAdvance = this.advance;
            return;
        }
        float currentPosition = horizontal ? (float)this.offset.getX() + startOffset : (float)this.offset.getY() + startOffset;
        Point2D firstGlyphPosition = this.gv.getGlyphPosition(0);
        float glyphOffset = 0.0f;
        glyphOffset = horizontal ? (float)firstGlyphPosition.getY() : (float)firstGlyphPosition.getX();
        char ch = this.aci.first();
        int currentChar = this.aci.getBeginIndex();
        int lastGlyphDrawn = -1;
        float lastGlyphAdvance = 0.0f;
        int i2 = 0;
        while (i2 < numGlyphs) {
            Point2D currentGlyphPosition = this.gv.getGlyphPosition(i2);
            float glyphAdvance = 0.0f;
            float nextGlyphOffset = 0.0f;
            if (i2 < this.gv.getNumGlyphs() - 1) {
                Point2D nextGlyphPosition = this.gv.getGlyphPosition(i2 + 1);
                if (horizontal) {
                    glyphAdvance = (float)(nextGlyphPosition.getX() - currentGlyphPosition.getX());
                    nextGlyphOffset = (float)(nextGlyphPosition.getY() - currentGlyphPosition.getY());
                } else {
                    glyphAdvance = (float)(nextGlyphPosition.getY() - currentGlyphPosition.getY());
                    nextGlyphOffset = (float)(nextGlyphPosition.getX() - currentGlyphPosition.getX());
                }
            } else {
                GVTGlyphMetrics gm = this.gv.getGlyphMetrics(i2);
                glyphAdvance = horizontal ? gm.getHorizontalAdvance() : (glyphOrientationAuto ? (this.isLatinChar(ch) ? gm.getHorizontalAdvance() : gm.getVerticalAdvance()) : (glyphOrientationAngle == 0 || glyphOrientationAngle == 180 ? gm.getVerticalAdvance() : gm.getHorizontalAdvance()));
            }
            Rectangle2D glyphBounds = this.gv.getGlyphOutline(i2).getBounds2D();
            float glyphWidth = (float)glyphBounds.getWidth();
            float glyphHeight = (float)glyphBounds.getHeight();
            float charMidPos = horizontal ? currentPosition + glyphWidth / 2.0f : currentPosition + glyphHeight / 2.0f;
            Point2D charMidPoint = this.textPath.pointAtLength(charMidPos);
            if (charMidPoint != null) {
                float angle = this.textPath.angleAtLength(charMidPos);
                AffineTransform glyphPathTransform = new AffineTransform();
                if (horizontal) {
                    glyphPathTransform.rotate(angle);
                } else {
                    glyphPathTransform.rotate((double)angle - 1.5707963267948966);
                }
                if (horizontal) {
                    glyphPathTransform.translate(0.0, glyphOffset);
                } else {
                    glyphPathTransform.translate(glyphOffset, 0.0);
                }
                if (horizontal) {
                    glyphPathTransform.translate(glyphWidth / -2.0f, 0.0);
                } else if (glyphOrientationAuto) {
                    if (this.isLatinChar(ch)) {
                        glyphPathTransform.translate(0.0, -glyphHeight / 2.0f);
                    } else {
                        glyphPathTransform.translate(0.0, glyphHeight / 2.0f);
                    }
                } else if (glyphOrientationAngle == 0) {
                    glyphPathTransform.translate(0.0, glyphHeight / 2.0f);
                } else {
                    glyphPathTransform.translate(0.0, -glyphHeight / 2.0f);
                }
                AffineTransform glyphTransform = this.gv.getGlyphTransform(i2);
                if (glyphTransform != null) {
                    glyphPathTransform.concatenate(glyphTransform);
                }
                this.gv.setGlyphTransform(i2, glyphPathTransform);
                this.gv.setGlyphPosition(i2, new Point2D.Double(charMidPoint.getX(), charMidPoint.getY()));
                lastGlyphDrawn = i2;
                lastGlyphAdvance = glyphAdvance;
            } else {
                this.gv.setGlyphVisible(i2, false);
            }
            currentPosition += glyphAdvance;
            glyphOffset += nextGlyphOffset;
            currentChar += this.gv.getCharacterCount(i2, i2);
            ch = this.aci.setIndex(this.aci.getBeginIndex() + i2 + this.gv.getCharacterCount(i2, i2));
            ++i2;
        }
        if (lastGlyphDrawn > -1) {
            Point2D lastGlyphPos = this.gv.getGlyphPosition(lastGlyphDrawn);
            this.textPathAdvance = horizontal ? new Point2D.Double(lastGlyphPos.getX() + (double)lastGlyphAdvance, lastGlyphPos.getY()) : new Point2D.Double(lastGlyphPos.getX(), lastGlyphPos.getY() + (double)lastGlyphAdvance);
        } else {
            this.textPathAdvance = new Point2D.Double(0.0, 0.0);
        }
        this.layoutApplied = false;
        this.spacingApplied = false;
        this.pathApplied = true;
    }

    protected boolean isLatinChar(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return block == Character.UnicodeBlock.BASIC_LATIN || block == Character.UnicodeBlock.LATIN_1_SUPPLEMENT || block == Character.UnicodeBlock.LATIN_EXTENDED_ADDITIONAL || block == Character.UnicodeBlock.LATIN_EXTENDED_A || block == Character.UnicodeBlock.LATIN_EXTENDED_B;
    }

    protected boolean isGlyphOrientationAuto() {
        boolean glyphOrientationAuto = true;
        this.aci.first();
        if (this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION) != null) {
            glyphOrientationAuto = this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION) == GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_AUTO;
        }
        return glyphOrientationAuto;
    }

    protected int getGlyphOrientationAngle() {
        int glyphOrientationAngle = 0;
        this.aci.first();
        Float angle = (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION_ANGLE);
        if (angle != null) {
            glyphOrientationAngle = (int)angle.floatValue();
        }
        if (glyphOrientationAngle != 0 || glyphOrientationAngle != 90 || glyphOrientationAngle != 180 || glyphOrientationAngle != 270) {
            while (glyphOrientationAngle < 0) {
                glyphOrientationAngle += 360;
            }
            while (glyphOrientationAngle >= 360) {
                glyphOrientationAngle -= 360;
            }
            glyphOrientationAngle = glyphOrientationAngle <= 45 || glyphOrientationAngle > 315 ? 0 : (glyphOrientationAngle > 45 && glyphOrientationAngle <= 135 ? 90 : (glyphOrientationAngle > 135 && glyphOrientationAngle <= 225 ? 180 : 270));
        }
        return glyphOrientationAngle;
    }

    public static void textWrapTextChunk(AttributedCharacterIterator[] acis, List chunkLayouts, List flowRects) {
        int numChunks = acis.length;
        GVTGlyphVector[] gvs = new GVTGlyphVector[acis.length];
        Iterator clIter = chunkLayouts.iterator();
        Iterator flowRectsIter = flowRects.iterator();
        Rectangle2D cRect = (Rectangle2D)flowRectsIter.next();
        float height = (float)cRect.getHeight();
        boolean lineHeightRelative = true;
        float lineHeight = 1.0f;
        float nextLineMult = 0.0f;
        float dy = 0.0f;
        float prevBotMargin = 0.0f;
        int chunk = 0;
        while (clIter.hasNext()) {
            AttributedCharacterIterator aci = acis[chunk];
            List extraP = (List)aci.getAttribute(FLOW_EMPTY_PARAGRAPH);
            if (extraP != null) {
                Iterator epi = extraP.iterator();
                while (epi.hasNext()) {
                    float inc;
                    MarginInfo emi = (MarginInfo)epi.next();
                    float f = inc = prevBotMargin > emi.getTopMargin() ? prevBotMargin : emi.getTopMargin();
                    if (dy + inc <= height && !emi.isFlowRegionBreak()) {
                        dy += inc;
                    } else {
                        if (!flowRectsIter.hasNext()) {
                            cRect = null;
                            break;
                        }
                        cRect = (Rectangle2D)flowRectsIter.next();
                        height = (float)cRect.getHeight();
                        dy = emi.getTopMargin();
                    }
                    prevBotMargin = emi.getBottomMargin();
                }
                if (cRect == null) break;
            }
            LinkedList<GVTGlyphVector> gvl = new LinkedList<GVTGlyphVector>();
            List layouts = (List)clIter.next();
            Iterator iter = layouts.iterator();
            while (iter.hasNext()) {
                GlyphLayout gl = (GlyphLayout)iter.next();
                gvl.add(gl.getGlyphVector());
            }
            MultiGlyphVector gv = new MultiGlyphVector(gvl);
            gvs[chunk] = gv;
            int numGlyphs = gv.getNumGlyphs();
            aci.first();
            MarginInfo mi = (MarginInfo)aci.getAttribute(FLOW_PARAGRAPH);
            if (mi != null) {
                int justification = mi.getJustification();
                if (cRect == null) {
                    int idx = 0;
                    while (idx < numGlyphs) {
                        gv.setGlyphVisible(idx, false);
                        ++idx;
                    }
                } else {
                    float inc;
                    float f = inc = prevBotMargin > mi.getTopMargin() ? prevBotMargin : mi.getTopMargin();
                    if (dy + inc <= height) {
                        dy += inc;
                    } else {
                        if (!flowRectsIter.hasNext()) {
                            cRect = null;
                            break;
                        }
                        cRect = (Rectangle2D)flowRectsIter.next();
                        height = (float)cRect.getHeight();
                        dy = mi.getTopMargin();
                    }
                    prevBotMargin = mi.getBottomMargin();
                    float leftMargin = mi.getFirstLineLeftMargin();
                    float rightMargin = mi.getFirstLineRightMargin();
                    float x0 = (float)cRect.getX() + leftMargin;
                    float y0 = (float)cRect.getY();
                    float width = (float)(cRect.getWidth() - (double)(leftMargin + rightMargin));
                    height = (float)cRect.getHeight();
                    LinkedList<LineInfo> lineInfos = new LinkedList<LineInfo>();
                    float prevDesc = 0.0f;
                    GlyphIterator gi = new GlyphIterator(aci, gv);
                    GlyphIterator breakGI = null;
                    GlyphIterator newBreakGI = null;
                    if (!gi.done() && !gi.isPrinting()) {
                        lineInfos.add(gi.newLine(new Point2D.Float(x0, y0 + dy), width, true));
                    }
                    GlyphIterator lineGI = gi.copy();
                    boolean firstLine = true;
                    while (!gi.done()) {
                        boolean doBreak = false;
                        boolean partial = false;
                        if (gi.isPrinting() && gi.getAdv() > width) {
                            if (breakGI == null) {
                                if (!flowRectsIter.hasNext()) {
                                    cRect = null;
                                    gi = lineGI.copy(gi);
                                    break;
                                }
                                cRect = (Rectangle2D)flowRectsIter.next();
                                x0 = (float)cRect.getX() + leftMargin;
                                y0 = (float)cRect.getY();
                                width = (float)(cRect.getWidth() - (double)(leftMargin + rightMargin));
                                height = (float)cRect.getHeight();
                                dy = firstLine ? mi.getTopMargin() : 0.0f;
                                prevDesc = 0.0f;
                                gi = lineGI.copy(gi);
                                continue;
                            }
                            gi = breakGI.copy(gi);
                            nextLineMult = 1.0f;
                            doBreak = true;
                            partial = false;
                        } else if (gi.isLastChar()) {
                            nextLineMult = 1.0f;
                            doBreak = true;
                            partial = true;
                        }
                        int lnBreaks = gi.getLineBreaks();
                        if (lnBreaks != 0) {
                            if (doBreak) {
                                nextLineMult -= 1.0f;
                            }
                            nextLineMult += (float)lnBreaks;
                            doBreak = true;
                            partial = true;
                        }
                        if (!doBreak) {
                            if (gi.isBreakChar() || breakGI == null || !breakGI.isBreakChar()) {
                                newBreakGI = gi.copy(newBreakGI);
                                gi.nextChar();
                                if (gi.getChar() == '\u200d') continue;
                                GlyphIterator tmpGI = breakGI;
                                breakGI = newBreakGI;
                                newBreakGI = tmpGI;
                                continue;
                            }
                            gi.nextChar();
                            continue;
                        }
                        float lineSize = gi.getMaxAscent() + gi.getMaxDescent();
                        float lineBoxHeight = lineHeightRelative ? gi.getMaxFontSize() * lineHeight : lineHeight;
                        float halfLeading = (lineBoxHeight - lineSize) / 2.0f;
                        float ladv = prevDesc + halfLeading + gi.getMaxAscent();
                        float newDesc = halfLeading + gi.getMaxDescent();
                        dy += ladv;
                        float bottomEdge = newDesc;
                        if (newDesc < gi.getMaxDescent()) {
                            bottomEdge = gi.getMaxDescent();
                        }
                        if (dy + bottomEdge > height) {
                            if (!flowRectsIter.hasNext()) {
                                cRect = null;
                                gi = lineGI.copy(gi);
                                break;
                            }
                            float oldWidth = width;
                            cRect = (Rectangle2D)flowRectsIter.next();
                            x0 = (float)cRect.getX() + leftMargin;
                            y0 = (float)cRect.getY();
                            width = (float)(cRect.getWidth() - (double)(leftMargin + rightMargin));
                            height = (float)cRect.getHeight();
                            dy = firstLine ? mi.getTopMargin() : 0.0f;
                            prevDesc = 0.0f;
                            if (!(gi.getAdv() > oldWidth)) continue;
                            gi = lineGI.copy(gi);
                            continue;
                        }
                        prevDesc = newDesc + (nextLineMult - 1.0f) * lineBoxHeight;
                        nextLineMult = 0.0f;
                        lineInfos.add(gi.newLine(new Point2D.Float(x0, y0 + dy), width, partial));
                        x0 -= leftMargin;
                        width += leftMargin + rightMargin;
                        leftMargin = mi.getLeftMargin();
                        rightMargin = mi.getRightMargin();
                        x0 += leftMargin;
                        width -= leftMargin + rightMargin;
                        firstLine = false;
                        lineGI = gi.copy(lineGI);
                        breakGI = null;
                    }
                    dy += prevDesc;
                    int idx = gi.getGlyphIndex();
                    while (idx < numGlyphs) {
                        gv.setGlyphVisible(idx++, false);
                    }
                    GlyphLayout.layoutChunk(aci, gv, gi.getOrigin(), justification, lineInfos);
                    if (mi.isFlowRegionBreak()) {
                        cRect = null;
                        if (flowRectsIter.hasNext()) {
                            cRect = (Rectangle2D)flowRectsIter.next();
                            height = (float)cRect.getHeight();
                            dy = mi.getTopMargin();
                        }
                    }
                }
            }
            ++chunk;
        }
    }

    public static void layoutChunk(AttributedCharacterIterator aci, GVTGlyphVector gv, Point2D origin, int justification, List lineInfos) {
        float y;
        float x;
        Iterator lInfoIter = lineInfos.iterator();
        int numGlyphs = gv.getNumGlyphs();
        float[] gp = gv.getGlyphPositions(0, numGlyphs + 1, null);
        Point2D.Float lineLoc = null;
        float lineAdv = 0.0f;
        float lineVAdv = 0.0f;
        float xOrig = (float)origin.getX();
        float yOrig = (float)origin.getY();
        float xScale = 1.0f;
        float xAdj = 0.0f;
        float charW = 0.0f;
        float lineWidth = 0.0f;
        boolean partial = false;
        int lineEnd = 0;
        int i = 0;
        while (i < numGlyphs) {
            if (i == lineEnd) {
                xOrig += lineAdv;
                if (!lInfoIter.hasNext()) break;
                LineInfo li = (LineInfo)lInfoIter.next();
                lineEnd = li.getEndIdx();
                lineLoc = li.getLocation();
                lineAdv = li.getAdvance();
                lineVAdv = li.getVisualAdvance();
                charW = li.getLastCharWidth();
                lineWidth = li.getLineWidth();
                partial = li.isPartialLine();
                xAdj = 0.0f;
                xScale = 1.0f;
                switch (justification) {
                    default: {
                        break;
                    }
                    case 1: {
                        xAdj = (lineWidth - lineVAdv) / 2.0f;
                        break;
                    }
                    case 2: {
                        xAdj = lineWidth - lineVAdv;
                        break;
                    }
                    case 3: {
                        if (partial || lineEnd == i + 1) break;
                        xScale = (lineWidth - charW) / (lineVAdv - charW);
                    }
                }
            }
            x = lineLoc.x + (gp[2 * i] - xOrig) * xScale + xAdj;
            y = lineLoc.y + (gp[2 * i + 1] - yOrig);
            gv.setGlyphPosition(i, new Point2D.Float(x, y));
            ++i;
        }
        x = xOrig;
        y = yOrig;
        if (lineLoc != null) {
            x = lineLoc.x + (gp[2 * i] - xOrig) * xScale + xAdj;
            y = lineLoc.y + (gp[2 * i + 1] - yOrig);
        }
        gv.setGlyphPosition(i, new Point2D.Float(x, y));
    }

    static {
        runAtts.add(X);
        runAtts.add(Y);
        runAtts.add(DX);
        runAtts.add(DY);
        runAtts.add(ROTATION);
        runAtts.add(BASELINE_SHIFT);
        szAtts = new HashSet();
        szAtts.add(TextAttribute.SIZE);
        eps = 1.0E-5f;
    }
}

