/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.svg;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherEvent;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherListener;
import org.w3c.dom.svg.SVGDocument;

public class SVGLoadEventDispatcher
extends Thread {
    protected SVGDocument svgDocument;
    protected GraphicsNode root;
    protected BridgeContext bridgeContext;
    protected UpdateManager updateManager;
    protected List listeners = Collections.synchronizedList(new LinkedList());
    protected Exception exception;

    public SVGLoadEventDispatcher(GraphicsNode gn, SVGDocument doc, BridgeContext bc, UpdateManager um) {
        this.svgDocument = doc;
        this.root = gn;
        this.bridgeContext = bc;
        this.updateManager = um;
    }

    public void run() {
        try {
            this.fireStartedEvent();
            this.updateManager.dispatchSVGLoadEvent();
            this.fireCompletedEvent();
        }
        catch (InterruptedException e) {
            this.fireCancelledEvent();
        }
        catch (Exception e) {
            this.exception = e;
            this.fireFailedEvent();
        }
    }

    public UpdateManager getUpdateManager() {
        return this.updateManager;
    }

    public Exception getException() {
        return this.exception;
    }

    public void addSVGLoadEventDispatcherListener(SVGLoadEventDispatcherListener l) {
        this.listeners.add(l);
    }

    public void removeSVGLoadEventDispatcherListener(SVGLoadEventDispatcherListener l) {
        this.listeners.remove(l);
    }

    protected void fireStartedEvent() throws InterruptedException {
        block5: {
            final Object[] dll = this.listeners.toArray();
            if (dll.length <= 0) break block5;
            final SVGLoadEventDispatcherEvent ev = new SVGLoadEventDispatcherEvent(this, this.root);
            if (EventQueue.isDispatchThread()) {
                int i = 0;
                while (i < dll.length) {
                    SVGLoadEventDispatcherListener dl = (SVGLoadEventDispatcherListener)dll[i];
                    dl.svgLoadEventDispatchStarted(ev);
                    ++i;
                }
            } else {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        public void run() {
                            int i = 0;
                            while (i < dll.length) {
                                SVGLoadEventDispatcherListener dl = (SVGLoadEventDispatcherListener)dll[i];
                                dl.svgLoadEventDispatchStarted(ev);
                                ++i;
                            }
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
    }

    protected void fireCompletedEvent() {
        final Object[] dll = this.listeners.toArray();
        if (dll.length > 0) {
            final SVGLoadEventDispatcherEvent ev = new SVGLoadEventDispatcherEvent(this, this.root);
            if (EventQueue.isDispatchThread()) {
                int i = 0;
                while (i < dll.length) {
                    SVGLoadEventDispatcherListener dl = (SVGLoadEventDispatcherListener)dll[i];
                    dl.svgLoadEventDispatchCompleted(ev);
                    ++i;
                }
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        int i = 0;
                        while (i < dll.length) {
                            SVGLoadEventDispatcherListener dl = (SVGLoadEventDispatcherListener)dll[i];
                            dl.svgLoadEventDispatchCompleted(ev);
                            ++i;
                        }
                    }
                });
            }
        }
    }

    protected void fireFailedEvent() {
        final Object[] dll = this.listeners.toArray();
        if (dll.length > 0) {
            final SVGLoadEventDispatcherEvent ev = new SVGLoadEventDispatcherEvent(this, this.root);
            if (EventQueue.isDispatchThread()) {
                int i = 0;
                while (i < dll.length) {
                    SVGLoadEventDispatcherListener dl = (SVGLoadEventDispatcherListener)dll[i];
                    dl.svgLoadEventDispatchFailed(ev);
                    ++i;
                }
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        int i = 0;
                        while (i < dll.length) {
                            SVGLoadEventDispatcherListener dl = (SVGLoadEventDispatcherListener)dll[i];
                            dl.svgLoadEventDispatchFailed(ev);
                            ++i;
                        }
                    }
                });
            }
        }
    }

    protected void fireCancelledEvent() {
        final Object[] dll = this.listeners.toArray();
        if (dll.length > 0) {
            final SVGLoadEventDispatcherEvent ev = new SVGLoadEventDispatcherEvent(this, this.root);
            if (EventQueue.isDispatchThread()) {
                int i = 0;
                while (i < dll.length) {
                    SVGLoadEventDispatcherListener dl = (SVGLoadEventDispatcherListener)dll[i];
                    dl.svgLoadEventDispatchCancelled(ev);
                    ++i;
                }
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        int i = 0;
                        while (i < dll.length) {
                            SVGLoadEventDispatcherListener dl = (SVGLoadEventDispatcherListener)dll[i];
                            dl.svgLoadEventDispatchCancelled(ev);
                            ++i;
                        }
                    }
                });
            }
        }
    }
}

