/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.ArrayList;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.KeepValue;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.AbstractTableBody;
import org.apache.fop.fo.flow.RowSpanMgr;
import org.apache.fop.fo.flow.TableCell;
import org.apache.fop.fo.flow.TableColumn;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.RelativePositionProps;

public class TableRow
extends FObj {
    boolean setup = false;
    int breakAfter;
    String id;
    KeepValue keepWithNext;
    KeepValue keepWithPrevious;
    KeepValue keepTogether;
    int widthOfCellsSoFar = 0;
    int largestCellHeight = 0;
    int minHeight = 0;
    ArrayList columns;
    AreaContainer areaContainer;
    boolean areaAdded = false;
    boolean bIgnoreKeepTogether = false;
    private RowSpanMgr rowSpanMgr = null;
    private CellArray cellArray = null;

    public static FObj.Maker maker() {
        return new Maker();
    }

    public TableRow(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
        super(parent, propertyList, systemId, line, column);
        if (!(parent instanceof AbstractTableBody)) {
            throw new FOPException("A table row must be child of fo:table-body, fo:table-header or fo:table-footer, not " + parent.getName(), systemId, line, column);
        }
    }

    public String getName() {
        return "fo:table-row";
    }

    public void setColumns(ArrayList columns) {
        this.columns = columns;
    }

    public KeepValue getKeepWithPrevious() {
        return this.keepWithPrevious;
    }

    public void doSetup(Area area) throws FOPException {
        AccessibilityProps mAccProps = this.propMgr.getAccessibilityProps();
        AuralProps mAurProps = this.propMgr.getAuralProps();
        BorderAndPadding bap = this.propMgr.getBorderAndPadding();
        BackgroundProps bProps = this.propMgr.getBackgroundProps();
        RelativePositionProps mRelProps = this.propMgr.getRelativePositionProps();
        this.breakAfter = this.properties.get("break-after").getEnum();
        this.keepTogether = this.getKeepValue("keep-together.within-column");
        this.keepWithNext = this.getKeepValue("keep-with-next.within-column");
        this.keepWithPrevious = this.getKeepValue("keep-with-previous.within-column");
        this.id = this.properties.get("id").getString();
        this.minHeight = this.properties.get("height").getLength().mvalue();
        this.setup = true;
    }

    private KeepValue getKeepValue(String sPropName) {
        Property p = this.properties.get(sPropName);
        Number n = p.getNumber();
        if (n != null) {
            return new KeepValue("KEEP_WITH_VALUE", n.intValue());
        }
        switch (p.getEnum()) {
            case 6: {
                return new KeepValue("KEEP_WITH_ALWAYS", 0);
            }
        }
        return new KeepValue("KEEP_WITH_AUTO", 0);
    }

    public int layout(Area area) throws FOPException {
        if (this.marker == -1001) {
            return 1;
        }
        if (this.marker == -1000) {
            if (!this.setup) {
                this.doSetup(area);
            }
            if (this.cellArray == null) {
                this.initCellArray();
            }
            try {
                area.getIDReferences().createID(this.id);
            }
            catch (FOPException e) {
                if (!e.isLocationSet()) {
                    e.setLocation(this.systemId, this.line, this.column);
                }
                throw e;
            }
            this.marker = 0;
            int breakStatus = this.propMgr.checkBreakBefore(area);
            if (breakStatus != 1) {
                return breakStatus;
            }
        }
        if (this.marker == 0) {
            area.getIDReferences().configureID(this.id, area);
        }
        int spaceLeft = area.spaceLeft();
        this.areaContainer = new AreaContainer(this.propMgr.getFontState(area.getFontInfo()), 0, 0, area.getContentWidth(), spaceLeft, 88);
        this.areaContainer.foCreator = this;
        this.areaContainer.setPage(area.getPage());
        this.areaContainer.setParent(area);
        this.areaContainer.setBackground(this.propMgr.getBackgroundProps());
        this.areaContainer.start();
        this.areaContainer.setAbsoluteHeight(area.getAbsoluteHeight());
        this.areaContainer.setIDReferences(area.getIDReferences());
        this.largestCellHeight = this.minHeight;
        boolean someCellDidNotLayoutCompletely = false;
        int offset = 0;
        int iColIndex = 0;
        int i = 0;
        while (i < this.columns.size()) {
            TableColumn tcol = (TableColumn)this.columns.get(i);
            int colWidth = tcol.getColumnWidth();
            if (this.cellArray.getCellType(++iColIndex) != 1) {
                int h;
                if (this.rowSpanMgr.isInLastRow(iColIndex) && (h = this.rowSpanMgr.getRemainingHeight(iColIndex)) > this.largestCellHeight) {
                    this.largestCellHeight = h;
                }
                offset += colWidth;
            } else {
                TableCell cell = this.cellArray.getCell(iColIndex);
                cell.setStartOffset(offset);
                offset += colWidth;
                int rowSpan = cell.getNumRowsSpanned();
                int status = cell.layout(this.areaContainer);
                if (Status.isIncomplete(status)) {
                    if (this.keepTogether.getType() == "KEEP_WITH_ALWAYS" && !this.bIgnoreKeepTogether || status == 2 || rowSpan > 1) {
                        this.resetMarker();
                        this.removeID(area.getIDReferences());
                        return 2;
                    }
                    if (status == 3) {
                        someCellDidNotLayoutCompletely = true;
                    }
                }
                int h = cell.getHeight();
                if (rowSpan > 1) {
                    this.rowSpanMgr.addRowSpan(cell, iColIndex, cell.getNumColumnsSpanned(), h, rowSpan);
                } else if (h > this.largestCellHeight) {
                    this.largestCellHeight = h;
                }
            }
            ++i;
        }
        area.setMaxHeight(area.getMaxHeight() - spaceLeft + this.areaContainer.getMaxHeight());
        int iCol = 1;
        while (iCol <= this.columns.size()) {
            if (this.cellArray.getCellType(iCol) == 1 && !this.rowSpanMgr.isSpanned(iCol)) {
                this.cellArray.getCell(iCol).setRowHeight(this.largestCellHeight);
            }
            ++iCol;
        }
        this.rowSpanMgr.finishRow(this.largestCellHeight);
        area.addChild(this.areaContainer);
        this.areaContainer.setHeight(this.largestCellHeight);
        this.areaAdded = true;
        this.areaContainer.end();
        area.addDisplaySpace(this.largestCellHeight + this.areaContainer.getPaddingTop() + this.areaContainer.getBorderTopWidth() + this.areaContainer.getPaddingBottom() + this.areaContainer.getBorderBottomWidth());
        if (someCellDidNotLayoutCompletely) {
            return 3;
        }
        if (this.rowSpanMgr.hasUnfinishedSpans()) {
            return 8;
        }
        if (this.breakAfter == 83) {
            this.marker = -1001;
            return 4;
        }
        if (this.breakAfter == 80) {
            this.marker = -1001;
            return 6;
        }
        if (this.breakAfter == 35) {
            this.marker = -1001;
            return 5;
        }
        if (this.breakAfter == 20) {
            this.marker = -1001;
            return 7;
        }
        if (this.keepWithNext.getType() != "KEEP_WITH_AUTO") {
            return 8;
        }
        return 1;
    }

    public int getAreaHeight() {
        return this.areaContainer.getHeight();
    }

    public void removeLayout(Area area) {
        if (this.areaAdded) {
            area.removeChild(this.areaContainer);
            this.areaAdded = false;
        }
        this.resetMarker();
        this.removeID(area.getIDReferences());
    }

    public void resetMarker() {
        super.resetMarker();
    }

    public void setRowSpanMgr(RowSpanMgr rowSpanMgr) {
        this.rowSpanMgr = rowSpanMgr;
    }

    private void initCellArray() {
        this.cellArray = new CellArray(this.rowSpanMgr, this.columns.size());
        int colNum = 1;
        int i = 0;
        while (i < this.children.size()) {
            block9: {
                int cellColNum;
                int numCols;
                TableCell cell;
                block10: {
                    block8: {
                        colNum = this.cellArray.getNextFreeCell(colNum);
                        cell = (TableCell)this.children.get(i);
                        numCols = cell.getNumColumnsSpanned();
                        int numRows = cell.getNumRowsSpanned();
                        cellColNum = cell.getColumnNumber();
                        if (cellColNum != 0) break block8;
                        if (colNum < 1) break block9;
                        cellColNum = colNum;
                        break block10;
                    }
                    if (cellColNum > this.columns.size()) break block9;
                }
                if (cellColNum + numCols - 1 > this.columns.size()) {
                    numCols = this.columns.size() - cellColNum + 1;
                }
                this.cellArray.storeCell(cell, cellColNum, numCols);
                if (cellColNum > colNum) {
                    colNum = cellColNum;
                } else if (cellColNum < colNum) {
                    colNum = cellColNum;
                }
                int cellWidth = this.getCellWidth(cellColNum, numCols);
                cell.setWidth(cellWidth);
                colNum += numCols;
            }
            ++i;
        }
    }

    private int getCellWidth(int startCol, int numCols) {
        int width = 0;
        int count = 0;
        while (count < numCols) {
            width += ((TableColumn)this.columns.get(startCol + count - 1)).getColumnWidth();
            ++count;
        }
        return width;
    }

    void setIgnoreKeepTogether(boolean bIgnoreKeepTogether) {
        this.bIgnoreKeepTogether = bIgnoreKeepTogether;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
            return new TableRow(parent, propertyList, systemId, line, column);
        }
    }

    private static class CellArray {
        public static final byte EMPTY = 0;
        public static final byte CELLSTART = 1;
        public static final byte CELLSPAN = 2;
        private TableCell[] cells;
        private byte[] states;

        public CellArray(RowSpanMgr rsi, int numColumns) {
            this.cells = new TableCell[numColumns];
            this.states = new byte[numColumns];
            int i = 0;
            while (i < numColumns) {
                if (rsi.isSpanned(i + 1)) {
                    this.cells[i] = rsi.getSpanningCell(i + 1);
                    this.states[i] = 2;
                } else {
                    this.states[i] = 0;
                }
                ++i;
            }
        }

        int getNextFreeCell(int colNum) {
            int i = colNum - 1;
            while (i < this.states.length) {
                if (this.states[i] == 0) {
                    return i + 1;
                }
                ++i;
            }
            return -1;
        }

        int getCellType(int colNum) {
            if (colNum > 0 && colNum <= this.cells.length) {
                return this.states[colNum - 1];
            }
            return -1;
        }

        TableCell getCell(int colNum) {
            if (colNum > 0 && colNum <= this.cells.length) {
                return this.cells[colNum - 1];
            }
            return null;
        }

        boolean storeCell(TableCell cell, int colNum, int numCols) {
            boolean rslt = true;
            int index = colNum - 1;
            int count = 0;
            while (index < this.cells.length && count < numCols) {
                if (this.cells[index] == null) {
                    this.cells[index] = cell;
                    this.states[index] = count == 0 ? 1 : 2;
                } else {
                    rslt = false;
                }
                ++count;
                ++index;
            }
            return rslt;
        }
    }
}

