/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.DocumentFactory;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.TextPainter;
import org.apache.batik.gvt.renderer.StrokingTextPainter;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.XMLAbstractTranscoder;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.resources.Messages;
import org.apache.batik.transcoder.keys.StringKey;
import org.apache.batik.util.XMLResourceDescriptor;
import org.apache.fop.apps.FOPException;
import org.apache.fop.svg.PDFAElementBridge;
import org.apache.fop.svg.PDFDocumentGraphics2D;
import org.apache.fop.svg.PDFImageElementBridge;
import org.apache.fop.svg.PDFTextPainter;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class PDFTranscoder
extends XMLAbstractTranscoder {
    public static final TranscodingHints.Key KEY_STROKE_TEXT = new StringKey();
    protected UserAgent userAgent = new ImageTranscoderUserAgent();

    public PDFTranscoder() {
        this.hints.put((Object)XMLAbstractTranscoder.KEY_DOCUMENT_ELEMENT_NAMESPACE_URI, (Object)"http://www.w3.org/2000/svg");
        this.hints.put((Object)XMLAbstractTranscoder.KEY_DOCUMENT_ELEMENT, (Object)"svg");
        this.hints.put((Object)XMLAbstractTranscoder.KEY_DOM_IMPLEMENTATION, (Object)SVGDOMImplementation.getDOMImplementation());
    }

    protected void transcode(Document document, String uri, TranscoderOutput output) throws TranscoderException {
        PDFDocumentGraphics2D graphics;
        AffineTransform Px;
        float height;
        float width;
        GraphicsNode gvtRoot;
        if (!(document instanceof SVGOMDocument)) {
            throw new TranscoderException(Messages.formatMessage((String)"notsvg", null));
        }
        SVGDocument svgDoc = (SVGDocument)document;
        SVGSVGElement root = svgDoc.getRootElement();
        String parserClassname = (String)this.hints.get((Object)XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME);
        boolean stroke = true;
        if (this.hints.containsKey((Object)KEY_STROKE_TEXT)) {
            stroke = (Boolean)this.hints.get((Object)KEY_STROKE_TEXT);
        }
        GVTBuilder builder = new GVTBuilder();
        BridgeContext ctx = new BridgeContext(this.userAgent);
        Object textPainter = null;
        textPainter = new StrokingTextPainter();
        ctx.setTextPainter((TextPainter)textPainter);
        PDFAElementBridge pdfAElementBridge = new PDFAElementBridge();
        AffineTransform currentTransform = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        pdfAElementBridge.setCurrentTransform(currentTransform);
        ctx.putBridge((Bridge)pdfAElementBridge);
        ctx.putBridge((Bridge)new PDFImageElementBridge());
        try {
            gvtRoot = builder.build(ctx, (Document)svgDoc);
        }
        catch (BridgeException ex) {
            throw new TranscoderException((Exception)((Object)ex));
        }
        float docWidth = (float)ctx.getDocumentSize().getWidth();
        float docHeight = (float)ctx.getDocumentSize().getHeight();
        ctx = null;
        builder = null;
        float imgWidth = -1.0f;
        if (this.hints.containsKey((Object)ImageTranscoder.KEY_WIDTH)) {
            imgWidth = ((Float)this.hints.get((Object)ImageTranscoder.KEY_WIDTH)).floatValue();
        }
        float imgHeight = -1.0f;
        if (this.hints.containsKey((Object)ImageTranscoder.KEY_HEIGHT)) {
            imgHeight = ((Float)this.hints.get((Object)ImageTranscoder.KEY_HEIGHT)).floatValue();
        }
        if (imgWidth > 0.0f && imgHeight > 0.0f) {
            width = imgWidth;
            height = imgHeight;
        } else if (imgHeight > 0.0f) {
            width = docWidth * imgHeight / docHeight;
            height = imgHeight;
        } else if (imgWidth > 0.0f) {
            width = imgWidth;
            height = docHeight * imgWidth / docWidth;
        } else {
            width = docWidth;
            height = docHeight;
        }
        String ref = null;
        try {
            ref = new URL(uri).getRef();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            Px = ViewBox.getViewTransform((String)ref, (Element)root, (float)width, (float)height);
        }
        catch (BridgeException ex) {
            throw new TranscoderException((Exception)((Object)ex));
        }
        if (Px.isIdentity() && (width != docWidth || height != docHeight)) {
            float d = Math.max(docWidth, docHeight);
            float dd = Math.max(width, height);
            float scale = dd / d;
            Px = AffineTransform.getScaleInstance(scale, scale);
        }
        if (this.hints.containsKey((Object)ImageTranscoder.KEY_AOI)) {
            Rectangle2D aoi = (Rectangle2D)this.hints.get((Object)ImageTranscoder.KEY_AOI);
            aoi = Px.createTransformedShape(aoi).getBounds2D();
            AffineTransform Mx = new AffineTransform();
            double sx = (double)width / aoi.getWidth();
            double sy = (double)height / aoi.getHeight();
            Mx.scale(sx, sy);
            double tx = -aoi.getX();
            double ty = -aoi.getY();
            Mx.translate(tx, ty);
            Px.preConcatenate(Mx);
        }
        int w = (int)width;
        int h = (int)height;
        try {
            graphics = new PDFDocumentGraphics2D(stroke, output.getOutputStream(), w, h);
        }
        catch (FOPException ex) {
            throw new TranscoderException((Exception)ex);
        }
        graphics.setSVGDimension(docWidth, docHeight);
        currentTransform.setTransform(1.0, 0.0, 0.0, -1.0, 0.0, height);
        if (!stroke) {
            textPainter = new PDFTextPainter(graphics.getFontState());
            ctx.setTextPainter((TextPainter)textPainter);
        }
        if (this.hints.containsKey((Object)ImageTranscoder.KEY_BACKGROUND_COLOR)) {
            graphics.setBackgroundColor((Color)this.hints.get((Object)ImageTranscoder.KEY_BACKGROUND_COLOR));
        }
        graphics.setGraphicContext(new GraphicContext());
        gvtRoot.paint((Graphics2D)((Object)graphics));
        try {
            graphics.finish();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new TranscoderException(ex);
        }
    }

    protected DocumentFactory createDocumentFactory(DOMImplementation domImpl, String parserClassname) {
        return new SAXSVGDocumentFactory(parserClassname);
    }

    protected class ImageTranscoderUserAgent
    extends UserAgentAdapter {
        protected ImageTranscoderUserAgent() {
        }

        public boolean isXMLParserValidating() {
            return true;
        }

        public Dimension2D getViewportSize() {
            return new Dimension(400, 400);
        }

        public void displayError(String message) {
            try {
                PDFTranscoder.this.getErrorHandler().error(new TranscoderException(message));
            }
            catch (TranscoderException ex) {
                throw new RuntimeException();
            }
        }

        public void displayError(Exception e) {
            try {
                PDFTranscoder.this.getErrorHandler().error(new TranscoderException(e));
            }
            catch (TranscoderException ex) {
                throw new RuntimeException();
            }
        }

        public void displayMessage(String message) {
            try {
                PDFTranscoder.this.getErrorHandler().warning(new TranscoderException(message));
            }
            catch (TranscoderException ex) {
                throw new RuntimeException();
            }
        }

        public float getPixelToMM() {
            if (PDFTranscoder.this.getTranscodingHints().containsKey((Object)ImageTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER)) {
                return ((Float)PDFTranscoder.this.getTranscodingHints().get((Object)ImageTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER)).floatValue();
            }
            return 0.26458332f;
        }

        public String getLanguages() {
            if (PDFTranscoder.this.getTranscodingHints().containsKey((Object)ImageTranscoder.KEY_LANGUAGE)) {
                return (String)PDFTranscoder.this.getTranscodingHints().get((Object)ImageTranscoder.KEY_LANGUAGE);
            }
            return "en";
        }

        public String getMedia() {
            return "print";
        }

        public String getUserStyleSheetURI() {
            return (String)PDFTranscoder.this.getTranscodingHints().get((Object)ImageTranscoder.KEY_USER_STYLESHEET_URI);
        }

        public String getXMLParserClassName() {
            if (PDFTranscoder.this.getTranscodingHints().containsKey((Object)XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME)) {
                return (String)PDFTranscoder.this.getTranscodingHints().get((Object)XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME);
            }
            return XMLResourceDescriptor.getXMLParserClassName();
        }
    }
}

