/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.httpd;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.sqs_xml.httpd.DataHandler;
import net.sf.sqs_xml.httpd.MicroHttpd;
import net.sf.sqs_xml.httpd.SQSHttpdFactory;
import net.sf.sqs_xml.httpd.URLFilter;
import net.sf.sqs_xml.util.FileUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class FileContentServlet
extends HttpServlet {
    static Map altPathMap = new HashMap();
    static Map altPathMapRev = new HashMap();

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        String suffix = FileUtil.getSuffix(pathInfo);
        String encoding = null;
        if ("txt".equals(suffix)) {
            encoding = "MS932";
            response.setContentType("text/plain; charset=" + encoding);
            response.setCharacterEncoding(encoding);
        } else if ("html".equals(suffix)) {
            encoding = "UTF-8";
            response.setCharacterEncoding("text/html; charset=" + encoding);
        } else {
            String mime = (String)MicroHttpd.mimeMap.get(suffix);
            response.setContentType(mime);
        }
        File target = FileContentServlet.getFile(pathInfo);
        if ("html".equals(suffix)) {
            try {
                PrintWriter writer = FileUtil.createPrintWriter((OutputStream)response.getOutputStream(), encoding);
                String parserClass = "org.apache.crimson.parser.XMLReaderImpl";
                XMLReader reader = XMLReaderFactory.createXMLReader(parserClass);
                MicroHttpd httpd = SQSHttpdFactory.getInitialHttpd();
                URLFilter filter = new URLFilter(httpd, target.getParent());
                filter.setParent(reader);
                DataHandler handler = new DataHandler(writer);
                filter.setContentHandler(handler);
                reader.setErrorHandler(handler);
                InputSource file = new InputSource(new FileInputStream(target));
                filter.parse(file);
                writer.close();
            }
            catch (IOException ioe) {
                System.out.println("IO Exception: " + ioe.getLocalizedMessage());
            }
            catch (SAXException ex) {
                System.out.println("SAX Exception: " + ex.getLocalizedMessage());
            }
        } else if ("txt".equals(suffix)) {
            int length;
            BufferedWriter writer = new BufferedWriter(response.getWriter());
            char[] buf = new char[4096];
            Reader reader = FileUtil.createReader(new FileInputStream(target), encoding);
            while ((length = reader.read(buf, 0, 4096)) > 0) {
                ((Writer)writer).write(buf, 0, length);
            }
            reader.close();
            ((Writer)writer).close();
        } else {
            int length;
            BufferedOutputStream writer = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buf = new byte[4096];
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(FileContentServlet.getFile(pathInfo)));
            while ((length = ((InputStream)stream).read(buf, 0, 4096)) > 0) {
                ((OutputStream)writer).write(buf, 0, length);
            }
            ((InputStream)stream).close();
            ((OutputStream)writer).close();
        }
    }

    public static File getFile(String pathInContext) {
        if (pathInContext == null || pathInContext.length() == 0) {
            return null;
        }
        try {
            int separatorPosition = pathInContext.indexOf(".", 1);
            Integer altPathID = null;
            altPathID = separatorPosition > 0 ? new Integer(Integer.parseInt(pathInContext.substring(1, separatorPosition))) : new Integer(Integer.parseInt(pathInContext.substring(1)));
            String fileName = pathInContext.substring(separatorPosition + 1);
            return (File)altPathMapRev.get(altPathID);
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
            return null;
        }
    }

    static synchronized URL getAltURL(String base, File file) {
        Integer altPathID;
        if (altPathMap.containsKey(file)) {
            altPathID = (Integer)altPathMap.get(file);
        } else {
            altPathID = new Integer(altPathMap.size());
            altPathMap.put(file, altPathID);
            altPathMapRev.put(altPathID, file);
        }
        try {
            String name = file.getName();
            if (file.isDirectory()) {
                return new URL(String.valueOf(base) + "File/" + altPathID.toString());
            }
            return new URL(String.valueOf(base) + "File/" + altPathID.toString() + name.substring(name.indexOf(".")));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

