/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.reader.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.sqs_xml.reader.model.IRNSContainer;
import net.sf.sqs_xml.reader.model.IRNode;
import net.sf.sqs_xml.reader.model.RNSContext;
import net.sf.sqs_xml.reader.model.RStack;
import net.sf.sqs_xml.reader.model.UJAXP;
import net.sf.sqs_xml.reader.model.URelaxer;
import net.sf.sqs_xml.reader.model.URelaxer2;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TextareaImage
implements Serializable,
Cloneable,
IRNSContainer,
IRNode {
    private RNSContext rNSContext_ = new RNSContext(this, "http://sqs.cmr.sfc.keio.ac.jp/2004/reader");
    private String filename_;
    private Timestamp mtime_;
    private Element xmlElement;
    private IRNode parentRNode_;

    public TextareaImage() {
        this.filename_ = "";
        this.mtime_ = URelaxer.makeAutoSQLTimestamp();
    }

    public TextareaImage(TextareaImage source) {
        this.setup(source);
    }

    public TextareaImage(RStack stack) {
        this.setup(stack);
    }

    public TextareaImage(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public TextareaImage(Element element) {
        this.setup(element);
    }

    public TextareaImage(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public TextareaImage(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public TextareaImage(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public TextareaImage(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public TextareaImage(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public TextareaImage(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(TextareaImage source) {
        this.filename_ = source.filename_;
        this.mtime_ = source.mtime_;
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        this.xmlElement = element;
        RStack stack = new RStack(element);
        this.rNSContext_.declareNamespace(element);
        this.filename_ = URelaxer.getAttributePropertyAsString(element, "filename");
        this.mtime_ = URelaxer.getAttributePropertyAsSQLTimestamp(element, "mtime");
    }

    public Object clone() {
        return new TextareaImage(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElementNS("http://sqs.cmr.sfc.keio.ac.jp/2004/reader", "file");
        this.rNSContext_.setupNamespace(element);
        if (this.filename_ != null) {
            URelaxer.setAttributePropertyByString(element, "filename", this.filename_);
        }
        if (this.mtime_ != null) {
            URelaxer.setAttributePropertyBySQLTimestamp(element, "mtime", this.mtime_);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 2));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 2));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 2));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 2));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 2));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public RNSContext rGetRNSContext() {
        return this.rNSContext_;
    }

    public void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    public String getFilename() {
        return this.filename_;
    }

    public void setFilename(String filename) {
        this.filename_ = filename;
    }

    public Timestamp getMtime() {
        return this.mtime_;
    }

    public void setMtime(Timestamp mtime) {
        this.mtime_ = mtime;
    }

    public Element rGetElement() {
        return this.xmlElement;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        String prefix = this.rNSContext_.getPrefixByUri("http://sqs.cmr.sfc.keio.ac.jp/2004/reader");
        buffer.append("<");
        URelaxer.makeQName(prefix, "file", buffer);
        this.rNSContext_.makeNSMappings(buffer);
        if (this.filename_ != null) {
            buffer.append(" ");
            buffer.append("filename");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getFilename())));
            buffer.append("\"");
        }
        if (this.mtime_ != null) {
            buffer.append(" ");
            buffer.append("mtime");
            buffer.append("=\"");
            buffer.append(URelaxer.getString(this.getMtime()));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append("</");
        URelaxer.makeQName(prefix, "file", buffer);
        buffer.append(">");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        String prefix = this.rNSContext_.getPrefixByUri("http://sqs.cmr.sfc.keio.ac.jp/2004/reader");
        buffer.write("<");
        URelaxer.makeQName(prefix, "file", buffer);
        this.rNSContext_.makeNSMappings(buffer);
        if (this.filename_ != null) {
            buffer.write(" ");
            buffer.write("filename");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getFilename())));
            buffer.write("\"");
        }
        if (this.mtime_ != null) {
            buffer.write(" ");
            buffer.write("mtime");
            buffer.write("=\"");
            buffer.write(URelaxer.getString(this.getMtime()));
            buffer.write("\"");
        }
        buffer.write(">");
        buffer.write("</");
        URelaxer.makeQName(prefix, "file", buffer);
        buffer.write(">");
    }

    public void makeTextElement(PrintWriter buffer) {
        String prefix = this.rNSContext_.getPrefixByUri("http://sqs.cmr.sfc.keio.ac.jp/2004/reader");
        buffer.print("<");
        URelaxer.makeQName(prefix, "file", buffer);
        this.rNSContext_.makeNSMappings(buffer);
        if (this.filename_ != null) {
            buffer.print(" ");
            buffer.print("filename");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getFilename())));
            buffer.print("\"");
        }
        if (this.mtime_ != null) {
            buffer.print(" ");
            buffer.print("mtime");
            buffer.print("=\"");
            buffer.print(URelaxer.getString(this.getMtime()));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print("</");
        URelaxer.makeQName(prefix, "file", buffer);
        buffer.print(">");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getFilenameAsString() {
        return URelaxer.getString(this.getFilename());
    }

    public String getMtimeAsString() {
        return URelaxer.getString(this.getMtime());
    }

    public void setFilenameByString(String string) {
        this.setFilename(string);
    }

    public void setMtimeByString(String string) {
        this.setMtime(URelaxer.getSQLTimestamp(string));
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://sqs.cmr.sfc.keio.ac.jp/2004/reader", "file")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        if (!URelaxer.hasAttributeHungry(target, "filename")) {
            return false;
        }
        $match$ = true;
        if (!URelaxer.hasAttributeHungry(target, "mtime")) {
            return false;
        }
        $match$ = true;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return TextareaImage.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (TextareaImage.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

