/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.swing;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JTextField;

public abstract class FileDropAcceptableTextField
extends JTextField
implements DropTargetListener {
    public FileDropAcceptableTextField() {
        new DropTarget(this, 3, this, true);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                FileDropAcceptableTextField.this.drop(new File(FileDropAcceptableTextField.this.getText()));
            }
        });
    }

    public void drop(DropTargetDropEvent ev) {
        try {
            if ((ev.getDropAction() & 3) != 0) {
                ev.acceptDrop(3);
                Transferable transferable = ev.getTransferable();
                this.drop(transferable);
                ev.dropComplete(true);
            } else {
                ev.rejectDrop();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
    }

    private void drop(Transferable transferable) throws UnsupportedFlavorException, IOException {
        List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
        int i = 0;
        while (i < list.size()) {
            File file = (File)list.get(i);
            this.setText(file.getAbsolutePath());
            this.drop(file);
            ++i;
        }
    }

    public void dragEnter(DropTargetDragEvent e) {
        e.acceptDrag(3);
    }

    public void dragExit(DropTargetEvent e) {
    }

    public void dragOver(DropTargetDragEvent e) {
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public abstract void drop(File var1);
}

