/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.validators.datatype.AbstractNumericValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public class DoubleDatatypeValidator
extends AbstractNumericValidator {
    public int compare(String string, String string2) {
        try {
            double d = DoubleDatatypeValidator.dValueOf(string);
            double d2 = DoubleDatatypeValidator.dValueOf(string2);
            return this.compareDoubles(d, d2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    protected void assignAdditionalFacets(String string, Hashtable hashtable) throws InvalidDatatypeFacetException {
        throw new InvalidDatatypeFacetException(this.getErrorString(DatatypeMessageProvider.ILLEGAL_DOUBLE_FACET, 0, new Object[]{string}));
    }

    protected int compareValues(Object object, Object object2) {
        double d = (Double)object;
        double d2 = (Double)object2;
        return this.compareDoubles(d, d2);
    }

    protected void setMaxInclusive(String string) {
        this.fMaxInclusive = DoubleDatatypeValidator.dValueOf(string);
    }

    protected void setMinInclusive(String string) {
        this.fMinInclusive = DoubleDatatypeValidator.dValueOf(string);
    }

    protected void setMaxExclusive(String string) {
        this.fMaxExclusive = DoubleDatatypeValidator.dValueOf(string);
    }

    protected void setMinExclusive(String string) {
        this.fMinExclusive = DoubleDatatypeValidator.dValueOf(string);
    }

    protected void setEnumeration(Vector vector) throws InvalidDatatypeValueException {
        if (vector != null) {
            this.fEnumeration = new Double[vector.size()];
            Object var2_2 = null;
            try {
                int n = 0;
                while (n < vector.size()) {
                    this.fEnumeration[n] = DoubleDatatypeValidator.dValueOf((String)vector.elementAt(n));
                    ((DoubleDatatypeValidator)this.fBaseValidator).validate((String)vector.elementAt(n), null);
                    ++n;
                }
            }
            catch (Exception exception) {
                throw new InvalidDatatypeValueException(exception.getMessage());
            }
        }
    }

    protected String getMaxInclusive(boolean bl) {
        return bl ? ((DoubleDatatypeValidator)this.fBaseValidator).fMaxInclusive.toString() : ((Double)this.fMaxInclusive).toString();
    }

    protected String getMinInclusive(boolean bl) {
        return bl ? ((DoubleDatatypeValidator)this.fBaseValidator).fMinInclusive.toString() : ((Double)this.fMinInclusive).toString();
    }

    protected String getMaxExclusive(boolean bl) {
        return bl ? ((DoubleDatatypeValidator)this.fBaseValidator).fMaxExclusive.toString() : ((Double)this.fMaxExclusive).toString();
    }

    protected String getMinExclusive(boolean bl) {
        return bl ? ((DoubleDatatypeValidator)this.fBaseValidator).fMinExclusive.toString() : ((Double)this.fMinExclusive).toString();
    }

    protected void checkContentEnum(String string, Object object, Vector vector) throws InvalidDatatypeValueException {
        this.checkContent(string, object, vector, false);
    }

    protected void checkContent(String string, Object object, Vector vector, boolean bl) throws InvalidDatatypeValueException {
        if (this.fBaseValidator != null) {
            ((DoubleDatatypeValidator)this.fBaseValidator).checkContent(string, object, vector, true);
        }
        if (!((this.fFacetsDefined & 8) == 0 || this.fRegex != null && this.fRegex.matches(string))) {
            throw new InvalidDatatypeValueException("Value'" + string + "does not match regular expression facet" + this.fPattern);
        }
        if (bl) {
            return;
        }
        Double d = null;
        try {
            d = DoubleDatatypeValidator.dValueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidDatatypeValueException(this.getErrorString(DatatypeMessageProvider.NOT_DOUBLE, 0, new Object[]{string}));
        }
        if (vector != null) {
            int n = vector.size();
            Double[] doubleArray = new Double[n];
            int n2 = 0;
            try {
                while (n2 < n) {
                    doubleArray[n2] = DoubleDatatypeValidator.dValueOf((String)vector.elementAt(n2));
                    ++n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidDatatypeValueException(this.getErrorString(DatatypeMessageProvider.INVALID_ENUM_VALUE, 0, new Object[]{vector.elementAt(n2)}));
            }
            this.enumCheck(d, doubleArray);
        }
        this.boundsCheck(d);
        if ((this.fFacetsDefined & 0x10) != 0 && this.fEnumeration != null) {
            this.enumCheck(d, (Double[])this.fEnumeration);
        }
    }

    protected int getInvalidFacetMsg() {
        return DatatypeMessageProvider.ILLEGAL_DOUBLE_FACET;
    }

    private static final Double dValueOf(String string) throws NumberFormatException {
        Double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (string.equals("INF")) {
                d = new Double(Double.POSITIVE_INFINITY);
            }
            if (string.equals("-INF")) {
                d = new Double(Double.NEGATIVE_INFINITY);
            }
            if (string.equals("NaN")) {
                d = new Double(Double.NaN);
            }
            throw numberFormatException;
        }
        return d;
    }

    private final void enumCheck(double d, Double[] doubleArray) throws InvalidDatatypeValueException {
        int n = 0;
        while (n < doubleArray.length) {
            if (d == doubleArray[n]) {
                return;
            }
            ++n;
        }
        throw new InvalidDatatypeValueException(this.getErrorString(DatatypeMessageProvider.NOT_ENUM_VALUE, 0, new Object[]{new Double(d)}));
    }

    private final int compareDoubles(double d, double d2) {
        long l = Double.doubleToLongBits(d);
        long l2 = Double.doubleToLongBits(d2);
        if (d > d2) {
            return 1;
        }
        if (d < d2) {
            return -1;
        }
        if (l == l2) {
            return 0;
        }
        return l < l2 ? -1 : 1;
    }

    public DoubleDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public DoubleDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        super(datatypeValidator, hashtable, bl);
    }
}

