/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.CMYKColor;
import com.lowagie.text.pdf.DocumentFont;
import com.lowagie.text.pdf.FdfReader;
import com.lowagie.text.pdf.GrayColor;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRTokeniser;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.TextField;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class AcroFields {
    PdfReader reader;
    PdfWriter writer;
    HashMap fields;
    private int topFirst;
    private boolean generateAppearances = true;

    AcroFields(PdfReader reader, PdfWriter writer) {
        this.reader = reader;
        this.writer = writer;
        this.fill();
    }

    void fill() {
        this.fields = new HashMap();
        PdfDictionary top = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM));
        int k = 1;
        while (k <= this.reader.getNumberOfPages()) {
            PdfDictionary page = this.reader.getPageN(k);
            PdfArray annots = (PdfArray)PdfReader.getPdfObject(page.get(PdfName.ANNOTS));
            if (annots != null) {
                ArrayList arr = annots.getArrayList();
                int j = 0;
                while (j < arr.size()) {
                    PdfDictionary annot = (PdfDictionary)PdfReader.getPdfObject((PdfObject)arr.get(j));
                    if (PdfName.WIDGET.equals(annot.get(PdfName.SUBTYPE))) {
                        Item item;
                        PdfDictionary widget = annot;
                        PdfDictionary dic = new PdfDictionary();
                        dic.putAll(annot);
                        String name = "";
                        PdfDictionary value = null;
                        PdfObject lastV = null;
                        while (annot != null) {
                            dic.mergeDifferent(annot);
                            PdfString t = (PdfString)annot.get(PdfName.T);
                            if (t != null) {
                                name = String.valueOf(t.toUnicodeString()) + "." + name;
                            }
                            if (lastV == null && annot.get(PdfName.V) != null) {
                                lastV = annot.get(PdfName.V);
                            }
                            if (value == null && t != null) {
                                value = annot;
                                if (annot.get(PdfName.V) == null && lastV != null) {
                                    value.put(PdfName.V, lastV);
                                }
                            }
                            annot = (PdfDictionary)PdfReader.getPdfObject(annot.get(PdfName.PARENT));
                        }
                        if (name.length() > 0) {
                            name = name.substring(0, name.length() - 1);
                        }
                        if ((item = (Item)this.fields.get(name)) == null) {
                            item = new Item();
                            this.fields.put(name, item);
                        }
                        if (value == null) {
                            item.values.add(widget);
                        } else {
                            item.values.add(value);
                        }
                        item.widgets.add(widget);
                        item.widget_refs.add(arr.get(j));
                        if (top != null) {
                            dic.mergeDifferent(top);
                        }
                        item.merged.add(dic);
                        item.page.add(new Integer(k));
                    }
                    ++j;
                }
            }
            ++k;
        }
    }

    public String[] getAppearanceStates(String fieldName) {
        Item fd = (Item)this.fields.get(fieldName);
        if (fd == null) {
            return null;
        }
        HashMap names = new HashMap();
        ArrayList wd = fd.widgets;
        int k = 0;
        while (k < wd.size()) {
            PdfObject ob;
            PdfDictionary dic = (PdfDictionary)wd.get(k);
            if ((dic = (PdfDictionary)dic.get(PdfName.AP)) != null && (ob = dic.get(PdfName.N)) != null && ob.isDictionary()) {
                dic = (PdfDictionary)ob;
                Iterator it = dic.getKeys().iterator();
                while (it.hasNext()) {
                    String name = PdfName.decodeName(((PdfName)it.next()).toString());
                    names.put(name, null);
                }
            }
            ++k;
        }
        String[] out = new String[names.size()];
        return names.keySet().toArray(out);
    }

    public boolean renameField(String oldName, String newName) {
        int idx2;
        int idx1 = oldName.lastIndexOf(46) + 1;
        if (idx1 != (idx2 = newName.lastIndexOf(46) + 1)) {
            return false;
        }
        if (!oldName.substring(0, idx1).equals(newName.substring(0, idx2))) {
            return false;
        }
        if (this.fields.containsKey(newName)) {
            return false;
        }
        Item item = (Item)this.fields.get(oldName);
        if (item == null) {
            return false;
        }
        newName = newName.substring(idx2);
        PdfString ss = new PdfString(newName, "UnicodeBig");
        int k = 0;
        while (k < item.merged.size()) {
            PdfDictionary dic = (PdfDictionary)item.values.get(k);
            dic.put(PdfName.T, ss);
            dic = (PdfDictionary)item.merged.get(k);
            dic.put(PdfName.T, ss);
            ++k;
        }
        this.fields.remove(oldName);
        this.fields.put(newName, item);
        return true;
    }

    PdfAppearance getAppearance(PdfDictionary merged, String text) throws IOException, DocumentException {
        PdfDictionary bs;
        PdfDictionary mk;
        this.topFirst = 0;
        TextField tx = new TextField(this.writer, null, null);
        PdfString da = (PdfString)PdfReader.getPdfObject(merged.get(PdfName.DA));
        if (da != null) {
            PRIndirectReference iref;
            PdfDictionary font;
            PRTokeniser tk = new PRTokeniser(PdfEncodings.convertToBytes(da.toUnicodeString(), null));
            ArrayList<String> stack = new ArrayList<String>();
            String fontName = null;
            while (tk.nextToken()) {
                if (tk.getTokenType() == 4) continue;
                if (tk.getTokenType() == 10) {
                    String operator = tk.getStringValue();
                    if (operator.equals("Tf")) {
                        if (stack.size() >= 2) {
                            fontName = (String)stack.get(stack.size() - 2);
                            tx.setFontSize(new Float((String)stack.get(stack.size() - 1)).floatValue());
                        }
                    } else if (operator.equals("g")) {
                        float gray;
                        if (stack.size() >= 1 && (gray = new Float((String)stack.get(stack.size() - 1)).floatValue()) != 0.0f) {
                            tx.setTextColor(new GrayColor(gray));
                        }
                    } else if (operator.equals("rg")) {
                        if (stack.size() >= 3) {
                            float red = new Float((String)stack.get(stack.size() - 3)).floatValue();
                            float green = new Float((String)stack.get(stack.size() - 2)).floatValue();
                            float blue = new Float((String)stack.get(stack.size() - 1)).floatValue();
                            tx.setTextColor(new Color(red, green, blue));
                        }
                    } else if (operator.equals("k") && stack.size() >= 4) {
                        float cyan = new Float((String)stack.get(stack.size() - 4)).floatValue();
                        float magenta = new Float((String)stack.get(stack.size() - 3)).floatValue();
                        float yellow = new Float((String)stack.get(stack.size() - 2)).floatValue();
                        float black = new Float((String)stack.get(stack.size() - 1)).floatValue();
                        tx.setTextColor(new CMYKColor(cyan, magenta, yellow, black));
                    }
                    stack.clear();
                    continue;
                }
                stack.add(tk.getStringValue());
            }
            if (fontName != null && (font = (PdfDictionary)PdfReader.getPdfObject(merged.get(PdfName.DR))) != null && (font = (PdfDictionary)PdfReader.getPdfObject(font.get(PdfName.FONT))) != null && (iref = (PRIndirectReference)font.get(new PdfName(fontName))) != null) {
                tx.setFont(new DocumentFont(iref));
            }
        }
        if ((mk = (PdfDictionary)PdfReader.getPdfObject(merged.get(PdfName.MK))) != null) {
            PdfArray ar = (PdfArray)PdfReader.getPdfObject(mk.get(PdfName.BC));
            tx.setBorderColor(this.getMKColor(ar));
            ar = (PdfArray)PdfReader.getPdfObject(mk.get(PdfName.BG));
            tx.setBackgroundColor(this.getMKColor(ar));
            PdfNumber rotation = (PdfNumber)PdfReader.getPdfObject(mk.get(PdfName.R));
            if (rotation != null) {
                tx.setRotation(rotation.intValue());
            }
        }
        int flags = 0;
        PdfNumber nfl = (PdfNumber)PdfReader.getPdfObject(merged.get(PdfName.FF));
        if (nfl != null) {
            flags = nfl.intValue();
        }
        tx.setOptions((flags & 0x1000) == 0 ? 0 : 4);
        nfl = (PdfNumber)PdfReader.getPdfObject(merged.get(PdfName.Q));
        if (nfl != null) {
            if (nfl.intValue() == 1) {
                tx.setAlignment(1);
            } else if (nfl.intValue() == 2) {
                tx.setAlignment(2);
            }
        }
        if ((bs = (PdfDictionary)PdfReader.getPdfObject(merged.get(PdfName.BS))) != null) {
            PdfName s;
            PdfNumber w = (PdfNumber)PdfReader.getPdfObject(bs.get(PdfName.W));
            if (w != null) {
                tx.setBorderWidth(w.floatValue());
            }
            if (PdfName.D.equals(s = (PdfName)PdfReader.getPdfObject(bs.get(PdfName.S)))) {
                tx.setBorderStyle(1);
            } else if (PdfName.B.equals(s)) {
                tx.setBorderStyle(2);
            } else if (PdfName.I.equals(s)) {
                tx.setBorderStyle(3);
            } else if (PdfName.U.equals(s)) {
                tx.setBorderStyle(4);
            }
        } else {
            PdfArray bd = (PdfArray)PdfReader.getPdfObject(merged.get(PdfName.BORDER));
            if (bd != null) {
                ArrayList ar = bd.getArrayList();
                if (ar.size() >= 3) {
                    tx.setBorderWidth(((PdfNumber)ar.get(2)).floatValue());
                }
                if (ar.size() >= 4) {
                    tx.setBorderStyle(1);
                }
            }
        }
        PdfArray rect = (PdfArray)PdfReader.getPdfObject(merged.get(PdfName.RECT));
        Rectangle box = PdfReader.getNormalizedRectangle(rect);
        if (tx.getRotation() == 90 || tx.getRotation() == 270) {
            box = box.rotate();
        }
        tx.setBox(box);
        PdfName fieldType = (PdfName)PdfReader.getPdfObject(merged.get(PdfName.FT));
        if (PdfName.TX.equals(fieldType)) {
            PdfNumber maxLen = (PdfNumber)PdfReader.getPdfObject(merged.get(PdfName.MAXLEN));
            int len = 0;
            if (maxLen != null) {
                len = maxLen.intValue();
            }
            if (len > 0) {
                text = text.substring(0, Math.min(len, text.length()));
            }
            tx.setText(text);
            return tx.getAppearance();
        }
        if (!PdfName.CH.equals(fieldType)) {
            throw new DocumentException("An appearance was requested without a variable text field.");
        }
        if ((flags & 0x20000) != 0) {
            tx.setText(text);
            return tx.getAppearance();
        }
        PdfArray opt = (PdfArray)PdfReader.getPdfObject(merged.get(PdfName.OPT));
        boolean arrsize = false;
        if (opt != null) {
            ArrayList op = opt.getArrayList();
            String[] choices = new String[op.size()];
            String[] choicesExp = new String[op.size()];
            int k = 0;
            while (k < op.size()) {
                PdfObject obj = (PdfObject)op.get(k);
                if (obj.isString()) {
                    choices[k] = choicesExp[k] = ((PdfString)obj).toUnicodeString();
                } else {
                    ArrayList opar = ((PdfArray)obj).getArrayList();
                    choicesExp[k] = ((PdfString)opar.get(0)).toUnicodeString();
                    choices[k] = ((PdfString)opar.get(1)).toUnicodeString();
                }
                ++k;
            }
            int idx = 0;
            int k2 = 0;
            while (k2 < choices.length) {
                if (text.equals(choices[k2])) {
                    idx = k2;
                    break;
                }
                ++k2;
            }
            tx.setChoices(choices);
            tx.setChoiceExports(choicesExp);
            tx.setChoiceSelection(idx);
        }
        PdfAppearance app = tx.getListAppearance();
        this.topFirst = tx.getTopFirst();
        return app;
    }

    Color getMKColor(PdfArray ar) {
        if (ar == null) {
            return null;
        }
        ArrayList cc = ar.getArrayList();
        switch (cc.size()) {
            case 1: {
                return new GrayColor(((PdfNumber)cc.get(0)).floatValue());
            }
            case 3: {
                return new Color(((PdfNumber)cc.get(0)).floatValue(), ((PdfNumber)cc.get(1)).floatValue(), ((PdfNumber)cc.get(2)).floatValue());
            }
            case 4: {
                return new CMYKColor(((PdfNumber)cc.get(0)).floatValue(), ((PdfNumber)cc.get(1)).floatValue(), ((PdfNumber)cc.get(2)).floatValue(), ((PdfNumber)cc.get(3)).floatValue());
            }
        }
        return null;
    }

    public String getField(String name) {
        Item item = (Item)this.fields.get(name);
        if (item == null) {
            return null;
        }
        PdfObject v = PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.V));
        if (v == null) {
            return "";
        }
        if (v.isString()) {
            return ((PdfString)v).toUnicodeString();
        }
        return PdfName.decodeName(v.toString());
    }

    public void setFields(FdfReader fdf) throws IOException, DocumentException {
        HashMap fd = fdf.getFields();
        Iterator i = this.fields.keySet().iterator();
        while (i.hasNext()) {
            String f = (String)i.next();
            String v = fdf.getFieldValue(f);
            if (v == null) continue;
            this.setField(f, v);
        }
    }

    public boolean setField(String name, String value) throws IOException, DocumentException {
        return this.setField(name, value, value);
    }

    public boolean setField(String name, String value, String display) throws IOException, DocumentException {
        if (this.writer == null) {
            throw new DocumentException("This AcroFields instance is read-only.");
        }
        Item item = (Item)this.fields.get(name);
        if (item == null) {
            return false;
        }
        PdfName type = (PdfName)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.FT));
        if (PdfName.TX.equals(type) || PdfName.CH.equals(type)) {
            PdfString v = new PdfString(value, "UnicodeBig");
            int idx = 0;
            while (idx < item.values.size()) {
                ((PdfDictionary)item.values.get(idx)).put(PdfName.V, v);
                PdfDictionary merged = (PdfDictionary)item.merged.get(idx);
                merged.put(PdfName.V, v);
                PdfDictionary widget = (PdfDictionary)item.widgets.get(idx);
                if (this.generateAppearances) {
                    PdfDictionary appDic;
                    PdfAppearance app = this.getAppearance(merged, display);
                    if (PdfName.CH.equals(type)) {
                        PdfNumber n = new PdfNumber(this.topFirst);
                        widget.put(PdfName.TI, n);
                        merged.put(PdfName.TI, n);
                    }
                    if ((appDic = (PdfDictionary)PdfReader.getPdfObject(widget.get(PdfName.AP))) == null) {
                        appDic = new PdfDictionary();
                        widget.put(PdfName.AP, appDic);
                        merged.put(PdfName.AP, appDic);
                    }
                    appDic.put(PdfName.N, app.getIndirectReference());
                } else {
                    widget.remove(PdfName.AP);
                    merged.remove(PdfName.AP);
                }
                ++idx;
            }
            return true;
        }
        if (PdfName.BTN.equals(type)) {
            PdfNumber ff = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.FF));
            int flags = 0;
            if (ff != null) {
                flags = ff.intValue();
            }
            if ((flags & 0x10000) != 0) {
                return true;
            }
            PdfName v = new PdfName(value);
            if ((flags & 0x8000) == 0) {
                int idx = 0;
                while (idx < item.values.size()) {
                    ((PdfDictionary)item.values.get(idx)).put(PdfName.V, v);
                    PdfDictionary merged = (PdfDictionary)item.merged.get(idx);
                    merged.put(PdfName.V, v);
                    merged.put(PdfName.AS, v);
                    PdfDictionary widget = (PdfDictionary)item.widgets.get(idx);
                    widget.put(PdfName.AS, v);
                    ++idx;
                }
            } else {
                int idx = 0;
                while (idx < item.values.size()) {
                    ((PdfDictionary)item.values.get(idx)).put(PdfName.V, v);
                    PdfDictionary merged = (PdfDictionary)item.merged.get(idx);
                    PdfDictionary widget = (PdfDictionary)item.widgets.get(idx);
                    merged.put(PdfName.V, v);
                    if (this.isInAP(widget, v)) {
                        merged.put(PdfName.AS, v);
                        widget.put(PdfName.AS, v);
                    } else {
                        merged.put(PdfName.AS, PdfName.OFF);
                        widget.put(PdfName.AS, PdfName.OFF);
                    }
                    ++idx;
                }
            }
            return true;
        }
        return false;
    }

    boolean isInAP(PdfDictionary dic, PdfName check) {
        PdfDictionary appDic = (PdfDictionary)PdfReader.getPdfObject(dic.get(PdfName.AP));
        if (appDic == null) {
            return false;
        }
        PdfDictionary NDic = (PdfDictionary)PdfReader.getPdfObject(appDic.get(PdfName.N));
        return NDic != null && NDic.get(check) != null;
    }

    public HashMap getFields() {
        return this.fields;
    }

    public Item getFieldItem(String name) {
        return (Item)this.fields.get(name);
    }

    public float[] getFieldPositions(String name) {
        Item item = (Item)this.fields.get(name);
        if (item == null) {
            return null;
        }
        float[] ret = new float[item.page.size() * 5];
        int ptr = 0;
        int k = 0;
        while (k < item.page.size()) {
            try {
                PdfDictionary wd = (PdfDictionary)item.widgets.get(k);
                PdfArray rect = (PdfArray)wd.get(PdfName.RECT);
                if (rect != null) {
                    Rectangle r = PdfReader.getNormalizedRectangle(rect);
                    ret[ptr] = ((Integer)item.page.get(k)).floatValue();
                    int n = ++ptr;
                    ret[n] = r.left();
                    int n2 = ++ptr;
                    ret[n2] = r.bottom();
                    int n3 = ++ptr;
                    ret[n3] = r.right();
                    int n4 = ++ptr;
                    ++ptr;
                    ret[n4] = r.top();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++k;
        }
        if (ptr < ret.length) {
            float[] ret2 = new float[ptr];
            System.arraycopy(ret, 0, ret2, 0, ptr);
            return ret2;
        }
        return ret;
    }

    private int removeRefFromArray(PdfArray array, PdfObject refo) {
        ArrayList ar = array.getArrayList();
        if (refo == null || !refo.isIndirect()) {
            return ar.size();
        }
        PdfIndirectReference ref = (PdfIndirectReference)refo;
        int j = 0;
        while (j < ar.size()) {
            PdfObject obj = (PdfObject)ar.get(j);
            if (obj.isIndirect() && ((PdfIndirectReference)obj).getNumber() == ref.getNumber()) {
                ar.remove(j--);
            }
            ++j;
        }
        return ar.size();
    }

    public boolean removeFieldsFromPage(int page) {
        if (page < 1) {
            return false;
        }
        boolean found = false;
        Iterator it = this.fields.keySet().iterator();
        while (it.hasNext()) {
            boolean fr = this.removeField((String)it.next(), page);
            boolean bl = found = found || fr;
        }
        return found;
    }

    public boolean removeField(String name, int page) {
        Item item = (Item)this.fields.get(name);
        if (item == null) {
            return false;
        }
        PdfDictionary acroForm = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM));
        if (acroForm == null) {
            return false;
        }
        PdfArray arrayf = (PdfArray)PdfReader.getPdfObject(acroForm.get(PdfName.FIELDS));
        if (arrayf == null) {
            return false;
        }
        int k = 0;
        while (k < item.widget_refs.size()) {
            int pageV = (Integer)item.page.get(k);
            if (page == -1 || page == pageV) {
                PdfIndirectReference ref = (PdfIndirectReference)item.widget_refs.get(k);
                PdfDictionary wd = (PdfDictionary)PdfReader.getPdfObject(ref);
                PdfDictionary pageDic = this.reader.getPageN(pageV);
                PdfArray annots = (PdfArray)PdfReader.getPdfObject(pageDic.get(PdfName.ANNOTS));
                if (annots != null && this.removeRefFromArray(annots, ref) == 0) {
                    pageDic.remove(PdfName.ANNOTS);
                }
                PdfReader.killIndirect(ref);
                PdfIndirectReference kid = ref;
                while ((ref = (PdfIndirectReference)wd.get(PdfName.PARENT)) != null) {
                    wd = (PdfDictionary)PdfReader.getPdfObject(ref);
                    PdfArray kids = (PdfArray)PdfReader.getPdfObject(wd.get(PdfName.KIDS));
                    if (this.removeRefFromArray(kids, kid) != 0) break;
                    kid = ref;
                    PdfReader.killIndirect(ref);
                }
                if (ref == null) {
                    this.removeRefFromArray(arrayf, kid);
                }
                if (page != -1) {
                    item.merged.remove(k);
                    item.page.remove(k);
                    item.values.remove(k);
                    item.widget_refs.remove(k);
                    item.widgets.remove(k);
                    --k;
                }
            }
            ++k;
        }
        if (page == -1 || item.merged.size() == 0) {
            this.fields.remove(name);
        }
        return true;
    }

    public boolean removeField(String name) {
        return this.removeField(name, -1);
    }

    public boolean isGenerateAppearances() {
        return this.generateAppearances;
    }

    public void setGenerateAppearances(boolean generateAppearances) {
        this.generateAppearances = generateAppearances;
        PdfDictionary top = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM));
        if (generateAppearances) {
            top.remove(PdfName.NEEDAPPEARANCES);
        } else {
            top.put(PdfName.NEEDAPPEARANCES, PdfBoolean.PDFTRUE);
        }
    }

    public static class Item {
        public ArrayList values = new ArrayList();
        public ArrayList widgets = new ArrayList();
        public ArrayList widget_refs = new ArrayList();
        public ArrayList merged = new ArrayList();
        public ArrayList page = new ArrayList();
    }
}

