/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfString;
import java.util.GregorianCalendar;

class PdfDate
extends PdfString {
    PdfDate(GregorianCalendar d) {
        StringBuffer date = new StringBuffer("D:");
        date.append(this.setLength(d.get(1), 4));
        date.append(this.setLength(d.get(2) + 1, 2));
        date.append(this.setLength(d.get(5), 2));
        date.append(this.setLength(d.get(11), 2));
        date.append(this.setLength(d.get(12), 2));
        date.append(this.setLength(d.get(13), 2));
        int timezone = d.get(15) / 3600000;
        if (timezone == 0) {
            date.append("Z");
        } else if (timezone < 0) {
            date.append("-");
            timezone = -timezone;
        } else {
            date.append("+");
        }
        date.append(this.setLength(timezone, 2)).append("'");
        int zone = Math.abs(d.get(15) / 60000) - timezone * 60;
        date.append(this.setLength(zone, 2)).append("'");
        this.value = date.toString();
    }

    PdfDate() {
        this(new GregorianCalendar());
    }

    private String setLength(int i, int length) {
        StringBuffer tmp = new StringBuffer();
        tmp.append(i);
        while (tmp.length() < length) {
            tmp.insert(0, "0");
        }
        tmp.setLength(length);
        return tmp.toString();
    }
}

