/*

 SQSNodeTree.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/08/08

 */
package net.sf.sqs_xml.editor.sqs.swing;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.swing.JComponent;
import javax.swing.tree.TreePath;

import net.sf.sqs_xml.editor.base.source.DOMTreeSource;
import net.sf.sqs_xml.editor.base.swing.ModuleManager;
import net.sf.sqs_xml.editor.base.swing.NodeTreePane;
import net.sf.sqs_xml.editor.base.swing.SourceEditorMediator;
import net.sf.sqs_xml.editor.base.swing.SourceEditorTreeCellRenderer;

import org.w3c.dom.Node;


/**
 * @author hiroya
 *
 */
public class SQSNodeTreePane extends NodeTreePane{

    public SQSNodeTreePane(SourceEditorMediator mediator, DOMTreeSource source, final JComponent editorPane){
        super(mediator, source, editorPane);
        if(getModel() != null){
            expandRow(0);// expand root
            expandRow(2);// expand body
            expandRow(1);// expand head
            for(int i=this.getRowCount()-1; 0 <= i ; i--){
                TreePath path = this.getPathForRow(i);
                if("matrix-forms".equals(((Node)path.getLastPathComponent()).getLocalName())){
                    this.expandRow(i);
                }
            }
        }
    }
    
    public ModuleManager createEditorResourceFactory(){
    	return new SQSModuleManager();
	}

    public void setupRenderer(SourceEditorTreeCellRenderer renderer) {
    }

    Map map = new HashMap(); 
    public void initialize(){
    }
    
    public List getInsertWithinOption(Node node){
        return null;//TODO: insert
    }

    public List getInsertBeforeOption(Node node){
        return null;//TODO: insert
    }
    
    public List getInsertAfterOption(Node node){
        return null;//TODO: insert
    }
}
