/*
 * 
 
 SQStoHTMLTranslator.java

 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */
 package net.sf.sqs_xml.translator.logic;

 
 import java.io.InputStream;
 import java.io.OutputStream;

public class SQStoHTMLTranslator extends AbstractTranslator {
    public static final String SQS2HTML = prop.getString("sqs2html_xsl_file");
    
    public SQStoHTMLTranslator()throws TranslatorException{
        super();
    }
    
    public String[] getXsltFilenames(){
        return SQS2HTML.split(" ");
    }
    
	public void translate(InputStream sqsStream, TranslatorResource resource, OutputStream htmlStream, String baseURI) throws TranslatorException{
	    resource.setXsltFilenames(getXsltFilenames());
		super.translate(sqsStream, resource, htmlStream, baseURI);
	}

	public String[] getParameters(String filename) {
		if (filename.equals("htmlForm.xsl")) {
			return new String[]{
					"form-submit-label","送信"
			};
		}else{
			return null;
		}
	}		

}
