<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2004 SQS Development Team / Community Management Research Project.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:svg="http://www.w3.org/2000/svg" version="1.0">
	<xsl:template name="staple">
		<xsl:param name="left-right"/>
		<xsl:choose>
			<xsl:when test="$show-staple='true' and $left-right='left'">
				<svg:svg xml:space="default" width="60px" height="60px">
					<svg:g style="stroke:black; fill:white; stroke-width: 0.1">
						<svg:path d="M 60 0 L 0 60" stroke-dasharray="3,3"/>
						<svg:path d="M 26 10 L 19 17 Z"/>
						<svg:path d="M 17 19 L 10 26 Z"/>
					</svg:g>
				</svg:svg>
			</xsl:when>
			<xsl:when test="$show-staple='true' and $left-right='right'">
				<svg:svg xml:space="default" width="60px" height="60px">
					<svg:g style="stroke:black; fill:white; stroke-width: 0.1">
						<svg:path d="M 0 0 L 60 60" stroke-dasharray="3,3"/>
						<svg:path d="M 34 10 L 41 17 Z"/>
						<svg:path d="M 43 19 L 50 26 Z"/>
					</svg:g>
				</svg:svg>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
