<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2004 SQS Development Team / Community Management Research Project.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xhtml2="http://www.w3.org/2002/06/xhtml2" xmlns:fo="http://www.w3.org/1999/XSL/Format" version="1.0">
	<xsl:template match="xhtml2:span[@xhtml2:class='bold']">
		<fo:inline font-weight="bold">
			<xsl:apply-templates/>
		</fo:inline>
	</xsl:template>
	<xsl:template match="xhtml2:span[@class = 'small']">
		<fo:inline xsl:use-attribute-sets="small">
			<xsl:apply-templates/>
		</fo:inline>
	</xsl:template>
	<xsl:template match="xhtml2:strong">
		<fo:inline text-decoration="underline">
			<xsl:apply-templates/>
		</fo:inline>
	</xsl:template>
	<xsl:template match="xhtml2:l">
		<fo:block><xsl:apply-templates/></fo:block>
	</xsl:template>
	<xsl:template match="xhtml2:br">
		<fo:block><fo:inline color="white">&#10;</fo:inline></fo:block>
	</xsl:template>
	<xsl:template match="xhtml2:em">
		<fo:inline font-style="italic" font-weight="bold">
			<xsl:apply-templates/>
		</fo:inline>
	</xsl:template>
	<xsl:template match="xhtml2:img">
		<fo:external-graphics src="{@src}"/>
	</xsl:template>
	<xsl:template match="xhtml2:sup">
		<fo:inline baseline-shift="super">
			<xsl:apply-templates/>
		</fo:inline>
	</xsl:template>
	<xsl:template match="xhtml2:sub">
		<fo:inline baseline-shift="sub">
			<xsl:apply-templates/>
		</fo:inline>
	</xsl:template>
	<xsl:template match="xhtml2:div">
		<xsl:choose>
			<xsl:when test="@class = 'warning'">
				<fo:block xsl:use-attribute-sets="textbox">
					<xsl:apply-templates/>
				</fo:block>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates/>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:if test="substring-before(substring-after(attribute::style, 'page-brake-after:'), ';') = 'always'">
			<fo:block fo:break-after="page">
				<fo:inline color="white">.</fo:inline>
			</fo:block>
		</xsl:if>
	</xsl:template>
	<xsl:template match="xhtml2:ruby">
		<xsl:for-each select="xhtml2:rb">
			<xsl:apply-templates/>
		</xsl:for-each>
		<xsl:for-each select="xhtml2:rt">
			<fo:inline font-size="80%">(<xsl:apply-templates/>)</fo:inline>
		</xsl:for-each>
	</xsl:template>
	<!--
  <fo:inline-container baseline-indentifier="text-after-edge"
    text-indent="0mm" last-line-end-indent="0mm" start-indent="0mm" end-indent="0mm"
   >
   <fo:block font-size="0.5em" text-align="center" line-height="1.3" space-before.conditionality="retain" wrap-option="no-wrap">
     <xsl:apply-templates select="rt"/>
   </fo:block>
   <fo:block text-align="center" line-height="1" wrap-option="no-wrap">
     <xsl:apply-templates select="rb"/>
   </fo:block>
  </fo:inline-container>
-->
</xsl:stylesheet>
