/*

 ReaderRunnginState.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/07/03

 */
package net.sf.sqs_xml.reader.logic;

/**
 * @author hiroya
 *
 */
public class ReaderRunningState {
    public static final int NOT_STARTED = 0; 
    public static final int RUNNING = 1; 
    public static final int SUSPENDING = 2; 
    public static final int SUSPENDED = 3; 
    public static final int FINISHED = 4;
    public static final int ABORTED = 5;
    private int state = NOT_STARTED;   
   
    ReaderIndexMapper result;
    public ReaderRunningState(ReaderIndexMapper result){
        state = NOT_STARTED;
        this.result = result;
        result.reset();        
    }
    
    public ReaderIndexMapper getState(){
        return result;
    }
    
    public boolean taskStopRequested(){
        return state == SUSPENDING;
    }
    
    public void start(){
        if(state == NOT_STARTED){
            state = RUNNING;
        }
    }
    
    public void suspending(){
        if(state == RUNNING){
            state = SUSPENDING;
        }
    }

    public void spspended(){
        if(state == SUSPENDING){
            state = SUSPENDED;
        }
    }

    public void restart(){
        result.reset();
        if(state == SUSPENDED){
            state = RUNNING;
        }
    }
    
    public void finished(){
        if(state == RUNNING){
            state = FINISHED;
        }
    }

    public boolean isFinished(){
        return state == FINISHED;
    }
    
    public void aborted(){
        if(state == RUNNING){
            state = ABORTED;
        }
    }
    
    public synchronized void waitTaskStopped(){
        try{
            wait();
        }catch(InterruptedException ignore){
        }
    }
    
    public synchronized void notifyTaskStopped(){
        notifyAll();
    }
}
