/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package net.sf.sqs_xml.reader.model;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.w3c.dom.*;

/**
 * <b>ScanFrame</b> is generated from reader.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <define name="ScanFrame">
 *               <attribute name="x1">
 *                         <data type="int"/>
 *               </attribute>
 *               <attribute name="y1">
 * 					<data type="int"/>
 *               </attribute>              
 *               <attribute name="x2">
 * 					<data type="int"/>
 *               </attribute>                
 *               <attribute name="y2">
 * 					<data type="int"/>
 *               </attribute>                
 *               <attribute name="x3">
 * 					<data type="int"/>
 *               </attribute>                
 *               <attribute name="y3">
 *    					<data type="int"/>
 *               </attribute>  
 *               <attribute name="x4">
 * 					<data type="int"/>
 *               </attribute>                
 *               <attribute name="y4">
 * 					<data type="int"/>
 *               </attribute> 
 *               <optional>
 *                 <ref name="Page"/>
 *               </optional>
 * </define>-->
 * <!-- for javadoc -->
 * <pre> &lt;define name="ScanFrame"&gt;
 *               &lt;attribute name="x1"&gt;
 *                         &lt;data type="int"/&gt;
 *               &lt;/attribute&gt;
 *               &lt;attribute name="y1"&gt;
 * 					&lt;data type="int"/&gt;
 *               &lt;/attribute&gt;              
 *               &lt;attribute name="x2"&gt;
 * 					&lt;data type="int"/&gt;
 *               &lt;/attribute&gt;                
 *               &lt;attribute name="y2"&gt;
 * 					&lt;data type="int"/&gt;
 *               &lt;/attribute&gt;                
 *               &lt;attribute name="x3"&gt;
 * 					&lt;data type="int"/&gt;
 *               &lt;/attribute&gt;                
 *               &lt;attribute name="y3"&gt;
 *    					&lt;data type="int"/&gt;
 *               &lt;/attribute&gt;  
 *               &lt;attribute name="x4"&gt;
 * 					&lt;data type="int"/&gt;
 *               &lt;/attribute&gt;                
 *               &lt;attribute name="y4"&gt;
 * 					&lt;data type="int"/&gt;
 *               &lt;/attribute&gt; 
 *               &lt;optional&gt;
 *                 &lt;ref name="Page"/&gt;
 *               &lt;/optional&gt;
 * &lt;/define&gt;</pre>
 *
 * @version reader.rng (Fri Aug 06 03:48:33 GMT+09:00 2004)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class ScanFrame implements java.io.Serializable, Cloneable, IRNSContainer, IRNode {
    private RNSContext rNSContext_ = new RNSContext(this, "");
    private int x1_;
    private int y1_;
    private int x2_;
    private int y2_;
    private int x3_;
    private int y3_;
    private int x4_;
    private int y4_;
    private Page page_;
    private IRNode parentRNode_;

    /**
     * Creates a <code>ScanFrame</code>.
     *
     */
    public ScanFrame() {
    }

    /**
     * Creates a <code>ScanFrame</code>.
     *
     * @param source
     */
    public ScanFrame(ScanFrame source) {
        setup(source);
    }

    /**
     * Creates a <code>ScanFrame</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public ScanFrame(RStack stack) {
        setup(stack);
    }

    /**
     * Initializes the <code>ScanFrame</code> by the ScanFrame <code>source</code>.
     *
     * @param source
     */
    public void setup(ScanFrame source) {
        int size;
        x1_ = source.x1_;
        y1_ = source.y1_;
        x2_ = source.x2_;
        y2_ = source.y2_;
        x3_ = source.x3_;
        y3_ = source.y3_;
        x4_ = source.x4_;
        y4_ = source.y4_;
        if (source.page_ != null) {
            setPage((Page)source.getPage().clone());
        }
    }

    /**
     * Initializes the <code>ScanFrame</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        Element element = stack.getContextElement();
        x1_ = URelaxer.getAttributePropertyAsInt(element, "x1");
        stack.consumeAttribute(element.getAttributeNode("x1"));
        y1_ = URelaxer.getAttributePropertyAsInt(element, "y1");
        stack.consumeAttribute(element.getAttributeNode("y1"));
        x2_ = URelaxer.getAttributePropertyAsInt(element, "x2");
        stack.consumeAttribute(element.getAttributeNode("x2"));
        y2_ = URelaxer.getAttributePropertyAsInt(element, "y2");
        stack.consumeAttribute(element.getAttributeNode("y2"));
        x3_ = URelaxer.getAttributePropertyAsInt(element, "x3");
        stack.consumeAttribute(element.getAttributeNode("x3"));
        y3_ = URelaxer.getAttributePropertyAsInt(element, "y3");
        stack.consumeAttribute(element.getAttributeNode("y3"));
        x4_ = URelaxer.getAttributePropertyAsInt(element, "x4");
        stack.consumeAttribute(element.getAttributeNode("x4"));
        y4_ = URelaxer.getAttributePropertyAsInt(element, "y4");
        stack.consumeAttribute(element.getAttributeNode("y4"));
        if (Page.isMatch(stack)) {
            setPage(new Page(stack));
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new ScanFrame((ScanFrame)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc = parent.getOwnerDocument();
        Element element = (Element)parent;
        int size;
        URelaxer.setAttributePropertyByInt(element, "x1", this.x1_);
        URelaxer.setAttributePropertyByInt(element, "y1", this.y1_);
        URelaxer.setAttributePropertyByInt(element, "x2", this.x2_);
        URelaxer.setAttributePropertyByInt(element, "y2", this.y2_);
        URelaxer.setAttributePropertyByInt(element, "x3", this.x3_);
        URelaxer.setAttributePropertyByInt(element, "y3", this.y3_);
        URelaxer.setAttributePropertyByInt(element, "x4", this.x4_);
        URelaxer.setAttributePropertyByInt(element, "y4", this.y4_);
        if (this.page_ != null) {
            this.page_.makeElement(element);
        }
    }

    /**
     * Gets the RNSContext property <b>RNSContext</b>.
     *
     * @return RNSContext
     */
    public RNSContext rGetRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>RNSContext</b>.
     *
     * @param rNSContext
     */
    public void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the int property <b>x1</b>.
     *
     * @return int
     */
    public int getX1() {
        return (x1_);
    }

    /**
     * Sets the int property <b>x1</b>.
     *
     * @param x1
     */
    public void setX1(int x1) {
        this.x1_ = x1;
    }

    /**
     * Gets the int property <b>y1</b>.
     *
     * @return int
     */
    public int getY1() {
        return (y1_);
    }

    /**
     * Sets the int property <b>y1</b>.
     *
     * @param y1
     */
    public void setY1(int y1) {
        this.y1_ = y1;
    }

    /**
     * Gets the int property <b>x2</b>.
     *
     * @return int
     */
    public int getX2() {
        return (x2_);
    }

    /**
     * Sets the int property <b>x2</b>.
     *
     * @param x2
     */
    public void setX2(int x2) {
        this.x2_ = x2;
    }

    /**
     * Gets the int property <b>y2</b>.
     *
     * @return int
     */
    public int getY2() {
        return (y2_);
    }

    /**
     * Sets the int property <b>y2</b>.
     *
     * @param y2
     */
    public void setY2(int y2) {
        this.y2_ = y2;
    }

    /**
     * Gets the int property <b>x3</b>.
     *
     * @return int
     */
    public int getX3() {
        return (x3_);
    }

    /**
     * Sets the int property <b>x3</b>.
     *
     * @param x3
     */
    public void setX3(int x3) {
        this.x3_ = x3;
    }

    /**
     * Gets the int property <b>y3</b>.
     *
     * @return int
     */
    public int getY3() {
        return (y3_);
    }

    /**
     * Sets the int property <b>y3</b>.
     *
     * @param y3
     */
    public void setY3(int y3) {
        this.y3_ = y3;
    }

    /**
     * Gets the int property <b>x4</b>.
     *
     * @return int
     */
    public int getX4() {
        return (x4_);
    }

    /**
     * Sets the int property <b>x4</b>.
     *
     * @param x4
     */
    public void setX4(int x4) {
        this.x4_ = x4;
    }

    /**
     * Gets the int property <b>y4</b>.
     *
     * @return int
     */
    public int getY4() {
        return (y4_);
    }

    /**
     * Sets the int property <b>y4</b>.
     *
     * @param y4
     */
    public void setY4(int y4) {
        this.y4_ = y4;
    }

    /**
     * Gets the Page property <b>Page</b>.
     *
     * @return Page
     */
    public Page getPage() {
        return (page_);
    }

    /**
     * Sets the Page property <b>Page</b>.
     *
     * @param page
     */
    public void setPage(Page page) {
        this.page_ = page;
        if (page != null) {
            page.rSetParentRNode(this);
        }
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("");
        if (page_ != null) {
            page_.makeTextElement(buffer);
        }
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        String prefix = rNSContext_.getPrefixByUri("");
        if (page_ != null) {
            page_.makeTextElement(buffer);
        }
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("");
        if (page_ != null) {
            page_.makeTextElement(buffer);
        }
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
        int size;
        buffer.append(" ");
        rNSContext_.makeQName("", "x1", buffer);
        buffer.append("=\"");
        buffer.append(URelaxer.getString(getX1()));
        buffer.append("\"");
        buffer.append(" ");
        rNSContext_.makeQName("", "y1", buffer);
        buffer.append("=\"");
        buffer.append(URelaxer.getString(getY1()));
        buffer.append("\"");
        buffer.append(" ");
        rNSContext_.makeQName("", "x2", buffer);
        buffer.append("=\"");
        buffer.append(URelaxer.getString(getX2()));
        buffer.append("\"");
        buffer.append(" ");
        rNSContext_.makeQName("", "y2", buffer);
        buffer.append("=\"");
        buffer.append(URelaxer.getString(getY2()));
        buffer.append("\"");
        buffer.append(" ");
        rNSContext_.makeQName("", "x3", buffer);
        buffer.append("=\"");
        buffer.append(URelaxer.getString(getX3()));
        buffer.append("\"");
        buffer.append(" ");
        rNSContext_.makeQName("", "y3", buffer);
        buffer.append("=\"");
        buffer.append(URelaxer.getString(getY3()));
        buffer.append("\"");
        buffer.append(" ");
        rNSContext_.makeQName("", "x4", buffer);
        buffer.append("=\"");
        buffer.append(URelaxer.getString(getX4()));
        buffer.append("\"");
        buffer.append(" ");
        rNSContext_.makeQName("", "y4", buffer);
        buffer.append("=\"");
        buffer.append(URelaxer.getString(getY4()));
        buffer.append("\"");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
        int size;
        buffer.write(" ");
        rNSContext_.makeQName("", "x1", buffer);
        buffer.write("=\"");
        buffer.write(URelaxer.getString(getX1()));
        buffer.write("\"");
        buffer.write(" ");
        rNSContext_.makeQName("", "y1", buffer);
        buffer.write("=\"");
        buffer.write(URelaxer.getString(getY1()));
        buffer.write("\"");
        buffer.write(" ");
        rNSContext_.makeQName("", "x2", buffer);
        buffer.write("=\"");
        buffer.write(URelaxer.getString(getX2()));
        buffer.write("\"");
        buffer.write(" ");
        rNSContext_.makeQName("", "y2", buffer);
        buffer.write("=\"");
        buffer.write(URelaxer.getString(getY2()));
        buffer.write("\"");
        buffer.write(" ");
        rNSContext_.makeQName("", "x3", buffer);
        buffer.write("=\"");
        buffer.write(URelaxer.getString(getX3()));
        buffer.write("\"");
        buffer.write(" ");
        rNSContext_.makeQName("", "y3", buffer);
        buffer.write("=\"");
        buffer.write(URelaxer.getString(getY3()));
        buffer.write("\"");
        buffer.write(" ");
        rNSContext_.makeQName("", "x4", buffer);
        buffer.write("=\"");
        buffer.write(URelaxer.getString(getX4()));
        buffer.write("\"");
        buffer.write(" ");
        rNSContext_.makeQName("", "y4", buffer);
        buffer.write("=\"");
        buffer.write(URelaxer.getString(getY4()));
        buffer.write("\"");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
        int size;
        buffer.print(" ");
        rNSContext_.makeQName("", "x1", buffer);
        buffer.print("=\"");
        buffer.print(URelaxer.getString(getX1()));
        buffer.print("\"");
        buffer.print(" ");
        rNSContext_.makeQName("", "y1", buffer);
        buffer.print("=\"");
        buffer.print(URelaxer.getString(getY1()));
        buffer.print("\"");
        buffer.print(" ");
        rNSContext_.makeQName("", "x2", buffer);
        buffer.print("=\"");
        buffer.print(URelaxer.getString(getX2()));
        buffer.print("\"");
        buffer.print(" ");
        rNSContext_.makeQName("", "y2", buffer);
        buffer.print("=\"");
        buffer.print(URelaxer.getString(getY2()));
        buffer.print("\"");
        buffer.print(" ");
        rNSContext_.makeQName("", "x3", buffer);
        buffer.print("=\"");
        buffer.print(URelaxer.getString(getX3()));
        buffer.print("\"");
        buffer.print(" ");
        rNSContext_.makeQName("", "y3", buffer);
        buffer.print("=\"");
        buffer.print(URelaxer.getString(getY3()));
        buffer.print("\"");
        buffer.print(" ");
        rNSContext_.makeQName("", "x4", buffer);
        buffer.print("=\"");
        buffer.print(URelaxer.getString(getX4()));
        buffer.print("\"");
        buffer.print(" ");
        rNSContext_.makeQName("", "y4", buffer);
        buffer.print("=\"");
        buffer.print(URelaxer.getString(getY4()));
        buffer.print("\"");
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getX1AsString() {
        return (URelaxer.getString(getX1()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getY1AsString() {
        return (URelaxer.getString(getY1()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getX2AsString() {
        return (URelaxer.getString(getX2()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getY2AsString() {
        return (URelaxer.getString(getY2()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getX3AsString() {
        return (URelaxer.getString(getX3()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getY3AsString() {
        return (URelaxer.getString(getY3()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getX4AsString() {
        return (URelaxer.getString(getX4()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getY4AsString() {
        return (URelaxer.getString(getY4()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setX1ByString(String string) {
        setX1(Integer.parseInt(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setY1ByString(String string) {
        setY1(Integer.parseInt(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setX2ByString(String string) {
        setX2(Integer.parseInt(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setY2ByString(String string) {
        setY2(Integer.parseInt(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setX3ByString(String string) {
        setX3(Integer.parseInt(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setY3ByString(String string) {
        setY3(Integer.parseInt(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setX4ByString(String string) {
        setX4(Integer.parseInt(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setY4ByString(String string) {
        setY4(Integer.parseInt(string));
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        if (page_ != null) {
            classNodes.add(page_);
        }
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>ScanFrame</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        return (isMatchHungry(stack.makeClone()));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>ScanFrame</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        RStack target = stack;
        boolean $match$ = false;
        Element element = stack.peekElement();
        Element child;
        if (!URelaxer.hasAttributeHungry(target, "x1")) {
            return (false);
        }
        $match$ = true;
        if (!URelaxer.hasAttributeHungry(target, "y1")) {
            return (false);
        }
        $match$ = true;
        if (!URelaxer.hasAttributeHungry(target, "x2")) {
            return (false);
        }
        $match$ = true;
        if (!URelaxer.hasAttributeHungry(target, "y2")) {
            return (false);
        }
        $match$ = true;
        if (!URelaxer.hasAttributeHungry(target, "x3")) {
            return (false);
        }
        $match$ = true;
        if (!URelaxer.hasAttributeHungry(target, "y3")) {
            return (false);
        }
        $match$ = true;
        if (!URelaxer.hasAttributeHungry(target, "x4")) {
            return (false);
        }
        $match$ = true;
        if (!URelaxer.hasAttributeHungry(target, "y4")) {
            return (false);
        }
        $match$ = true;
        if (Page.isMatchHungry(target)) {
        }
        return ($match$);
    }
}
