/*

 XMLUtil.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/08/06

 */
package net.sf.sqs_xml.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

/**
 * @author hiroya
 *
 */
public class XMLUtil {
    public static DocumentBuilder createParser() throws ParserConfigurationException, SAXException{
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setExpandEntityReferences(true);
        factory.setNamespaceAware(true);
        //factory.setValidating(true);
        //factory.setValidating(false);
        //factory.setIgnoringComments(true);
        DocumentBuilder parser = factory.newDocumentBuilder();
        return parser;
    }
    
    public static XMLSerializer getSerializer(OutputStream out) {
        OutputFormat formatter = new OutputFormat();
        formatter.setPreserveSpace(true);
        XMLSerializer serializer = new XMLSerializer(out, formatter);
        return serializer;
    }
    
    public static XMLSerializer getSerializer(Writer writer) {
        OutputFormat formatter = new OutputFormat();
        formatter.setPreserveSpace(true);
        XMLSerializer serializer = new XMLSerializer(writer, formatter);
        return serializer;
    }

    public static InputStream createInputStream(Document doc)throws IOException{
        return createInputStream(doc.getDocumentElement());
    }
    
    public static InputStream createInputStream(Element node)throws IOException{
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(4096);
        XMLSerializer serializer = getSerializer(outputStream);
        serializer.serialize(node);
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    public static String createString(Element node){
        try{
            StringWriter writer = new StringWriter(64);
            XMLSerializer serializer = getSerializer(writer);
            serializer.serialize(node);
            return writer.toString();
        }catch(IOException ignore){
            return null;
        }
    }

    public static void marshal(Document document, OutputStream out) throws ParserConfigurationException {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();            
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
        } catch (TransformerConfigurationException tce) {
            Throwable ex = tce;
            if (tce.getException() != null){
                ex = tce.getException();
            }
            ex.printStackTrace();
        } catch (TransformerException te) {
            Throwable ex = te;
            if (te.getException() != null){
                ex = te.getException();
            }
            ex.printStackTrace();
        }
    }
    
}
