<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2004 SQS Development Team / Community Management Research Project.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.w3.org/1999/XSL/Format" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xhtml2="http://www.w3.org/2002/06/xhtml2" xmlns:xforms="http://www.w3.org/2002/xforms" xmlns:fox="http://xml.apache.org/fop/extensions"  xmlns:sqs="http://sqs.cmr.sfc.keio.ac.jp/2004/sqs" version="1.0">
    <xsl:param name="bookmark-root-label">Bookmark</xsl:param>
    <xsl:param name="bookmark-section-label">Section</xsl:param>
    <xsl:param name="bookmark-question-label">Question</xsl:param>
    <xsl:param name="bookmark-itemset-label">Itemset</xsl:param>
	<xsl:template match="/">
		<xhtml2:html>
			<xhtml2:head>
				<xsl:apply-templates select="xhtml2:html/xhtml2:head/*"/>
				<fox:outline internal-destination="originator">
					<fox:label><xsl:value-of select="$bookmark-root-label"/></fox:label>
					<xsl:apply-templates select="xhtml2:html/xhtml2:body" mode="outline"/>
				</fox:outline>
			</xhtml2:head>
			<xsl:apply-templates select="xhtml2:html/xhtml2:body"/>
		</xhtml2:html>
	</xsl:template>
	<xsl:template match="xhtml2:*" mode="outline">
		<xsl:apply-templates select="xhtml2:*|xforms:*" mode="outline"/>
	</xsl:template>
	<xsl:template match="xhtml2:section" mode="outline">
		<fox:outline internal-destination="{@id}">
			<!-- section -->
			<fox:label>
				<xsl:value-of select="xhtml2:h"/>
			</fox:label>
			<xsl:apply-templates select="xhtml2:*|xforms:*" mode="outline"/>
		</fox:outline>
	</xsl:template>
	
	<xsl:template match="xforms:*" mode="outline">
		<fox:outline internal-destination="{$internal-destination-prefix-question}{@xforms:ref}">
			<fox:label>
				<xsl:value-of select="xforms:label"/>
				<xsl:value-of select="xforms:hint"/>
			</fox:label>
			<xsl:call-template name="outline-xform">
				<xsl:with-param name="dest"><xsl:value-of select="$internal-destination-prefix-question"/><xsl:value-of select="@xforms:ref"/></xsl:with-param>
			</xsl:call-template>
			<xsl:call-template name="outline-xforms-itemset">
				<xsl:with-param name="dest"><xsl:value-of select="$internal-destination-prefix-question"/><xsl:value-of select="@xforms:ref"/></xsl:with-param>
			</xsl:call-template>
		</fox:outline>
	</xsl:template>
	
	<xsl:template name="outline-xform">
		<xsl:param name="dest"/>
			<fox:outline internal-destination="{$dest}">
				<fox:label><xsl:value-of select="$bookmark-question-label"/></fox:label>
				<fox:outline internal-destination="{$dest}">
					<fox:label>type=<xsl:value-of select="local-name()"/>
					</fox:label>
				</fox:outline>
				<fox:outline internal-destination="{$dest}">
					<fox:label>label=<xsl:value-of select="xforms:label"/>
					</fox:label>
				</fox:outline>
				<fox:outline internal-destination="{$dest}">
					<fox:label>hint=<xsl:value-of select="xforms:hint"/>
					</fox:label>
				</fox:outline>
				<fox:outline internal-destination="{$dest}">
					<fox:label>help=<xsl:value-of select="xforms:help"/>
					</fox:label>
				</fox:outline>
				<fox:outline internal-destination="{$dest}">
					<fox:label>alart=<xsl:value-of select="xforms:alart"/>
					</fox:label>
				</fox:outline>
				<xsl:if test="local-name()='textarea' or local-name()='input'">
					<fox:outline internal-destination="{$dest}">
						<fox:label>page=<xsl:value-of select="ancestor-or-self::node()/attribute::xforms:ref"/></fox:label>
					</fox:outline>
					<fox:outline internal-destination="{$dest}">
						<fox:label>dimension=<xsl:value-of select="ancestor-or-self::node()/attribute::xforms:ref"/></fox:label>
					</fox:outline>
				</xsl:if>
				<fox:outline internal-destination="{$internal-destination-prefix-question}{ancestor-or-self::node()/attribute::xforms:ref}">
					<fox:label>ref=<xsl:value-of select="ancestor-or-self::node()/attribute::xforms:ref"/>
					</fox:label>
				</fox:outline>
			</fox:outline>
	</xsl:template>
	<xsl:template name="outline-xforms-itemset">
		<xsl:param name="dest"/>
			<xsl:choose>
				<xsl:when test="xforms:item">
					<fox:outline internal-destination="{$dest}">
						<fox:label><xsl:value-of select="$bookmark-itemset-label"/></fox:label>
						<xsl:for-each select="xforms:item">
							<fox:outline internal-destination="{$internal-destination-prefix-xform}{ancestor-or-self::node()/attribute::xforms:ref}/v{xforms:value}">
								<fox:label>label=<xsl:value-of select="xforms:label"/>
								</fox:label>
								<fox:outline internal-destination="{$internal-destination-prefix-xform}{ancestor-or-self::node()/attribute::xforms:ref}/v{xforms:value}">
									<fox:label>value=<xsl:value-of select="xforms:value"/></fox:label>
								</fox:outline>
								<fox:outline internal-destination="{$internal-destination-prefix-xform}{ancestor-or-self::node()/attribute::xforms:ref}/v{xforms:value}">
									<fox:label>page=<xsl:value-of select="ancestor-or-self::node()/attribute::xforms:ref"/>/v<xsl:value-of select="xforms:value"/></fox:label>
								</fox:outline>
								<fox:outline internal-destination="{$internal-destination-prefix-xform}{ancestor-or-self::node()/attribute::xforms:ref}/v{xforms:value}">
									<fox:label>dimension=<xsl:value-of select="ancestor-or-self::node()/attribute::xforms:ref"/>/v<xsl:value-of select="xforms:value"/></fox:label>
								</fox:outline>
							</fox:outline>
						</xsl:for-each>
					</fox:outline>
				</xsl:when>
			</xsl:choose>
	</xsl:template>
	<xsl:template match="xhtml2:table[@xhtml2:class='matrix-forms']" mode="outline">
		<fox:outline internal-destination="{$internal-destination-prefix-question}{@id}">
			<xsl:variable name="label"><xsl:value-of select="ancestor::xhtml2:table[@xhtml2:class='question']/xhtml2:tbody/xhtml2:tr/xhtml2:td[1]"/></xsl:variable>
			<xsl:variable name="composit-label"><xsl:value-of select="ancestor::xhtml2:table[@xhtml2:class='question']/xhtml2:tbody/xhtml2:tr/xhtml2:td[2]"/></xsl:variable>
			<fox:label>
				<xsl:value-of select="$label"/>
				<xsl:value-of select="ancestor::xhtml2:table[@xhtml2:class='question']/xhtml2:tbody/xhtml2:tr/xhtml2:td[2]"/>
			</fox:label>
			
			<fox:outline internal-destination="{$internal-destination-prefix-question}{@id}">
				<fox:label><xsl:value-of select="$bookmark-question-label"/></fox:label>
				<fox:outline internal-destination="{$internal-destination-prefix-question}{@id}">
				<fox:label>type=matrix-forms</fox:label>
				</fox:outline>
				<fox:outline internal-destination="{$internal-destination-prefix-question}{@id}">
				<fox:label>label=<xsl:value-of select="$label"/></fox:label>
				</fox:outline>
				<fox:outline internal-destination="{$internal-destination-prefix-question}{@id}">
				<fox:label>hint=<xsl:value-of select="substring-before($composit-label,'(')"/></fox:label>
				</fox:outline>
				<fox:outline internal-destination="{$internal-destination-prefix-question}{@id}">
				<fox:label>help=<xsl:value-of select="substring-before(substring-after($composit-label,'('), ')')"/></fox:label>
				</fox:outline>
			</fox:outline>
			
			<xsl:for-each select="ancestor::xhtml2:table[@xhtml2:class='question']/xhtml2:tbody/xhtml2:tr[2]/xhtml2:td[2]/xhtml2:table/xhtml2:tbody/xhtml2:tr">
				<xsl:variable name="dest"><xsl:value-of select="@id"/></xsl:variable>
				<fox:outline internal-destination="{$dest}">
					<fox:label><xsl:value-of select="xhtml2:th[1]"/><xsl:text>:</xsl:text><xsl:value-of select="xhtml2:td[1]"/></fox:label>
					<fox:outline internal-destination="{$dest}">
						<fox:label><xsl:value-of select="$bookmark-question-label"/></fox:label>
						<fox:outline internal-destination="{$dest}">
							<fox:label>type=matrix-forms-row</fox:label>
						</fox:outline>						
						<fox:outline internal-destination="{$dest}">
							<fox:label>label=<xsl:value-of select="xhtml2:th[1]"/></fox:label>
						</fox:outline>						
						<fox:outline internal-destination="{$dest}">
							<fox:label>hint=<xsl:value-of select="xhtml2:td[1]"/></fox:label>
						</fox:outline>
					</fox:outline>
					<xsl:call-template name="outline-matrix-forms-cell">
						<xsl:with-param name="qid"><xsl:value-of select="$label"/></xsl:with-param>
						<xsl:with-param name="rowid"><xsl:number level="any" from="xhtml2:tbody" count="xhtml2:tr"/></xsl:with-param>
						<xsl:with-param name="dest"><xsl:value-of select="$dest"/></xsl:with-param>
					</xsl:call-template>
				</fox:outline>
			</xsl:for-each>

		</fox:outline>

	</xsl:template>
	<xsl:template name="outline-matrix-forms-cell">
		<xsl:param name="qid"/>	
		<xsl:param name="rowid"/>
		<xsl:param name="dest"/>
		<xsl:for-each select="ancestor::xhtml2:table[@xhtml2:class='matrix-forms']/xhtml2:thead/xhtml2:tr[1]/xhtml2:th[1 &lt; position()]">
			<xsl:variable name="form-number"><xsl:value-of select="position()"/></xsl:variable>
			
			<fox:outline internal-destination="{$dest}">
				<fox:label><xsl:value-of select="."/></fox:label>
				<xsl:variable name="column-group-index" select="@sqs:column-group-index"/>
				<xsl:variable name="colid"><xsl:number level="any" from="xhtml2:tr" count="xhtml2:th[1 &lt; position()]"/></xsl:variable>
				<xsl:variable name="ref"><xsl:value-of select="substring-after($dest, 'Question-')"/>/c[<xsl:value-of select="$form-number"/>]</xsl:variable>
				<fox:outline internal-destination="{$dest}">
						<fox:label><xsl:value-of select="$bookmark-question-label"/></fox:label>
			<fox:outline internal-destination="{$dest}">
				<fox:label>type=<xsl:value-of select="@sqs:xforms-type"/></fox:label>
			</fox:outline>
			<fox:outline internal-destination="{$dest}">
				<fox:label>label=<xsl:value-of select="$qid"/><xsl:value-of select="$rowid"/>-<xsl:value-of select="$colid"/></fox:label>
			</fox:outline>
			<fox:outline internal-destination="{$dest}">
				<fox:label>hint=<xsl:value-of select="."/></fox:label>
			</fox:outline>
			<fox:outline internal-destination="{$dest}">
				<fox:label>help=</fox:label>
			</fox:outline>
			<fox:outline internal-destination="{$dest}">
				<fox:label>alart=</fox:label>
			</fox:outline>

			<xsl:if test="@sqs:pxform-type='textarea' or @sqs:xforms-type='input'">
				<fox:outline internal-destination="{$dest}">
					<fox:label>page=<xsl:value-of select="$ref"/></fox:label>
				</fox:outline>
				<fox:outline internal-destination="{$dest}">
					<fox:label>dimension=<xsl:value-of select="$ref"/></fox:label>
				</fox:outline>
			</xsl:if>
						
			<fox:outline internal-destination="{$dest}">
				<fox:label>ref=<xsl:value-of select="$ref"/></fox:label>
			</fox:outline>

				</fox:outline>

			<xsl:if test="@sqs:pxform-type='select' or @sqs:xforms-type='select1'">
				<fox:outline internal-destination="{$dest}">
					<fox:label><xsl:value-of select="$bookmark-itemset-label"/></fox:label>
<xsl:for-each select="ancestor::xhtml2:table[@xhtml2:class='matrix-forms']/xhtml2:thead/xhtml2:tr[2]/xhtml2:th[@sqs:column-group-index = $column-group-index]">
	<fox:outline internal-destination="{$dest}">
		<fox:label>label=<xsl:value-of select="."/></fox:label>
		<fox:outline internal-destination="{$dest}">
			<fox:label>value=<xsl:value-of select="@sqs:value"/></fox:label>
		</fox:outline>
		<fox:outline internal-destination="{$dest}">
			<fox:label>page=<xsl:value-of select="$ref"/>/v<xsl:value-of select="@sqs:value"/></fox:label>
		</fox:outline>
		<fox:outline internal-destination="{$dest}">
			<fox:label>dimension=<xsl:value-of select="$ref"/>/v<xsl:value-of select="@sqs:value"/></fox:label>
		</fox:outline>
	</fox:outline>
</xsl:for-each>
				</fox:outline>

			</xsl:if>
				
			</fox:outline>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
