<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2004 SQS Development Team / Community Management Research Project.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xforms="http://www.w3.org/2002/xforms" xmlns:xhtml2="http://www.w3.org/2002/06/xhtml2" xmlns:sqs="http://sqs.cmr.sfc.keio.ac.jp/2004/sqs" version="1.0">
	<xsl:template name="layout-range">
		<xsl:variable name="ref">
			<xsl:value-of select="@xforms:ref"/>
		</xsl:variable>
		<xsl:variable name="label">
			<xsl:value-of select="@xforms:label"/>
		</xsl:variable>
		<xhtml2:table border="1">
			<xhtml2:tbody>
				<xhtml2:tr>
					<xsl:for-each select="xforms:item">
						<xhtml2:td>
							<xforms:select xforms:ref="{$ref}/v{@xforms:value}" sqs:pxform-type="range">
								<xforms:label>
									<xsl:value-of select="$label"/>
								</xforms:label>
								<xforms:item>
									<xforms:label>
										<xsl:value-of select="@xforms:label"/>
									</xforms:label>
									<xforms:value>
										<xsl:value-of select="@xforms:value"/>
									</xforms:value>
								</xforms:item>
							</xforms:select>
						</xhtml2:td>
					</xsl:for-each>
				</xhtml2:tr>
			</xhtml2:tbody>
		</xhtml2:table>
	</xsl:template>
</xsl:stylesheet>
