<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2004 SQS Development Team / Community Management Research Project.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.w3.org/1999/xhtml" xmlns:xhtml2="http://www.w3.org/2002/06/xhtml2" xmlns:xforms="http://www.w3.org/2002/xforms"
 exclude-result-prefixes="xhtml2 xhtml" version="1.0">
<xsl:param name="form-submit-label">Submit</xsl:param>
	<xsl:template match="xhtml2:*">
		<xsl:element name="{local-name()}">
			<xsl:for-each select="@xhtml2:*|@*">
				<xsl:attribute name="{local-name()}"><xsl:value-of select="."/></xsl:attribute>
			</xsl:for-each>
			<xsl:apply-templates select="child::node()"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="xforms:*">
		<xsl:element name="xforms:{local-name()}">
			<xsl:for-each select="@*">
				<xsl:attribute name="{name()}"><xsl:value-of select="."/></xsl:attribute>
			</xsl:for-each>
			<xsl:apply-templates select="child::node()"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="xhtml2:body//xhtml2:h">
		<h1>
			<xsl:apply-templates/>
		</h1>
	</xsl:template>
	<xsl:template match="xhtml2:body//xhtml2:section/xhtml2:h">
		<h2>
			<xsl:apply-templates/>
		</h2>
	</xsl:template>
	<xsl:template match="xhtml2:body//xhtml2:section//xhtml2:section/xhtml2:h">
		<h3>
			<xsl:apply-templates/>
		</h3>
	</xsl:template>
	<xsl:template match="xhtml2:body//xhtml2:section//xhtml2:section/xhtml2:section/xhtml2:h">
		<h4>
			<xsl:apply-templates/>
		</h4>
	</xsl:template>
	<xsl:template match="xhtml2:section">
		<xsl:apply-templates/>
		<hr/>
	</xsl:template>
	<xsl:template match="xhtml2:head">
		<head>
			<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
			<style type="text/css">
th,td{
 vertical-align: top;
}
div.warning{
border-style: solid;
border-color: black;
border-width: 1px;
}
strong{
  text-decoration: underline;
}
        </style>
			<xsl:apply-templates/>
		</head>
	</xsl:template>
	<xsl:template match="xhtml2:body">
		<body>
			<form action="" method="post">
				<xsl:apply-templates/>
<xsl:if test="0 &lt; string-length($form-submit-label)">
  <input type="submit" value="{$form-submit-label}"/>
</xsl:if>
			</form>
		</body>
	</xsl:template>
</xsl:stylesheet>
