/*
 * 
 
 ImageTranslationFilter.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */
package net.sf.sqs_xml.image;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
public class ImageTranslationFilter extends RasterSource {
	Point2D[] master;
	Point2D[] guide;
	double masterWidth;
	double masterHeight;
	double ox, oy, ax, ay, bx, by, cx, cy, dx,dy;
	public ImageTranslationFilter(
		Raster src,
		Point2D[] master,
		Point2D[] _guide) {
		super(src);
		init(master, _guide);
	}

	public ImageTranslationFilter(
		Point2D[] master,
		Point2D[] _guide) {
		init(master, _guide);
	}

	public ImageTranslationFilter(
		RasterSource source,
		Point2D[] master,
		Point2D[] _guide) {
		super(source);
		init(master, _guide);
	}
	
	private void init(Point2D[] master, Point2D[] _guide) {
		this.master = master;
		this.guide = new Point2D[4];
		for(int i=0; i<4; i++){
		    this.guide[i] = new Point2D.Double(_guide[i].getX(), _guide[i].getY());
		}
		this.masterWidth = master[1].getX() - master[0].getX();
		this.masterHeight = master[2].getY() - master[0].getY();
		this.ox = master[0].getX();
		this.oy = master[0].getY();
		if(guide == null || guide.length < 4 || guide[0] == null || guide[1] == null || guide[2] == null || guide[3] == null){
			return;
		}
		double cx = guide[3].getX()-guide[2].getX();
		double cy = guide[3].getY()-guide[2].getY();
		double s = (master[0].getX()-master[2].getX()) / masterWidth;
		guide[2].setLocation(guide[2].getX()+cx*s, guide[2].getY()+cy*s);
		guide[3].setLocation(guide[3].getX()+cx*s, guide[3].getY()+cy*s);
		this.ax = (guide[1].getX()-guide[0].getX());
		this.ay = (guide[1].getY()-guide[0].getY());
		this.bx = (guide[2].getX()-guide[0].getX());
		this.by = (guide[2].getY()-guide[0].getY());
		this.cx = (guide[3].getX()-guide[2].getX());
		this.cy = (guide[3].getY()-guide[2].getY());
		this.dx = (guide[3].getX()-guide[1].getX());
		this.dy = (guide[3].getY()-guide[1].getY());
	}
	
	public Point2D getPoint(final double x, final double y, double scale, Point2D ret) {
		double s = (x - ox) / masterWidth;
		double t = (y - oy) / masterHeight;
		double aax = (guide[0].getX() + ax*s);
		double aay = (guide[0].getY() + ay*t);
		double bbx = (guide[0].getX() + bx*s);
		double bby = (guide[0].getY() + by*t);
		double acx = (guide[2].getX() + cx*s) - aax;
		double acy = (guide[2].getY() + cy*t) - aay;		
		double bdx = (guide[1].getX() + dx*s) - bbx;
		double bdy = (guide[1].getY() + dy*t) - bby;
		double q = (acx * (bby - aay) - acy * (bbx - aax)) / (acy * bdx - acx * bdy);
		double p = (bbx + bdx * q - aax) / acx;
		if(ret == null){
		    return new Point2D.Double(aax + acx * p, aay + acy * p);
		}else{
		    ret.setLocation(aax + acx * p, aay + acy * p);
		    return ret;
		}
	}

	public Point2D getPoint(final int x, final int y) {
	    return this.getPoint((double)x, (double)y, 1.0, new Point2D.Double());
	}

	public int getRGBColor(Point2D p) {
	    return super.getRGBColor((int)p.getX(), (int)p.getY());
	}
	
	public int getRGBColor(final int x, final int y) {
	    return this.getRGBColor(getPoint(x, y));
	}
	
	public int getRGBColor(final int x, final int y, Point2D p) {
	    return this.getRGBColor(getPoint((double)x, (double)y, 1.0f, p));
	}

	
	public int getRGBColor(final double x, final double y, Point2D p){
	    return this.getRGBColor(getPoint(x, y, 1.0, p));
	}
}
