/*
 * 
 
 NoiceCancelFilter.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */
package net.sf.sqs_xml.image;

import java.awt.image.Raster;

public class NoiseCancelFilter extends RasterSource {

    public final int SIZE;
    public final int WHITE_THRESHOLD;	
	public final int BLACK_THRESHOLD;
 	
	public NoiseCancelFilter(RasterSource src, int size, int white, int black){
		super(src);
		SIZE = size;
		WHITE_THRESHOLD = white;
		BLACK_THRESHOLD = black;
	}
	public NoiseCancelFilter(Raster raster){
		SIZE = 1;
		WHITE_THRESHOLD = 2;
		BLACK_THRESHOLD = 7;
	}
	
	public int getRGBColor(int x, int y) {
		int target = 0;
		int numBlackPixel = 0;
		for (int j = -1 * SIZE; j <= SIZE; j++) {
			for (int i = -1 * SIZE; i <= SIZE; i++) {
				int color = super.getRGBColor(x + i, y + j);
				if(i==0 && j==0){
					target = color;
				}else{
					numBlackPixel += isBlack(color)?1:0;
				}
			}
		}

		if(isBlack(target)){
			if(numBlackPixel <= WHITE_THRESHOLD){
				return RasterSource.WHITE;
			}
		}else{
			if(BLACK_THRESHOLD <= numBlackPixel ){
				return RasterSource.BLACK;
			}
		}
		return target;
		//return isVerticalLine(x, y);
	}
}
