/*

 OpenAction.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/07/26

 */
package net.sf.sqs_xml.receiver.struts;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletException;

import net.sf.sqs_xml.translator.servlet.FileUploadReceiver;
import net.sf.sqs_xml.translator.servlet.UploadedFile;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * 
 *   @struts.action 
 * 		path="/receiver/open"
 * 		name="open"
 * 		scope="request"
 * 		validate="false"
 * 	 @struts.action-forward
 * 		name="_open"
 * 		path="/receiver/forward/_open.jsp"
 * 
 * @author hiroya
  */
 
public class OpenAction extends Action {
    /**
     * パス修飾のあるファイル・パスから、パス修飾を削り、ファイル名だけを返します。
     * 具体的には、パスの最後の/または\よりも後ろの部分だけを返します。
     * 最後の文字が区切り文字だった場合、空文字列が返ります。
     * @param path
     * @return
     */
    private static String getBaseName(String path) {
        int index1 = path.lastIndexOf('\\');
        int index2 = path.lastIndexOf('/');
        int index;
        if (index1 == -1) {
            if (index2 == -1) {
                // 区切り文字が現れなかったので、そのまま返す
                return path;
            } else {
                index = index2;
            }
        } else {
            if (index2 == -1) {
                index = index1;
            } else {
                // 区切り文字が両方あったので、より後ろの方を採用
                index = (index1 > index2) ? index1 : index2;
            }
        }
        return path.substring(index + 1);
    }

    /**
     * リクエスト・パラメータを受け取り処理をします。
     */
    public ActionForward execute(
        ActionMapping mapping,
        ActionForm form,
        HttpServletRequest req,
        HttpServletResponse res)
        throws Exception {
        try {
            UploadedFile uf = FileUploadReceiver.receiveFileUpload(req, res, "sqs");
            req.setAttribute("fileNameBody", uf.getFileNameBody());
            /*
            Html html = new Html(uf.getInputStream());
            req.setAttribute("html", html);
            req.setAttribute("htmlString", html.toString());
            req.setAttribute("htmlDocument", html.makeDocument());
            */
        }catch(ServletException ex){
            ex.printStackTrace();
        }
        return mapping.findForward("_open");
    }
}
