/*

 IconTitledBorder.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/08/09

 */
package net.sf.sqs_xml.swing;

import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;

/**
 * @author hiroya
 *
 */
public class IconTitledBorder extends CompTitledBorder {
    public IconTitledBorder(Icon icon, String title){
        super(createComponent(icon, title));
    }

    public IconTitledBorder(Icon icon, String title, Border border){
        super(border, createComponent(icon, title));
    }
    
    static JComponent createComponent(Icon icon, String title){
        Box comp = Box.createHorizontalBox();
        comp.add(new JLabel(icon));
        comp.add(Box.createHorizontalStrut(4));
        comp.add(new JLabel(title));
        return comp;
    }
    
}
