/*
 * 
 * PDFtoSQMTranslator.java
 * 
 * Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package net.sf.sqs_xml.translator.logic;

import java.io.OutputStream;
import java.io.ByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.TransformerHandler;

import net.sf.sqs_xml.httpd.MarkReaderHttpd;

import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;

import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.SimpleBookmark;

public class PDFtoSQMTranslator extends AbstractTranslator {
	public static final String BOOKMARK2SQM = prop.getString("bookmark2sqm_xsl_file");
	int numberOfPages = -1;
	
	public static void main(String args[]) throws Exception {
		main(args, "jp.sourceforge.sqs_xml.translator.logic.PDFtoSQMTranslator <in.pdf> <out.sqm>", 
		        BOOKMARK2SQM.split(" "), new PDFtoSQMTranslator(), 
				MarkReaderHttpd.getSingleton().getBase());
	}

	public PDFtoSQMTranslator()throws TranslatorException{
		super();
	}
	
	public void translate(InputStream inputStream, TranslatorResource resource, OutputStream outputStream, String baseURI)throws TranslatorException{
		try{
			PdfReader reader = createPdfReader(inputStream);
			ByteArrayOutputStream bookmarkOutputStream = new ByteArrayOutputStream(4096);
			SimpleBookmark.exportToXML(SimpleBookmark.getBookmark(reader), bookmarkOutputStream, "UTF-8", false);
			this.numberOfPages = reader.getNumberOfPages();
		//	resource.getLogger().info(bookmarkOutputStream.toString());
			ByteArrayInputStream bookmarkInputStream = new ByteArrayInputStream(bookmarkOutputStream.toByteArray());
			super.translate(bookmarkInputStream, resource, outputStream, baseURI);
		}catch(IOException ex){
		}
	}
	
	public void execute(InputStream inputStream, TranslatorResource resource,
            OutputStream outputStream, TransformerHandler starterHandler,
            TransformerHandler terminatorHandler) throws TranslatorException {
        try {
            Serializer serializer = SerializerFactory
                    .getSerializer(OutputPropertiesFactory
                            .getDefaultMethodProperties("xml"));
            serializer.setOutputStream(outputStream);
            terminatorHandler.setResult(new SAXResult(serializer
                    .asContentHandler()));
        } catch (IOException ex) {
            throw new TranslatorException(ex);
        }
    }
	
	public String[] getParameters(String filename){
		return new String[]{"pages", new Integer(numberOfPages).toString()};
	}

	private PdfReader createPdfReader(InputStream pdfInputStream) throws IOException {
		ByteArrayOutputStream pdfOutputStream = new ByteArrayOutputStream();
		byte[] buf = new byte[4096];
		int len = 0;
		while(0 < (len = pdfInputStream.read(buf))){
			pdfOutputStream.write(buf, 0, len);
		}
		PdfReader reader = new PdfReader(pdfOutputStream.toByteArray());
		return reader;
	}
}