/*
 * 
   TranslatorResource.java

   Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */
package net.sf.sqs_xml.translator.logic;

import org.apache.avalon.framework.logger.Logger;
import java.util.List;
import java.util.ArrayList;
import java.util.Arrays;

public class TranslatorResource{

	Logger logger;
	List xsltFilenames;
	
	public TranslatorResource(Logger logger, String xslFilename){
		this.logger = logger;
		this.xsltFilenames = new ArrayList();
		xsltFilenames.add(xslFilename);
	}
	public TranslatorResource(Logger logger, ArrayList xslFilenames){
		this.logger = logger;
		this.xsltFilenames = xslFilenames;
	}
	public TranslatorResource(Logger logger, String[] xslFilenames){
		this.logger = logger;
		this.xsltFilenames = Arrays.asList(xslFilenames);
	}
	public TranslatorResource(Logger logger){
		this.logger = logger;
	}
	public Logger getLogger(){
		return logger;
	}
	
	/**
	 * @return Returns the xsltFilenames.
	 */
	public List getXsltFilename() {
		return xsltFilenames;
	}
	public void setXsltFilenames(List list) {
		this.xsltFilenames = list;
	}
	public void setXsltFilenames(String[] xsltFilenames) {
		this.xsltFilenames = Arrays.asList(xsltFilenames);
	}
}
	
