/*
 * 
   FileUtil.java

   Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */
package net.sf.sqs_xml.util;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.FileOutputStream;
import java.io.FileInputStream;
import java.io.BufferedOutputStream;
import java.io.PrintWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

import java.io.BufferedInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;

public class FileUtil {
    public static URL toURL(File tgtFile) throws UnsupportedEncodingException, MalformedURLException,IOException {
        return new URL(toURLString(tgtFile));
    }
    public static String toURLString(File tgtFile)throws UnsupportedEncodingException,IOException{
        return toURLString(tgtFile.getAbsolutePath());
    }
    public static String toURLString(String tgtFilePath)throws UnsupportedEncodingException,IOException{
        String path[] = tgtFilePath.split(File.separator);
        StringBuffer f = new StringBuffer();
        for(int i=0; i<path.length; i++){
            if(0 == i){
                if(File.pathSeparatorChar == '\\' && path[0].indexOf(":") < 0){
                    f.append("/"); 
                }
                // Windows:Local Drive or Windows:Network Drive or UNIX
                f.append(path[i]);
            }else{
                f.append("/");
                f.append(StringUtil.replaceAll(URLEncoder.encode(path[i], "MS932"), "+", "%20"));
                //f.append(StringUtil.replaceAll(URLEncoder.encode(path[i], "UTF-8"), "+", "%20"));
            }
        }
        return "file:///"+f.toString();
        /*
        ByteArrayOutputStream out = new ByteArrayOutputStream(); 
        OutputStreamWriter w = new OutputStreamWriter(out, "MS932");
        w.write(tgtFilePath);
        w.close();
        System.err.println(out.size());
        System.err.println("["+new String(out.toByteArray())+"]");
        return "file:///"+new String(out.toByteArray(), "MS932");
        */ 
    }

    public static void createDirectory(String absolutePath){
		StringBuffer path = new StringBuffer();
		String[] dirs = absolutePath.split("/");
		for(int i=0; i < dirs.length; i++){
			if(0 < i){
				path.append(File.separator);
			}
			path.append(dirs[i]);
			File dir = new File(path.toString());
			if(! dir.isDirectory()){
				dir.mkdir();
			}
		}
	}
	
	public static void clearDirectory(String absolutePath){
	    File[] list = new File(absolutePath).listFiles();
	    for(int i=0; i < list.length; i++){
	        File file = list[i];
	        list[i].delete();
	    }
	}
/*
	public static boolean removerDirectoryIfEmpty(String dirname){
	    File dir = new File(dirname);
	    File[] list = dir.listFiles();
	    if(list.length == 0){
	        dir.delete();
	        return true;	        
	    }
	    return false;
	}
	*/
	public static List find(String absolutePath, final String suffix){
	    return find(new File(absolutePath), suffix);
	}
	
	public static List find(File absolutePath, final String suffix){
		return find(absolutePath, new FileFilter(){
				public boolean accept(File file){
				    return file.getName().toLowerCase().endsWith(suffix);
				}
    		});
	}

	public static List find(File path, FileFilter filter){
		List sourceFileList = new java.util.LinkedList();
		return addFoundFileToList(sourceFileList, path, filter);
	}

   private static List addFoundFileToList(List sourceFileList, File current, FileFilter filter){
		File[] members = null;

		members = current.listFiles(filter);
		if(members == null){
		    return new LinkedList();
		}
		Arrays.sort(members);
		for(int i=0; i<members.length; i++){
			File file = members[i];
			sourceFileList.add(file);
		}
		
		members = current.listFiles();
		Arrays.sort(members);
		for(int i=0; i<members.length; i++){
			File file = members[i];
		    if(file.isDirectory()){
		        addFoundFileToList(sourceFileList, file, filter);	
		    }
		}
		return sourceFileList;
	}
	
	
	public static void keywordSubstitution(File file, String from, String to) {
		String encoding = "UTF-8";
		keywordSubstitution(file, from, to, encoding);
	}
	
	public static boolean keywordSubstitution(File file, String from, String to, String encoding) {
		try{
			File tmpfile = File.createTempFile("tmp", "txt'");
			boolean modified = keywordSubstitution(new FileInputStream(file),
					new FileOutputStream(tmpfile), from, to, encoding);
			if(modified){
				file.delete();
			//	System.err.println(tmpfile.renameTo(file));
				copy(tmpfile, file, encoding);
			}else{
				tmpfile.delete();
			}
			return modified;
		}catch(IOException e){
			e.printStackTrace();
			new RuntimeException(e);
		}
		return false;
	}
	
	public static boolean keywordSubstitution(InputStream inputStream, OutputStream outputStream, String from, String to, String encoding) {
		boolean modified = false; 
		try{
			PrintWriter writer = new PrintWriter(new OutputStreamWriter(new BufferedOutputStream(outputStream), encoding));
			LineNumberReader reader = 
				new LineNumberReader
				(new InputStreamReader(new BufferedInputStream(inputStream), encoding));
			String line = null;
			while((line = reader.readLine()) != null){
				String result = StringUtil.replaceAll(line, from, to);
				writer.println(result);
				if(! result.equals(line)){
					modified |= true; 
				}
			}
			reader.close();
			writer.close();
		}catch(IOException e){
			e.printStackTrace();
			new RuntimeException(e);
		}
		return modified;
	}
	
	public static boolean copy(File from, File to, String encoding) {
		try{
			LineNumberReader reader = new LineNumberReader
			(new InputStreamReader(new BufferedInputStream(new FileInputStream(from)), encoding));
			PrintWriter writer = new PrintWriter(new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(to)), encoding));
			String line = null;
			while((line = reader.readLine()) != null){
				writer.println(line);
			}
			reader.close();
			writer.close();
			return true;
		}catch(IOException ex){
			ex.printStackTrace();
			return false;
		}
	}

    public static String getSuffix(File filename){
        return getSuffix(filename.getName());
    }

    public static String getSuffix(String filename){
        return filename.substring(filename.lastIndexOf('.')+1);
    }

    public static String getBasename(File file){
        return getBasename(file.getAbsolutePath());
    }

    public static String getBasename(String filename){
        if(filename == null || filename.lastIndexOf('.') == -1){
            return null;
        }
        return filename.substring(0, filename.lastIndexOf('.'));
    }

    public static String getSuffixReplacedFilePath(File file, String suffix){
        String basename = getBasename(file);
        if(basename != null){
            return basename+suffix;
        }else{
            return null;
        }
    }

    public static void writeImageFile(File imageFile, BufferedImage bufferedImage) throws FileNotFoundException, IOException {
        OutputStream out = new BufferedOutputStream(new FileOutputStream(imageFile));
        ImageIO.write(bufferedImage, "png", out);
        out.close();
    }
    
    public static PrintWriter createPrintWriter(OutputStream stream, String encoding)throws IOException{
        return new PrintWriter(new OutputStreamWriter(new BufferedOutputStream(stream), encoding));
    }

    public static PrintWriter createPrintWriter(File file, String encoding)throws IOException{
        return createPrintWriter(new FileOutputStream(file), encoding);
    }
    
    public static Reader createReader(InputStream input, String encoding)throws IOException{
        return new InputStreamReader(new BufferedInputStream(input), encoding);
    }
}
