/*

 NodeAwareSchemaBuilder.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/10/12

 */
package org.kohsuke.rngom.binary;

import java.util.HashMap;
import java.util.Map;

import org.kohsuke.rngom.ast.builder.NodeAwareSchemaBuilder;
import org.kohsuke.rngom.ast.om.Location;
import org.kohsuke.rngom.ast.om.ParsedPattern;
import org.kohsuke.rngom.ast.util.LocatorImpl;
import org.kohsuke.rngom.ast.util.NodeLocatorImpl;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;

/**
 * @author hiroya
 *
 */
public class NodeAwareSchemaBuilderImpl extends SchemaBuilderImpl implements NodeAwareSchemaBuilder{
    
    Map nodeMap = null;
    
    /**
     * @param eh
     */
    public NodeAwareSchemaBuilderImpl(ErrorHandler eh) {
        super(eh);
        // TODO Auto-generated constructor stub
    }

    /**
     * @param eh
     * @param datatypeLibraryFactory
     * @param pb
     */
    public NodeAwareSchemaBuilderImpl(ErrorHandler eh,
            DatatypeLibraryFactory datatypeLibraryFactory,
            SchemaPatternBuilder pb) {
        super(eh, datatypeLibraryFactory, pb);
        nodeMap = new HashMap();
        // TODO Auto-generated constructor stub
    }

    
    /* (non-Javadoc)
     * @see org.kohsuke.rngom.ast.builder.NodeAwareSchemaBuilder#getSchemaDocumentNode(org.kohsuke.rngom.ast.om.ParsedPattern)
     */
    public Node getSchemaDocumentNode(ParsedPattern pattern) {
        return (Node)nodeMap.get(pattern);
    }
    
    public Location makeLocation(String systemId, int lineNumber, int columnNumber) {
        return new NodeLocatorImpl(new LocatorImpl(systemId, lineNumber, columnNumber), null);//TODO
      }

}
