/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.io;

public final class CsvFormatter {
    public static final CsvFormatter RAW = new CsvFormatter(FormatType.RAW);
    public static final CsvFormatter STRING = new CsvFormatter(FormatType.STRING);
    public static final CsvFormatter ESCAPE = new CsvFormatter(FormatType.ESCAPE);
    public static final CsvFormatter AUTO = new CsvFormatter(FormatType.AUTO);
    private final FormatType type;

    private CsvFormatter(FormatType formatType) {
        this.type = formatType;
    }

    public String format(String string) {
        switch (this.type) {
            case STRING: {
                return this.editAsStringValue(string);
            }
            case ESCAPE: {
                return this.editAsEscapeValue(string);
            }
            case AUTO: {
                return this.editAuto(string);
            }
        }
        return string;
    }

    private String editAuto(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (string.indexOf(34) >= 0) {
            return this.editAsEscapeValue(string);
        }
        if (string.indexOf(13) >= 0 || string.indexOf(10) >= 0) {
            return this.editAsEscapeValue(string);
        }
        String string2 = string.trim();
        if (string2.length() > 0) {
            if (string2.indexOf(44) >= 0) {
                return this.editAsEscapeValue(string);
            }
            char c = string2.charAt(0);
            if (c == '0' && string2.length() >= 2) {
                try {
                    Double.parseDouble(string);
                    return this.editAsStringValue(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (string2.indexOf(46) >= 0 && string2.charAt(string2.length() - 1) == '0') {
                try {
                    Double.parseDouble(string);
                    return this.editAsStringValue(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ('0' <= c && c <= '9') {
                try {
                    if (Long.parseLong(string2) > Integer.MAX_VALUE) {
                        return this.editAsStringValue(string);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    return this.editAsStringValue(string);
                }
            }
        }
        return string;
    }

    private String editAsStringValue(String string) {
        return String.format("=\"%s\"", CsvFormatter.escapeQuote(string));
    }

    private String editAsEscapeValue(String string) {
        return String.format("\"%s\"", CsvFormatter.escapeQuote(string));
    }

    private static String escapeQuote(String string) {
        return string.replaceAll("\"", "\"\"");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FormatType {
        STRING,
        ESCAPE,
        AUTO,
        RAW;


        static FormatType of(String string) {
            try {
                return FormatType.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return RAW;
            }
        }
    }
}

