/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew;

import static java.util.ResourceBundle.getBundle;

import java.io.*;
import java.sql.*;
import java.util.*;

import net.argius.stew.io.*;
import net.argius.stew.ui.*;

/**
 * R}h̊B
 */
public abstract class Command {

    protected Environment env;
    protected OutputProcessor op;

    private final ResourceBundle resourceBundle;

    /**
     * RXgN^B
     */
    protected Command() {
        ResourceBundle resourceBundle;
        try {
            resourceBundle = getBundle(getClass().getPackage().getName() + ".messages");
        } catch (Exception ex) {
            resourceBundle = null;
        }
        this.resourceBundle = resourceBundle;
    }

    /**
     * B
     * @throws CommandException
     */
    public void initialize() throws CommandException {
        // empty
    }

    /**
     * R}hsB
     * @param conn RlNV
     * @param parameter p[^
     * @throws CommandException
     */
    public abstract void execute(Connection conn, Parameter parameter) throws CommandException;

    /**
     * R}hB
     * š㏈ȂǂsB
     * @throws CommandException
     */
    public void close() throws CommandException {
        // empty
    }

    /**
     * R}hNB
     * @param env s
     * @param parameterString p[^
     * @return 𑱍sꍇ <code>true</code>Afꍇ <code>false</code> 
     * @throws CommandException
     */
    public static boolean invoke(Environment env, String parameterString) throws CommandException {
        CommandProcessor processor = new CommandProcessor(env);
        return processor.invoke(parameterString);
    }

    /**
     * R}hǎpǂ𔻒肷B
     * ǎp̃R}h́Ã\bhI[o[ChB
     * @return 茋
     */
    public boolean isReadOnly() {
        return false;
    }

    /**
     * ^CAEg̐ݒB
     * ݒl<code>0</code>ȏ̏ꍇ̂ݐݒ肳B
     * @param stmt Statement
     * @throws SQLException
     * @see Statement#setQueryTimeout(int)
     */
    protected void setTimeout(Statement stmt) throws SQLException {
        final int timeoutSeconds = env.getTimeoutSeconds();
        if (timeoutSeconds >= 0) {
            stmt.setQueryTimeout(timeoutSeconds);
        }
    }

    /**
     * Environment̐ݒB
     * @param env Environment
     */
    public final void setEnvironment(Environment env) {
        this.env = env;
        this.op = env.getOutputProcessor();
    }

    /**
     * pXB
     * ΃pX̏ꍇAJgfBNg̑΃pXƂB
     * @param path
     * @return ꂽpX
     */
    protected final File resolvePath(String path) {
        return Path.resolve(env.getCurrentDirectory(), path);
    }

    /**
     * pXB
     * ΃pX̏ꍇAJgfBNg̑΃pXƂB
     * @param file
     * @return ꂽpX
     */
    protected final File resolvePath(File file) {
        return Path.resolve(env.getCurrentDirectory(), file);
    }

    /**
     * Cӂ̃IuWFNgo͂B
     * @param object IuWFNg
     * @throws CommandException
     */
    protected final void output(Object object) throws CommandException {
        op.output(object);
    }

    /**
     * bZ[Wo͂B
     * @param key bZ[WL[
     * @param args MessageFormatɓn
     * @throws CommandException
     */
    protected final void outputMessage(String key, Object... args) throws CommandException {
        output(getMessage(key, args));
    }

    /**
     * bZ[W擾B
     * @param key bZ[WL[
     * @param args MessageFormatɓn
     * @return bZ[W
     */
    protected final String getMessage(String key, Object... args) {
        return LocalSystem.getBundleMessage(resourceBundle, key, args);
    }

    /**
     * p^[̕ϊsB
     * f[^x[XɈˑ鎯ʎq̈lϊȂǂsB
     * @param pattern p^[
     * @return ϊꂽ
     * @throws SQLException
     */
    protected final String convertPattern(String pattern) throws SQLException {
        String edited;
        DatabaseMetaData dbmeta = env.getCurrentConnection().getMetaData();
        if (dbmeta.storesLowerCaseIdentifiers()) {
            edited = pattern.toLowerCase();
        } else if (dbmeta.storesUpperCaseIdentifiers()) {
            edited = pattern.toUpperCase();
        } else {
            edited = pattern;
        }
        return edited.replace('*', '%').replace('?', '_');
    }

    /**
     * USAGE擾B
     * @return USAGE
     */
    protected String getUsage() {
        final String name = getClass().getName().replaceFirst(".*\\.([^\\.]+)", "$1");
        return getMessage("usage." + name);
    }

    /**
     * SQLSELECTǂ𔻒肷B
     * @param sql SQL
     * @return 茋
     */
    protected static boolean isSelect(String sql) {
        Scanner scanner = new Scanner(sql);
        while (scanner.hasNextLine()) {
            final String line = scanner.nextLine();
            final String s = line.replaceAll("/\\*.*?\\*/", "").replaceFirst("--.*$", "");
            if (!s.matches("\\s*") && s.matches("(?i)\\s*SELECT.*")) {
                return true;
            }
        }
        return false;
    }

    /**
     * StatementB
     * @param conn Connection
     * @param sql SQL
     * @return Statement
     * @throws SQLException
     */
    protected final Statement prepareStatement(Connection conn, String sql) throws SQLException {
        final int index = sql.indexOf(';');
        Statement stmt = (index >= 0)
                ? conn.prepareStatement(sql.substring(0, index))
                : conn.createStatement();
        try {
            if (stmt instanceof PreparedStatement) {
                PreparedStatement pstmt = (PreparedStatement)stmt;
                int i = 0;
                for (String p : sql.substring(index + 1).split(",", -1)) {
                    pstmt.setString(++i, p);
                }
            }
            setTimeout(stmt);
        } catch (Throwable th) {
            try {
                if (th instanceof SQLException) {
                    throw (SQLException)th;
                }
                throw new IllegalStateException(th);
            } finally {
                stmt.close();
            }
        }
        return stmt;
    }

    /**
     * NGsB
     * @param stmt Statement܂PreparedStatement
     * @param sql SQL
     * @return ResultSet
     * @throws SQLException
     */
    protected final ResultSet executeQuery(Statement stmt, String sql) throws SQLException {
        return (stmt instanceof PreparedStatement)
                ? ((PreparedStatement)stmt).executeQuery()
                : stmt.executeQuery(sql);
    }

    /**
     * XVsB
     * @param stmt Statement܂PreparedStatement
     * @param sql SQL
     * @return XVꂽ
     * @throws SQLException
     */
    protected final int executeUpdate(Statement stmt, String sql) throws SQLException {
        return (stmt instanceof PreparedStatement)
                ? ((PreparedStatement)stmt).executeUpdate()
                : stmt.executeUpdate(sql);
    }

}
