/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew.ui.window;

import static java.awt.GridBagConstraints.*;

import java.awt.*;

import javax.swing.*;

/**
 * KɔzułplB
 */
public class FlexiblePanel extends JPanel {

    protected final GridBagLayout g;
    protected final GridBagConstraints c;

    /**
     * RXgN^B
     */
    public FlexiblePanel() {
        this.g = new GridBagLayout();
        this.c = new GridBagConstraints();
        setLayout(g);
        c.gridwidth = 8;
        c.fill = NONE;
        c.ipadx = 2;
        c.ipady = 0;
        c.insets = new Insets(2, 4, 2, 4);
        c.anchor = WEST;
        c.weightx = 1.0;
        c.weighty = 1.0;
    }

    /**
     * R|[lg̔zuB
     * @param component R|[lg
     * @param isRowEnd s̏IȂ <code>true</code> w
     */
    public void addComponent(Component component, boolean isRowEnd) {
        if (isRowEnd) {
            c.gridwidth = REMAINDER;
        }
        g.setConstraints(component, c);
        add(component);
        if (isRowEnd) {
            c.gridwidth = LINE_START;
        }
    }

}
