/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ResourceBundle;
import java.util.Scanner;
import net.argius.stew.CommandException;
import net.argius.stew.CommandProcessor;
import net.argius.stew.Environment;
import net.argius.stew.LocalSystem;
import net.argius.stew.Parameter;
import net.argius.stew.io.Path;
import net.argius.stew.ui.OutputProcessor;

public abstract class Command {
    protected Environment env;
    protected OutputProcessor op;
    private final ResourceBundle resourceBundle;

    protected Command() {
        ResourceBundle resourceBundle;
        try {
            resourceBundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".messages");
        }
        catch (Exception exception) {
            resourceBundle = null;
        }
        this.resourceBundle = resourceBundle;
    }

    public void initialize() throws CommandException {
    }

    public abstract void execute(Connection var1, Parameter var2) throws CommandException;

    public void close() throws CommandException {
    }

    public static boolean invoke(Environment environment, String string) throws CommandException {
        CommandProcessor commandProcessor = new CommandProcessor(environment);
        return commandProcessor.invoke(string);
    }

    public boolean isReadOnly() {
        return false;
    }

    protected void setTimeout(Statement statement) throws SQLException {
        int n = this.env.getTimeoutSeconds();
        if (n >= 0) {
            statement.setQueryTimeout(n);
        }
    }

    public final void setEnvironment(Environment environment) {
        this.env = environment;
        this.op = environment.getOutputProcessor();
    }

    protected final File resolvePath(String string) {
        return Path.resolve(this.env.getCurrentDirectory(), string);
    }

    protected final File resolvePath(File file) {
        return Path.resolve(this.env.getCurrentDirectory(), file);
    }

    protected final void output(Object object) throws CommandException {
        this.op.output(object);
    }

    protected final void outputMessage(String string, Object ... objectArray) throws CommandException {
        this.output(this.getMessage(string, objectArray));
    }

    protected final String getMessage(String string, Object ... objectArray) {
        return LocalSystem.getBundleMessage(this.resourceBundle, string, objectArray);
    }

    protected final String convertPattern(String string) throws SQLException {
        DatabaseMetaData databaseMetaData = this.env.getCurrentConnection().getMetaData();
        String string2 = databaseMetaData.storesLowerCaseIdentifiers() ? string.toLowerCase() : (databaseMetaData.storesUpperCaseIdentifiers() ? string.toUpperCase() : string);
        return string2.replace('*', '%').replace('?', '_');
    }

    protected String getUsage() {
        String string = this.getClass().getName().replaceFirst(".*\\.([^\\.]+)", "$1");
        return this.getMessage("usage." + string, new Object[0]);
    }

    protected static boolean isSelect(String string) {
        Scanner scanner = new Scanner(string);
        while (scanner.hasNextLine()) {
            String string2 = scanner.nextLine();
            String string3 = string2.replaceAll("/\\*.*?\\*/", "");
            if (string3.matches("\\s*") || string3.matches("\\s*--.*")) continue;
            if (string3.matches("\\s*") || !string3.matches("(?i)\\s*SELECT.*")) break;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String readFileAsString(File file) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            fileInputStream.getChannel().transferTo(0L, file.length(), Channels.newChannel(byteArrayOutputStream));
        }
        finally {
            fileInputStream.close();
        }
        return byteArrayOutputStream.toString();
    }

    protected final Statement prepareStatement(Connection connection, String string) throws SQLException {
        int n = string.indexOf(59);
        Statement statement = n >= 0 ? connection.prepareStatement(string.substring(0, n)) : connection.createStatement();
        try {
            if (statement instanceof PreparedStatement) {
                PreparedStatement preparedStatement = (PreparedStatement)statement;
                int n2 = 0;
                for (String string2 : string.substring(n + 1).split(",", -1)) {
                    preparedStatement.setString(++n2, string2);
                }
            }
            this.setTimeout(statement);
            int n3 = LocalSystem.getPropertyAsInt("net.argius.stew.rowcount.limit", Integer.MAX_VALUE);
            if (n3 > 0 && n3 != Integer.MAX_VALUE) {
                statement.setMaxRows(n3 + 1);
            }
        }
        catch (Throwable throwable) {
            try {
                if (throwable instanceof SQLException) {
                    throw (SQLException)throwable;
                }
                throw new IllegalStateException(throwable);
            }
            catch (Throwable throwable2) {
                statement.close();
                throw throwable2;
            }
        }
        return statement;
    }

    protected final ResultSet executeQuery(Statement statement, String string) throws SQLException {
        return statement instanceof PreparedStatement ? ((PreparedStatement)statement).executeQuery() : statement.executeQuery(string);
    }

    protected final int executeUpdate(Statement statement, String string) throws SQLException {
        return statement instanceof PreparedStatement ? ((PreparedStatement)statement).executeUpdate() : statement.executeUpdate(string);
    }
}

