/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew;

import java.io.ByteArrayOutputStream;
import javax.crypto.Cipher;
import net.argius.stew.Logger;
import net.argius.stew.Password;

public abstract class CipherPassword
implements Password {
    private static final Logger log = Logger.getLogger(CipherPassword.class);
    private static String secretKey = "";
    private String transformedString;

    @Override
    public final String getTransformedString() {
        if (this.transformedString != null) {
            return this.transformedString;
        }
        return "";
    }

    @Override
    public final void setTransformedString(String string) {
        if (string != null) {
            this.transformedString = string;
        }
    }

    @Override
    public final String getRawString() {
        if (this.transformedString != null) {
            return this.decrypt(this.transformedString);
        }
        return "";
    }

    @Override
    public final void setRawString(String string) {
        if (string != null) {
            this.transformedString = this.encrypt(string);
        }
    }

    @Override
    public final boolean hasPassword() {
        return this.transformedString != null;
    }

    public static void setSecretKey(String string) {
        assert (string != null && string.length() > 0);
        secretKey = string;
    }

    private String encrypt(String string) {
        try {
            Cipher cipher = this.getCipherInstance(secretKey, 1);
            byte[] byArray = cipher.doFinal(string.getBytes());
            return CipherPassword.toHexString(byArray);
        }
        catch (Exception exception) {
            log.warn(exception);
            return "";
        }
    }

    private String decrypt(String string) {
        try {
            Cipher cipher = this.getCipherInstance(secretKey, 2);
            byte[] byArray = cipher.doFinal(CipherPassword.toBytes(string));
            return new String(byArray);
        }
        catch (Exception exception) {
            log.warn(exception);
            return "";
        }
    }

    private static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (byte by : byArray) {
            stringBuffer.append(String.format("%02X", by & 0xFF));
        }
        return stringBuffer.toString();
    }

    private static byte[] toBytes(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < string.length(); i += 2) {
            String string2 = string.substring(i, i + 2);
            byteArrayOutputStream.write(Integer.parseInt(string2, 16));
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected abstract Cipher getCipherInstance(String var1, int var2);
}

