/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.command;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import net.argius.stew.ColumnOrder;
import net.argius.stew.Command;
import net.argius.stew.CommandException;
import net.argius.stew.Logger;
import net.argius.stew.Parameter;
import net.argius.stew.ResultSetReference;
import net.argius.stew.UsageException;
import net.argius.stew.command.Find;
import net.argius.stew.command.Report;
import net.argius.stew.io.Exporter;

public final class Export
extends Command {
    private static final Logger log = Logger.getLogger(Export.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Connection connection, Parameter parameter) throws CommandException {
        if (!parameter.has(2)) {
            throw new UsageException(this.getUsage());
        }
        String string = parameter.at(1);
        int n = 2;
        boolean bl = parameter.at(n).equalsIgnoreCase("HEADER");
        if (bl) {
            ++n;
        }
        String string2 = parameter.after(n);
        if (log.isDebugEnabled()) {
            log.debug(String.format("file: [%s]", string));
            log.debug("withHeader: " + bl);
            log.debug(String.format("command: [%s]", string2));
        }
        try {
            ResultSetReference resultSetReference;
            File file = this.resolvePath(string);
            if (file.exists()) {
                throw new CommandException(Export.getMessage("e.file-already-exists", file));
            }
            Parameter parameter2 = new Parameter(string2);
            String string3 = parameter2.at(0);
            if (string3.equalsIgnoreCase("SELECT")) {
                Statement statement = this.prepareStatement(connection, string2);
                try {
                    resultSetReference = new ResultSetReference(this.executeQuery(statement, string2), "");
                    Export.export(file, resultSetReference, bl);
                }
                finally {
                    statement.close();
                }
            }
            if (string3.equalsIgnoreCase("FIND")) {
                Find find = new Find();
                try {
                    find.setEnvironment(this.env);
                    resultSetReference = find.getResult(connection, parameter2);
                }
                catch (UsageException usageException) {
                    throw new UsageException(Export.getMessage("Export.command.usage", Export.getMessage("usage.Export", new Object[0]), string2, usageException.getMessage()));
                }
                finally {
                    find.close();
                }
                try {
                    Export.export(file, resultSetReference, bl);
                }
                finally {
                    resultSetReference.getResultSet().close();
                }
            }
            if (string3.equalsIgnoreCase("REPORT") && !parameter2.at(1).equals("-")) {
                Report report = new Report();
                try {
                    report.setEnvironment(this.env);
                    resultSetReference = report.getResult(connection, parameter2);
                }
                catch (UsageException usageException) {
                    throw new UsageException(Export.getMessage("Export.command.usage", Export.getMessage("usage.Export", new Object[0]), string2, usageException.getMessage()));
                }
                finally {
                    report.close();
                }
                try {
                    Export.export(file, resultSetReference, bl);
                }
                finally {
                    resultSetReference.getResultSet().close();
                }
            }
            throw new UsageException(this.getUsage());
            this.outputMessage("i.selected", resultSetReference.getRecordCount());
            this.outputMessage("i.exported", new Object[0]);
        }
        catch (IOException iOException) {
            throw new CommandException(iOException);
        }
        catch (SQLException sQLException) {
            throw new CommandException(sQLException);
        }
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void export(File file, ResultSetReference resultSetReference, boolean bl) throws IOException, SQLException {
        Exporter exporter = Exporter.getExporter(file);
        try {
            int n;
            int n2;
            ResultSet resultSet = resultSetReference.getResultSet();
            ColumnOrder columnOrder = resultSetReference.getOrder();
            boolean bl2 = columnOrder.size() > 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (bl2) {
                n2 = columnOrder.size();
                for (n = 0; n < n2; ++n) {
                    arrayList.add(columnOrder.getName(n));
                }
            } else {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                n2 = resultSetMetaData.getColumnCount();
                for (int i = 0; i < n2; ++i) {
                    arrayList.add(resultSetMetaData.getColumnName(i + 1));
                }
            }
            if (bl) {
                exporter.addHeader(arrayList.toArray());
            }
            n = 0;
            while (resultSet.next()) {
                ++n;
                Object[] objectArray = new Object[n2];
                for (int i = 0; i < n2; ++i) {
                    int n3 = bl2 ? columnOrder.getOrder(i) : i + 1;
                    objectArray[i] = resultSet.getObject(n3);
                }
                exporter.addRow(objectArray);
            }
            resultSetReference.setRecordCount(n);
        }
        finally {
            exporter.close();
        }
    }
}

