/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.command;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.argius.stew.ColumnOrder;
import net.argius.stew.Command;
import net.argius.stew.CommandException;
import net.argius.stew.Logger;
import net.argius.stew.Parameter;
import net.argius.stew.ResultSetReference;
import net.argius.stew.UsageException;

public final class Report
extends Command {
    private static final Logger log = Logger.getLogger(Report.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Connection connection, Parameter parameter) throws CommandException {
        block7: {
            if (!parameter.has(1)) {
                throw new UsageException(this.getUsage());
            }
            try {
                String string = parameter.at(1);
                if (string.equals("-")) {
                    this.reportDBInfo(connection);
                    break block7;
                }
                ResultSetReference resultSetReference = this.getResult(connection, parameter);
                try {
                    this.output(resultSetReference);
                    this.outputMessage("i.selected", resultSetReference.getRecordCount());
                }
                finally {
                    resultSetReference.getResultSet().close();
                }
            }
            catch (SQLException sQLException) {
                throw new CommandException(sQLException);
            }
        }
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    ResultSetReference getResult(Connection connection, Parameter parameter) throws SQLException {
        if (!parameter.has(1)) {
            throw new UsageException(this.getUsage());
        }
        String string = parameter.asString();
        String string2 = parameter.at(1);
        String string3 = parameter.at(2);
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if (string3.equalsIgnoreCase("FULL")) {
                return this.getTableFullDescription(databaseMetaData, string2, string);
            }
            if (string3.equalsIgnoreCase("PK")) {
                return this.getPrimaryKeyInfo(databaseMetaData, string2, string);
            }
            if (string3.equalsIgnoreCase("INDEX")) {
                return this.getIndexInfo(databaseMetaData, string2, string);
            }
            return this.getTableDescription(databaseMetaData, string2, string);
        }
        catch (Throwable throwable) {
            if (throwable instanceof SQLException) {
                throw (SQLException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new CommandException(throwable);
        }
    }

    private ResultSetReference getTableFullDescription(DatabaseMetaData databaseMetaData, String string, String string2) throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug("report table-full-description of : " + string);
        }
        ResultSet resultSet = databaseMetaData.getColumns(null, null, this.convertPattern(string), null);
        try {
            return new ResultSetReference(resultSet, string2);
        }
        catch (Throwable throwable) {
            resultSet.close();
            throw throwable;
        }
    }

    private ResultSetReference getTableDescription(DatabaseMetaData databaseMetaData, String string, String string2) throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug("report table-description of : " + string);
        }
        ResultSet resultSet = databaseMetaData.getColumns(null, null, this.convertPattern(string), null);
        try {
            ResultSetReference resultSetReference = new ResultSetReference(resultSet, string2);
            ColumnOrder columnOrder = resultSetReference.getOrder();
            columnOrder.addOrder(17, Report.getColumnName("sequence"));
            columnOrder.addOrder(4, Report.getColumnName("columnname"));
            columnOrder.addOrder(18, Report.getColumnName("nullable"));
            columnOrder.addOrder(6, Report.getColumnName("type"));
            columnOrder.addOrder(7, Report.getColumnName("size"));
            columnOrder.addOrder(2, Report.getColumnName("schema"));
            return resultSetReference;
        }
        catch (Throwable throwable) {
            resultSet.close();
            throw throwable;
        }
    }

    private ResultSetReference getPrimaryKeyInfo(DatabaseMetaData databaseMetaData, String string, String string2) throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug("report primary-key of : " + string);
        }
        ResultSet resultSet = databaseMetaData.getPrimaryKeys(null, null, this.convertPattern(string));
        try {
            ResultSetReference resultSetReference = new ResultSetReference(resultSet, string2);
            ColumnOrder columnOrder = resultSetReference.getOrder();
            columnOrder.addOrder(1, Report.getColumnName("catalog"));
            columnOrder.addOrder(2, Report.getColumnName("schema"));
            columnOrder.addOrder(3, Report.getColumnName("tablename"));
            columnOrder.addOrder(5, Report.getColumnName("sequence"));
            columnOrder.addOrder(4, Report.getColumnName("columnname"));
            columnOrder.addOrder(6, Report.getColumnName("keyname"));
            return resultSetReference;
        }
        catch (Throwable throwable) {
            resultSet.close();
            throw throwable;
        }
    }

    private ResultSetReference getIndexInfo(DatabaseMetaData databaseMetaData, String string, String string2) throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug("report index of : " + string);
        }
        ResultSet resultSet = databaseMetaData.getIndexInfo(null, null, this.convertPattern(string), false, false);
        try {
            ResultSetReference resultSetReference = new ResultSetReference(resultSet, string2);
            ColumnOrder columnOrder = resultSetReference.getOrder();
            columnOrder.addOrder(1, Report.getColumnName("catalog"));
            columnOrder.addOrder(2, Report.getColumnName("schema"));
            columnOrder.addOrder(3, Report.getColumnName("tablename"));
            columnOrder.addOrder(8, Report.getColumnName("sequence"));
            columnOrder.addOrder(9, Report.getColumnName("columnname"));
            columnOrder.addOrder(6, Report.getColumnName("keyname"));
            return resultSetReference;
        }
        catch (Throwable throwable) {
            resultSet.close();
            throw throwable;
        }
    }

    private void reportDBInfo(Connection connection) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("report dbinfo");
        }
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string = databaseMetaData.getUserName();
        this.outputMessage("Report.dbinfo", databaseMetaData.getDatabaseProductName(), databaseMetaData.getDatabaseProductVersion(), databaseMetaData.getDriverName(), databaseMetaData.getDriverVersion(), string == null ? "" : string, databaseMetaData.getURL());
    }

    private static String getColumnName(String string) {
        return Report.getMessage("Report.label." + string, new Object[0]);
    }
}

