/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.argius.stew.Bootstrap;
import net.argius.stew.Connector;
import net.argius.stew.DaemonThreadFactory;
import net.argius.stew.Environment;
import net.argius.stew.Logger;
import net.argius.stew.ResourceManager;
import net.argius.stew.text.TextUtilities;
import net.argius.stew.ui.window.AnyAction;
import net.argius.stew.ui.window.AnyActionEvent;
import net.argius.stew.ui.window.AnyActionKey;
import net.argius.stew.ui.window.AnyActionListener;
import net.argius.stew.ui.window.ClipboardHelper;
import net.argius.stew.ui.window.ConsoleTextArea;
import net.argius.stew.ui.window.ResultSetTable;
import net.argius.stew.ui.window.TextSearch;
import net.argius.stew.ui.window.Utilities;
import net.argius.stew.ui.window.WindowOutputProcessor;

final class DatabaseInfoTree
extends JTree
implements AnyActionListener,
TextSearch {
    private static final Logger log = Logger.getLogger(DatabaseInfoTree.class);
    private static final ResourceManager res = ResourceManager.getInstance(DatabaseInfoTree.class);
    static volatile boolean showColumnNumber;
    private Connector currentConnector;
    private DatabaseMetaData dbmeta;
    private AnyActionListener anyActionListener;

    DatabaseInfoTree(AnyActionListener anyActionListener) {
        this.anyActionListener = anyActionListener;
        this.setRootVisible(false);
        this.setShowsRootHandles(false);
        this.setScrollsOnExpand(true);
        this.setCellRenderer(new Renderer());
        this.setModel(new DefaultTreeModel(null));
        int n = Utilities.getMenuShortcutKeyMask();
        AnyAction anyAction = new AnyAction(this);
        anyAction.bindKeyStroke(false, (Object)AnyActionKey.copy, KeyStroke.getKeyStroke(67, n));
        anyAction.bindSelf((Object)ActionKey.copySimpleName, KeyStroke.getKeyStroke(67, n | 0x200));
        anyAction.bindSelf((Object)ActionKey.copyFullName, KeyStroke.getKeyStroke(67, n | 0x40));
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.getID() == 500 && mouseEvent.getClickCount() % 2 == 0) {
            this.anyActionPerformed(new AnyActionEvent((Object)this, (Object)ActionKey.jumpToColumnByName, new Object[0]));
        }
    }

    @Override
    public void anyActionPerformed(AnyActionEvent anyActionEvent) {
        block23: {
            log.atEnter("anyActionPerformed", anyActionEvent);
            if (anyActionEvent.isAnyOf(new Object[]{ActionKey.copySimpleName})) {
                this.copySimpleName();
            } else if (anyActionEvent.isAnyOf(new Object[]{ActionKey.copyFullName})) {
                this.copyFullName();
            } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.refresh})) {
                for (TreePath treePath : this.getSelectionPaths()) {
                    this.refresh((InfoNode)treePath.getLastPathComponent());
                }
            } else if (anyActionEvent.isAnyOf(new Object[]{ActionKey.generateWherePhrase})) {
                ArrayList<ColumnNode> arrayList = new ArrayList<ColumnNode>();
                for (TreeNode treeNode : this.getSelectionNodes()) {
                    if (!(treeNode instanceof ColumnNode)) continue;
                    arrayList.add((ColumnNode)treeNode);
                }
                String string = DatabaseInfoTree.generateEquivalentJoinClause(arrayList);
                if (string.length() > 0) {
                    this.insertTextIntoTextArea(DatabaseInfoTree.addCommas(string));
                }
            } else if (anyActionEvent.isAnyOf(new Object[]{ActionKey.generateSelectPhrase})) {
                String string = DatabaseInfoTree.generateSelectPhrase(this.getSelectionNodes());
                if (string.length() > 0) {
                    this.insertTextIntoTextArea(string + " WHERE ");
                }
            } else if (anyActionEvent.isAnyOf(new Object[]{ActionKey.generateUpdateStatement, ActionKey.generateInsertStatement})) {
                boolean bl = anyActionEvent.isAnyOf(new Object[]{ActionKey.generateInsertStatement});
                try {
                    String string = DatabaseInfoTree.generateUpdateOrInsertPhrase(this.getSelectionNodes(), bl);
                    if (string.length() <= 0) break block23;
                    if (bl) {
                        this.insertTextIntoTextArea(DatabaseInfoTree.addCommas(string));
                        break block23;
                    }
                    this.insertTextIntoTextArea(string + " WHERE ");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    WindowOutputProcessor.showInformationMessageDialog(this, illegalArgumentException.getMessage(), "");
                }
            } else if (anyActionEvent.isAnyOf(new Object[]{ActionKey.jumpToColumnByName})) {
                this.jumpToColumnByName();
            } else if (anyActionEvent.isAnyOf(new Object[]{ActionKey.toggleShowColumnNumber})) {
                showColumnNumber = !showColumnNumber;
                this.repaint();
            } else {
                log.warn("not expected: Event=%s", anyActionEvent);
            }
        }
        log.atExit("anyActionPerformed");
    }

    @Override
    public TreePath[] getSelectionPaths() {
        TreePath[] treePathArray = super.getSelectionPaths();
        if (treePathArray == null) {
            return new TreePath[0];
        }
        return treePathArray;
    }

    List<TreeNode> getSelectionNodes() {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        for (TreePath treePath : this.getSelectionPaths()) {
            arrayList.add((TreeNode)treePath.getLastPathComponent());
        }
        return arrayList;
    }

    private void insertTextIntoTextArea(String string) {
        AnyActionEvent anyActionEvent = new AnyActionEvent((Object)this, (Object)ConsoleTextArea.ActionKey.insertText, string);
        this.anyActionListener.anyActionPerformed(anyActionEvent);
    }

    private void copySimpleName() {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(treePathArray.length);
        for (TreePath treePath : treePathArray) {
            if (treePath == null) continue;
            Object object = treePath.getLastPathComponent();
            assert (object instanceof InfoNode);
            String string = object instanceof ColumnNode ? ((ColumnNode)object).getName() : (object instanceof TableNode ? ((TableNode)object).getName() : object.toString());
            arrayList.add(string);
        }
        ClipboardHelper.setStrings(arrayList);
    }

    private void copyFullName() {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(treePathArray.length);
        for (TreePath treePath : treePathArray) {
            if (treePath == null) continue;
            Object object = treePath.getLastPathComponent();
            assert (object instanceof InfoNode);
            arrayList.add(((InfoNode)object).getNodeFullName());
        }
        ClipboardHelper.setStrings(arrayList);
    }

    private void jumpToColumnByName() {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return;
        }
        TreePath treePath = treePathArray[0];
        Object object = treePath.getLastPathComponent();
        if (object instanceof ColumnNode) {
            ColumnNode columnNode = (ColumnNode)object;
            AnyActionEvent anyActionEvent = new AnyActionEvent((Object)this, (Object)ResultSetTable.ActionKey.jumpToColumn, columnNode.getName());
            this.anyActionListener.anyActionPerformed(anyActionEvent);
        }
    }

    private static String addCommas(String string) {
        int n = 0;
        for (char c : string.toCharArray()) {
            if (c != '?') continue;
            ++n;
        }
        if (n >= 1) {
            return String.format("%s;%s", string, TextUtilities.join("", Collections.nCopies(n - 1, ",")));
        }
        return string;
    }

    static String generateEquivalentJoinClause(List<ColumnNode> list) {
        if (list.isEmpty()) {
            return "";
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        ListMap listMap = new ListMap();
        for (ColumnNode arrayList2 : list) {
            String string = arrayList2.getTableNode().getNodeFullName();
            String string2 = arrayList2.getName();
            linkedHashSet.add(string);
            listMap.add(string2, String.format("%s.%s", string, string2));
        }
        assert (linkedHashSet.size() >= 1);
        ArrayList arrayList = new ArrayList();
        if (linkedHashSet.size() == 1) {
            for (ColumnNode columnNode : list) {
                arrayList.add(String.format("%s=?", columnNode.getName()));
            }
        } else {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (Map.Entry entry : listMap.entrySet()) {
                List list2 = (List)entry.getValue();
                int n = list2.size();
                assert (n >= 1);
                arrayList2.add(String.format("%s=?", list2.get(0)));
                if (n < 2) continue;
                for (int i = 0; i < n; ++i) {
                    for (int j = i + 1; j < n; ++j) {
                        arrayList.add(String.format("%s=%s", list2.get(i), list2.get(j)));
                    }
                }
            }
            arrayList.addAll(arrayList2);
        }
        return String.format("%s", TextUtilities.join(" AND ", arrayList));
    }

    static String generateSelectPhrase(List<TreeNode> list) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        ListMap listMap = new ListMap();
        for (TreeNode object2 : list) {
            Map.Entry entry;
            if (object2 instanceof TableNode) {
                entry = ((TableNode)object2).getNodeFullName();
                linkedHashSet.add((String)((Object)entry));
                listMap.add((String)((Object)entry), new String[0]);
                continue;
            }
            if (!(object2 instanceof ColumnNode)) continue;
            entry = (ColumnNode)object2;
            String string = ((ColumnNode)((Object)entry)).getTableNode().getNodeFullName();
            linkedHashSet.add(string);
            listMap.add(string, ((ColumnNode)((Object)entry)).getNodeFullName());
        }
        if (linkedHashSet.isEmpty()) {
            return "";
        }
        ArrayList arrayList = new ArrayList();
        if (linkedHashSet.size() == 1) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (TreeNode treeNode : list) {
                if (!(treeNode instanceof ColumnNode)) continue;
                ColumnNode columnNode = (ColumnNode)treeNode;
                arrayList2.add(columnNode.getName());
            }
            if (arrayList2.isEmpty()) {
                arrayList.add("*");
            } else {
                arrayList.addAll(arrayList2);
            }
        } else {
            for (Map.Entry entry : listMap.entrySet()) {
                List list2 = (List)entry.getValue();
                if (list2.isEmpty()) {
                    arrayList.add((String)entry.getKey() + ".*");
                    continue;
                }
                arrayList.addAll(list2);
            }
        }
        return String.format("SELECT %s FROM %s", TextUtilities.join(", ", arrayList), TextUtilities.join(", ", linkedHashSet));
    }

    static String generateUpdateOrInsertPhrase(List<TreeNode> list, boolean bl) {
        Object n;
        Object object;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        ListMap listMap = new ListMap();
        for (TreeNode object32 : list) {
            if (object32 instanceof TableNode) {
                object = ((TableNode)object32).getNodeFullName();
                linkedHashSet.add((String)object);
                listMap.add((String)object, new String[0]);
                continue;
            }
            if (!(object32 instanceof ColumnNode)) continue;
            object = (ColumnNode)object32;
            n = ((ColumnNode)object).getTableNode().getNodeFullName();
            linkedHashSet.add((String)n);
            listMap.add((String)n, ((ColumnNode)object).getName());
        }
        if (linkedHashSet.isEmpty()) {
            return "";
        }
        if (linkedHashSet.size() >= 2) {
            throw new IllegalArgumentException(res.get("e.enables-select-just-1-table", new Object[0]));
        }
        String string = TextUtilities.join("", linkedHashSet);
        List list2 = (List)listMap.get(string);
        if (list2.isEmpty()) {
            if (bl) {
                object = new ArrayList<TableNode>();
                n = list.iterator();
                while (n.hasNext()) {
                    TreeNode i = n.next();
                    if (!(i instanceof TableNode)) continue;
                    object.add((TableNode)i);
                    break;
                }
                if (((DefaultMutableTreeNode)(n = (TableNode)object.get(0))).getChildCount() == 0) {
                    throw new IllegalArgumentException(res.get("i.can-only-use-after-tablenode-expanded", new Object[0]));
                }
                int string2 = ((DefaultMutableTreeNode)n).getChildCount();
                for (int iterator = 0; iterator < string2; ++iterator) {
                    ColumnNode columnNode = (ColumnNode)((DefaultMutableTreeNode)n).getChildAt(iterator);
                    list2.add(columnNode.getName());
                }
            } else {
                return "";
            }
        }
        if (bl) {
            int n2 = list2.size();
            object = String.format("INSERT INTO %s (%s) VALUES (%s)", string, TextUtilities.join(",", list2), TextUtilities.join(",", Collections.nCopies(n2, "?")));
        } else {
            n = new ArrayList();
            for (String string2 : list2) {
                n.add(string2 + "=?");
            }
            object = String.format("UPDATE %s SET %s", string, TextUtilities.join(", ", n));
        }
        return object;
    }

    @Override
    public boolean search(TextSearch.Matcher matcher) {
        return this.search(DatabaseInfoTree.resolveTargetPath(this.getSelectionPath()), matcher);
    }

    private static TreePath resolveTargetPath(TreePath treePath) {
        TreePath treePath2;
        if (treePath != null && (treePath2 = treePath.getParentPath()) != null) {
            return treePath2;
        }
        return treePath;
    }

    private boolean search(TreePath treePath, TextSearch.Matcher matcher) {
        if (treePath == null) {
            return false;
        }
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (treeNode == null) {
            return false;
        }
        boolean bl = false;
        bl = matcher.find(treeNode.toString());
        if (bl) {
            this.addSelectionPath(treePath);
        } else {
            this.removeSelectionPath(treePath);
        }
        if (!treeNode.isLeaf() && treeNode.getChildCount() >= 0) {
            ArrayList<? extends TreeNode> arrayList = Collections.list(treeNode.children());
            for (DefaultMutableTreeNode defaultMutableTreeNode : arrayList) {
                if (!this.search(treePath.pathByAddingChild(defaultMutableTreeNode), matcher)) continue;
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void reset() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshRoot(Environment environment) throws SQLException {
        block11: {
            Connector connector = environment.getCurrentConnector();
            if (connector == null) {
                if (log.isDebugEnabled()) {
                    log.debug("not connected");
                }
                this.currentConnector = null;
                return;
            }
            if (connector == this.currentConnector && this.getModel().getRoot() != null) {
                if (log.isDebugEnabled()) {
                    log.debug("not changed");
                }
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("updating");
            }
            ConnectorNode connectorNode = new ConnectorNode(connector.getName());
            DefaultTreeModel defaultTreeModel = new DefaultTreeModel(connectorNode);
            this.setModel(defaultTreeModel);
            DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
            defaultTreeSelectionModel.setSelectionMode(4);
            this.setSelectionModel(defaultTreeSelectionModel);
            final DatabaseMetaData databaseMetaData = environment.getCurrentConnection().getMetaData();
            final HashSet<ConnectorNode> hashSet = new HashSet<ConnectorNode>();
            this.expandNode(connectorNode, databaseMetaData);
            hashSet.add(connectorNode);
            this.addTreeWillExpandListener(new TreeWillExpandListener(){

                @Override
                public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                    TreePath treePath = treeExpansionEvent.getPath();
                    Object object = treePath.getLastPathComponent();
                    if (!hashSet.contains(object)) {
                        InfoNode infoNode = (InfoNode)object;
                        if (infoNode.isLeaf()) {
                            return;
                        }
                        hashSet.add(infoNode);
                        try {
                            DatabaseInfoTree.this.expandNode(infoNode, databaseMetaData);
                        }
                        catch (SQLException sQLException) {
                            throw new RuntimeException(sQLException);
                        }
                    }
                }

                @Override
                public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                }
            });
            this.dbmeta = databaseMetaData;
            defaultTreeModel.reload();
            this.setRootVisible(true);
            this.currentConnector = connector;
            try {
                File file = Bootstrap.getSystemFile("autoexpansion.tsv");
                if (!file.exists() || file.length() <= 0L) break block11;
                AnyAction anyAction = new AnyAction(this);
                Scanner scanner = new Scanner(file);
                try {
                    while (scanner.hasNextLine()) {
                        String string = scanner.nextLine();
                        if (string.matches("^\\s*#.*")) continue;
                        anyAction.doParallel("expandNodes", Arrays.asList(string.split("\t")));
                    }
                }
                finally {
                    scanner.close();
                }
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
    }

    void expandNodes(List<String> list) {
        long l = System.currentTimeMillis();
        AnyAction anyAction = new AnyAction(this);
        int n = 1;
        while (n < list.size()) {
            String string = list.subList(0, n + 1).toString();
            int n2 = this.getRowCount();
            for (int i = 0; i < n2; ++i) {
                TreePath treePath;
                try {
                    treePath = this.getPathForRow(i);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    log.warn(indexOutOfBoundsException);
                    break;
                }
                if (treePath == null || !treePath.toString().equals(string)) continue;
                if (!this.isExpanded(treePath)) {
                    anyAction.doLater("expandLater", treePath);
                    Utilities.sleep(200L);
                }
                ++n;
                break;
            }
            if (System.currentTimeMillis() - l <= 5000L) continue;
            break;
        }
    }

    private void expandLater(TreePath treePath) {
        this.expandPath(treePath);
    }

    void refresh(InfoNode infoNode) {
        if (this.dbmeta == null) {
            return;
        }
        infoNode.removeAllChildren();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        defaultTreeModel.reload(infoNode);
        try {
            this.expandNode(infoNode, this.dbmeta);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    void expandNode(final InfoNode infoNode, final DatabaseMetaData databaseMetaData) throws SQLException {
        if (infoNode.isLeaf()) {
            return;
        }
        final DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        final InfoNode infoNode2 = new InfoNode(res.get("i.paren-in-processing", new Object[0])){

            @Override
            protected List<InfoNode> createChildren(DatabaseMetaData databaseMetaData) throws SQLException {
                return Collections.emptyList();
            }

            @Override
            public boolean isLeaf() {
                return true;
            }
        };
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                defaultTreeModel.insertNodeInto(infoNode2, infoNode, 0);
            }
        });
        DaemonThreadFactory.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    final ArrayList<InfoNode> arrayList = new ArrayList<InfoNode>(infoNode.createChildren(databaseMetaData));
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            for (InfoNode infoNode : arrayList) {
                                defaultTreeModel.insertNodeInto(infoNode, infoNode, infoNode.getChildCount());
                            }
                            defaultTreeModel.removeNodeFromParent(infoNode2);
                        }
                    });
                }
                catch (SQLException sQLException) {
                    try {
                        if (databaseMetaData.getConnection().isClosed()) {
                            return;
                        }
                    }
                    catch (SQLException sQLException2) {
                        sQLException.setNextException(sQLException2);
                    }
                    throw new RuntimeException(sQLException);
                }
            }
        });
    }

    void clear() {
        for (TreeWillExpandListener treeWillExpandListener : (TreeWillExpandListener[])((TreeWillExpandListener[])this.getListeners(TreeWillExpandListener.class)).clone()) {
            this.removeTreeWillExpandListener(treeWillExpandListener);
        }
        this.setModel(new DefaultTreeModel(null));
        this.currentConnector = null;
        this.dbmeta = null;
        if (log.isDebugEnabled()) {
            log.debug("cleared");
        }
    }

    static final class ColumnNode
    extends InfoNode {
        private final String name;
        private final TableNode tableNode;

        ColumnNode(String string, String string2, int n, String string3, TableNode tableNode) {
            super(ColumnNode.format(string, string2, n, string3));
            this.setAllowsChildren(false);
            this.name = string;
            this.tableNode = tableNode;
        }

        String getName() {
            return this.name;
        }

        TableNode getTableNode() {
            return this.tableNode;
        }

        private static String format(String string, String string2, int n, String string3) {
            String string4 = "NO".equals(string3) ? " NOT NULL" : "";
            return String.format("%s [%s(%d)%s]", string, string2, n, string4);
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        protected List<InfoNode> createChildren(DatabaseMetaData databaseMetaData) throws SQLException {
            return Collections.emptyList();
        }

        @Override
        protected String getNodeFullName() {
            return String.format("%s.%s", this.tableNode.getNodeFullName(), this.name);
        }
    }

    static final class TableNode
    extends InfoNode {
        private final String catalog;
        private final String schema;
        private final String name;
        private final boolean kindOfTable;

        TableNode(String string, String string2, String string3, boolean bl) {
            super(string3);
            this.catalog = string;
            this.schema = string2;
            this.name = string3;
            this.kindOfTable = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected List<InfoNode> createChildren(DatabaseMetaData databaseMetaData) throws SQLException {
            ArrayList<InfoNode> arrayList = new ArrayList<InfoNode>();
            ResultSet resultSet = databaseMetaData.getColumns(this.catalog, this.schema, this.name, null);
            try {
                while (resultSet.next()) {
                    arrayList.add(new ColumnNode(resultSet.getString(4), resultSet.getString(6), resultSet.getInt(7), resultSet.getString(18), this));
                }
            }
            finally {
                resultSet.close();
            }
            return arrayList;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        protected String getNodeFullName() {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.catalog != null) {
                arrayList.add(this.catalog);
            }
            if (this.schema != null) {
                arrayList.add(this.schema);
            }
            arrayList.add(this.name);
            return TextUtilities.join(".", arrayList);
        }

        String getName() {
            return this.name;
        }

        boolean isKindOfTable() {
            return this.kindOfTable;
        }
    }

    private static final class TableTypeNode
    extends InfoNode {
        private static final String ICON_NAME_FORMAT = "node-tabletype-%s.png";
        private final String catalog;
        private final String schema;
        private final String tableType;

        TableTypeNode(String string, String string2, String string3) {
            super(string3);
            this.catalog = string;
            this.schema = string2;
            this.tableType = string3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected List<InfoNode> createChildren(DatabaseMetaData databaseMetaData) throws SQLException {
            ArrayList<InfoNode> arrayList = new ArrayList<InfoNode>();
            ResultSet resultSet = databaseMetaData.getTables(this.catalog, this.schema, null, new String[]{this.tableType});
            try {
                while (resultSet.next()) {
                    String string = resultSet.getString(3);
                    String string2 = resultSet.getString(4);
                    boolean bl = string2.matches("TABLE|VIEW|SYNONYM");
                    arrayList.add(new TableNode(this.catalog, this.schema, string, bl));
                }
            }
            finally {
                resultSet.close();
            }
            return arrayList;
        }

        @Override
        String getIconName() {
            String string = String.format(ICON_NAME_FORMAT, this.getUserObject());
            if (this.getClass().getResource("icon/" + string) == null) {
                return String.format(ICON_NAME_FORMAT, "");
            }
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean hasItems(DatabaseMetaData databaseMetaData) throws SQLException {
            ResultSet resultSet = databaseMetaData.getTables(this.catalog, this.schema, null, new String[]{this.tableType});
            try {
                boolean bl = resultSet.next();
                return bl;
            }
            finally {
                resultSet.close();
            }
        }
    }

    private static final class SchemaNode
    extends InfoNode {
        private final String catalog;
        private final String schema;

        SchemaNode(String string, String string2) {
            super(string2);
            this.catalog = string;
            this.schema = string2;
        }

        @Override
        protected List<InfoNode> createChildren(DatabaseMetaData databaseMetaData) throws SQLException {
            ArrayList<InfoNode> arrayList = new ArrayList<InfoNode>();
            arrayList.addAll(SchemaNode.getTableTypeNodes(databaseMetaData, this.catalog, this.schema));
            return arrayList;
        }
    }

    private static final class CatalogNode
    extends InfoNode {
        private final String name;

        CatalogNode(String string) {
            super(string);
            this.name = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected List<InfoNode> createChildren(DatabaseMetaData databaseMetaData) throws SQLException {
            ArrayList<InfoNode> arrayList = new ArrayList<InfoNode>();
            if (databaseMetaData.supportsSchemasInDataManipulation()) {
                ResultSet resultSet = databaseMetaData.getSchemas();
                try {
                    while (resultSet.next()) {
                        arrayList.add(new SchemaNode(this.name, resultSet.getString(1)));
                    }
                }
                finally {
                    resultSet.close();
                }
            } else {
                arrayList.addAll(CatalogNode.getTableTypeNodes(databaseMetaData, this.name, null));
            }
            return arrayList;
        }
    }

    private static class ConnectorNode
    extends InfoNode {
        ConnectorNode(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected List<InfoNode> createChildren(DatabaseMetaData databaseMetaData) throws SQLException {
            ArrayList<InfoNode> arrayList = new ArrayList<InfoNode>();
            if (databaseMetaData.supportsCatalogsInDataManipulation()) {
                ResultSet resultSet = databaseMetaData.getCatalogs();
                try {
                    while (resultSet.next()) {
                        arrayList.add(new CatalogNode(resultSet.getString(1)));
                    }
                }
                finally {
                    resultSet.close();
                }
            } else if (databaseMetaData.supportsSchemasInDataManipulation()) {
                ResultSet resultSet = databaseMetaData.getSchemas();
                try {
                    while (resultSet.next()) {
                        arrayList.add(new SchemaNode(null, resultSet.getString(1)));
                    }
                }
                finally {
                    resultSet.close();
                }
            } else {
                arrayList.addAll(ConnectorNode.getTableTypeNodes(databaseMetaData, null, null));
            }
            return arrayList;
        }
    }

    private static abstract class InfoNode
    extends DefaultMutableTreeNode {
        InfoNode(Object object) {
            super(object, true);
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        protected abstract List<InfoNode> createChildren(DatabaseMetaData var1) throws SQLException;

        String getIconName() {
            String string = this.getClass().getName();
            String string2 = string.replaceFirst(".+?([^\\$]+)Node$", "$1");
            return "node-" + string2.toLowerCase() + ".png";
        }

        protected String getNodeFullName() {
            return String.valueOf(this.userObject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static List<TableTypeNode> getTableTypeNodes(DatabaseMetaData databaseMetaData, String string, String string2) throws SQLException {
            ArrayList<TableTypeNode> arrayList = new ArrayList<TableTypeNode>();
            ResultSet resultSet = databaseMetaData.getTableTypes();
            try {
                while (resultSet.next()) {
                    TableTypeNode tableTypeNode = new TableTypeNode(string, string2, resultSet.getString(1));
                    if (!tableTypeNode.hasItems(databaseMetaData)) continue;
                    arrayList.add(tableTypeNode);
                }
            }
            finally {
                resultSet.close();
            }
            if (arrayList.isEmpty()) {
                arrayList.add(new TableTypeNode(string, string2, "TABLE"));
            }
            return arrayList;
        }
    }

    private static class Renderer
    extends DefaultTreeCellRenderer {
        Renderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            TreePath treePath;
            TreePath treePath2;
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof InfoNode) {
                this.setIcon(Utilities.getImageIcon(((InfoNode)object).getIconName()));
            }
            if (object instanceof ColumnNode && showColumnNumber && (treePath2 = jTree.getPathForRow(n)) != null && (treePath = treePath2.getParentPath()) != null) {
                int n2 = n - jTree.getRowForPath(treePath);
                this.setText(String.format("%d %s", n2, this.getText()));
            }
            return this;
        }
    }

    private static final class ListMap
    extends LinkedHashMap<String, List<String>> {
        ListMap() {
        }

        void add(String string, String ... stringArray) {
            if (this.get(string) == null) {
                this.put(string, new ArrayList());
            }
            for (String string2 : stringArray) {
                ((List)this.get(string)).add(string2);
            }
        }
    }

    static enum ActionKey {
        copySimpleName,
        copyFullName,
        generateWherePhrase,
        generateSelectPhrase,
        generateUpdateStatement,
        generateInsertStatement,
        jumpToColumnByName,
        toggleShowColumnNumber;

    }
}

