/*
 * Decompiled with CFR 0.152.
 */
package net.murakamin.csv;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import net.murakamin.csv.CSVDataHandler;
import net.murakamin.csv.CSVReader;
import net.murakamin.sticker.commands.exception.ImportExecutionException;

public class CSVParser {
    private final CSVDataHandler handler;

    public CSVParser(CSVDataHandler importTarget) {
        this.handler = importTarget;
    }

    public void doParse(File source) throws ImportExecutionException {
        int lineNo = 0;
        String[] currentDatas = null;
        try {
            CSVReader reader = new CSVReader();
            reader.setEncoding(this.handler.getFileCharset());
            reader.setFieldSeparator(this.handler.getSeparator());
            reader.setQuoteChar(this.handler.getQuot());
            reader.setSupportHeader(this.handler.isHeader());
            reader.open(source);
            lineNo = 1;
            while (reader.nextLine()) {
                currentDatas = reader.currentLine();
                this.handler.addCSVData(currentDatas);
                ++lineNo;
            }
        }
        catch (Exception e) {
            throw new ImportExecutionException(e, lineNo, source.toString(), this.handler.getTarget(), currentDatas);
        }
    }

    public void doParse(ResultSet source) throws ImportExecutionException {
        int lineNo = 0;
        String[] currentDatas = null;
        try {
            lineNo = 1;
            while (source.next()) {
                currentDatas = this.parseStrings(source);
                this.handler.addCSVData(currentDatas);
                ++lineNo;
            }
        }
        catch (Exception e) {
            throw new ImportExecutionException(e, lineNo, source.toString(), this.handler.getTarget(), currentDatas);
        }
    }

    private String[] parseStrings(ResultSet rs) throws UnsupportedEncodingException, SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        String[] csvData = null;
        csvData = new String[columnCount];
        int i = 1;
        while (i < columnCount + 1) {
            csvData[i - 1] = rs.getObject(i).toString();
            ++i;
        }
        return csvData;
    }
}

